/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data;

import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.name_regex.StatNameRegex;
import com.robertx22.mine_and_slash.database.data.stats.tooltips.StatTooltipType;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatMod
implements ISerializable<StatMod> {
    public float min = 0.0f;
    public float max = 0.0f;
    public String stat;
    public String type;
    public static StatMod EMPTY = new StatMod();

    private StatMod() {
    }

    public static StatMod percent(float firstMin, float firstMax, Stat stat) {
        StatMod mod = new StatMod();
        mod.min = firstMin;
        mod.max = firstMax;
        mod.stat = stat.GUID();
        mod.type = !stat.IsPercent() ? ModType.PERCENT.name() : ModType.FLAT.name();
        return mod;
    }

    public StatMod(float firstMin, float firstMax, Stat stat) {
        this.min = firstMin;
        this.max = firstMax;
        this.stat = stat.GUID();
        this.type = ModType.FLAT.name();
    }

    public StatMod(float firstMin, float firstMax, String stat, ModType type) {
        this.min = firstMin;
        this.max = firstMax;
        this.stat = stat;
        this.type = type.name();
    }

    public StatMod(float firstMin, float firstMax, Stat stat, ModType type) {
        this.min = firstMin;
        this.max = firstMax;
        this.stat = stat.GUID();
        this.type = type.name();
    }

    public StatMod(float firstMin, float firstMax, float secondMin, float secondMax, String stat, ModType type) {
        this.min = firstMin;
        this.max = firstMax;
        this.stat = stat;
        this.type = type.name();
    }

    public Stat GetStat() {
        return (Stat)ExileDB.Stats().get(this.stat);
    }

    public MutableComponent getRangeToShow(int lvl) {
        float fmin = this.min;
        float fmax = this.max;
        fmin = this.GetStat().scale(this.getModType(), this.min, lvl);
        fmax = this.GetStat().scale(this.getModType(), this.max, lvl);
        Boolean perc = this.GetStat().IsPercent() || this.getModType().isPercent();
        String ptext = perc != false ? "%" : "";
        String text = MMORPG.formatNumber(fmin) + ptext + " -> " + MMORPG.formatNumber(fmax) + ptext;
        if (!perc.booleanValue() && this.getModType() == ModType.MORE) {
            text = fmin > 0.0f ? text + " " + this.GetStat().getMultiUseType().prefixWord.locName().getString() : text + " " + this.GetStat().getMultiUseType().prefixLessWord.locName().getString();
        }
        return ExileText.ofText((String)"(").get().m_130940_(ChatFormatting.GREEN).m_130946_(text).m_130946_(")");
    }

    public ModType getModType() {
        return ModType.fromString(this.type);
    }

    public StatMod percent() {
        this.type = ModType.PERCENT.name();
        return this;
    }

    public StatMod more() {
        this.type = ModType.MORE.name();
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("min", (Number)Float.valueOf(this.min));
        json.addProperty("max", (Number)Float.valueOf(this.max));
        json.addProperty("stat", this.stat);
        json.addProperty("type", ModType.valueOf((String)this.type).id);
        return json;
    }

    public StatMod fromJson(JsonObject json) {
        float firstMin = json.get("min").getAsFloat();
        float firstMax = json.get("max").getAsFloat();
        String stat = json.get("stat").getAsString();
        ModType type = ModType.fromString(json.get("type").getAsString());
        return new StatMod(firstMin, firstMax, stat, type);
    }

    public List<Component> getEstimationTooltip(int lvl) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.GetStat().is_long) {
            return TooltipUtils.cutIfTooLong(ExileText.ofText((String)StatNameRegex.JUST_NAME.translate(ChatFormatting.GREEN, null, this.getModType(), this.min, this.GetStat())).get());
        }
        TooltipStatWithContext c = new TooltipStatWithContext(new TooltipStatInfo(this.ToExactStat(100, lvl), 100, new StatRangeInfo(ModRange.of(new MinMax(0, 100)))), this, lvl);
        c.showNumber = false;
        c.disablestatranges = true;
        Component add = (Component)StatTooltipType.NORMAL.impl.getTooltipList(null, c).get(0);
        MutableComponent txt = this.getRangeToShow(lvl).m_130946_(" ").m_7220_(add);
        list.add((Component)txt);
        StatRangeInfo info = new StatRangeInfo(ModRange.hide());
        if (info.shouldShowDescriptions()) {
            list.addAll(this.GetStat().getCutDescTooltip());
        }
        return list;
    }

    public ExactStatData ToExactStat(int percent, float lvl) {
        return ExactStatData.fromStatModifier(this, percent, lvl);
    }
}

