/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.base;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.base.IRandom;
import com.robertx22.mine_and_slash.database.base.IhasRequirements;
import com.robertx22.mine_and_slash.database.data.requirements.bases.GearRequestedFor;
import java.util.List;
import java.util.stream.Collectors;

public interface IRandomDefault<T extends IhasRequirements & IWeighted>
extends IRandom<T, GearRequestedFor> {
    @Override
    default public T random(GearRequestedFor gearRequestedFor) {
        if (gearRequestedFor.forSlot != null) {
            ExileLog.get().warn("Gear slot doesn't exist, or was renamed.", new Object[0]);
            return null;
        }
        List allThatMeetReq = this.allThatMeetRequirement(this.All(), gearRequestedFor);
        if (allThatMeetReq.size() == 0) {
            ExileLog.get().warn("No Matching item found for the gear requested, returning null.", new Object[0]);
            return null;
        }
        return (T)((IhasRequirements)RandomUtils.weightedRandom(allThatMeetReq));
    }

    @Override
    default public T random() {
        return (T)((IhasRequirements)RandomUtils.weightedRandom(this.All()));
    }

    @Override
    default public List<T> allThatMeetRequirement(List<T> list, GearRequestedFor gearRequestedFor) {
        return list.stream().filter(x -> x.requirements().satisfiesAllRequirements(gearRequestedFor)).collect(Collectors.toList());
    }
}

