/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.AttributeStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.ForgeEvents;
import com.robertx22.mine_and_slash.uncommon.error_checks.base.ErrorChecks;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.Cached;
import com.robertx22.mine_and_slash.vanilla_mc.packets.TellClientResetCaches;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DatabaseCaches {
    public static void init() {
        ForgeEvents.registerForgeEvent(PlayerEvent.PlayerLoggedInEvent.class, x -> Packets.sendToClient((Player)x.getEntity(), (MyPacket)new TellClientResetCaches()));
        ExileEvents.AFTER_DATABASE_LOADED.register((EventConsumer)new EventConsumer<ExileEvents.AfterDatabaseLoaded>(){

            public void accept(ExileEvents.AfterDatabaseLoaded event) {
                DatabaseCaches.resetCaches();
            }
        });
    }

    public static void resetCaches() {
        DatabaseCaches.setupStatsThatAffectVanillaStatsList();
        DatabaseCaches.setupMaxSpellCharges();
        ErrorChecks.getAll().forEach(x -> x.check());
        GearSlot.CACHED = new HashMap();
    }

    private static void setupMaxSpellCharges() {
        Cached.MAX_SPELL_CHARGES = new HashMap();
        for (Spell spell : ExileDB.Spells().getList()) {
            if (spell.config.charges <= 0) continue;
            Cached.MAX_SPELL_CHARGES.put(spell.config.charge_name, spell.config.charges);
        }
    }

    private static void setupStatsThatAffectVanillaStatsList() {
        Cached.VANILLA_STAT_UIDS_TO_CLEAR_EVERY_STAT_CALC = new ArrayList<ImmutablePair<Attribute, UUID>>();
        ExileDB.Stats().getFilterWrapped((Predicate<Stat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setupStatsThatAffectVanillaStatsList$2(com.robertx22.mine_and_slash.database.data.stats.Stat ), (Lcom/robertx22/mine_and_slash/database/data/stats/Stat;)Z)()).list.forEach(x -> {
            AttributeStat attri = (AttributeStat)x;
            Cached.VANILLA_STAT_UIDS_TO_CLEAR_EVERY_STAT_CALC.add((ImmutablePair<Attribute, UUID>)ImmutablePair.of((Object)attri.attribute, (Object)attri.uuid));
        });
    }

    private static /* synthetic */ boolean lambda$setupStatsThatAffectVanillaStatsList$2(Stat x) {
        return x instanceof AttributeStat;
    }
}

