/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge.compat;

import com.robertx22.mine_and_slash.config.forge.compat.CompatConfigPreset;
import com.robertx22.mine_and_slash.config.forge.compat.CompatData;
import com.robertx22.mine_and_slash.config.forge.compat.CompatDummy;
import com.robertx22.mine_and_slash.config.forge.compat.IRestrictedConfig;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CompatConfig {
    public static final ForgeConfigSpec spec;
    public static final CompatConfig CONTAINER;
    private HashMap<CompatConfigPreset, CompatData> map = new HashMap();
    private ForgeConfigSpec.EnumValue<CompatConfigPreset> COMPATIBILITY_PRESETS;

    public static CompatDummy get() {
        if (!IRestrictedConfig.compatModeIsInstalled()) {
            return CompatConfigPreset.ORIGINAL_MODE.defaults;
        }
        CompatConfigPreset c = (CompatConfigPreset)CompatConfig.CONTAINER.COMPATIBILITY_PRESETS.get();
        return CompatConfig.CONTAINER.map.get(c);
    }

    CompatConfig(ForgeConfigSpec.Builder b) {
        b.comment("Compatibility Presets. Unlocked by installing the Compatibility addon");
        if (IRestrictedConfig.compatModeIsInstalled()) {
            this.COMPATIBILITY_PRESETS = b.defineEnum("COMPATIBILITY_PRESETS", (Enum)CompatConfigPreset.ORIGINAL_MODE);
            b.comment("It's advised to ONLY pick a COMPATIBILITY_PRESETS and not mess further with the configs.").push("compatibility_configs");
            for (CompatConfigPreset preset : CompatConfigPreset.values()) {
                b.comment(preset.comment);
                b.push(preset.name());
                CompatData data = new CompatData();
                data.build(b, preset.defaults);
                this.map.put(preset, data);
                b.pop();
            }
        } else {
            b.define("addon_link", (Object)"https://www.curseforge.com/minecraft/mc-mods/mine-and-slash-compatibility");
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(b -> new CompatConfig((ForgeConfigSpec.Builder)b));
        spec = (ForgeConfigSpec)specPair.getRight();
        CONTAINER = (CompatConfig)specPair.getLeft();
    }
}

