/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge;

import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.InteractionResultHandler;
import com.robertx22.mine_and_slash.config.forge.GuiBarRenderOption;
import com.robertx22.mine_and_slash.config.forge.compat.DamageNumbersEnum;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayConfig;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayConfigBuilder;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayPresets;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayType;
import com.robertx22.mine_and_slash.gui.overlays.GuiPosition;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayerGUIs;
import java.util.HashMap;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfigs {
    public static final ForgeConfigSpec clientSpec;
    public static final ClientConfigs CLIENT;
    public HashMap<OverlayPresets.PresetEnum, OverlayConfig> OVERLAY_PRESETS = new HashMap();
    public HashMap<OverlayType, ForgeConfigSpec.EnumValue<OverlayPresets.PresetEnum>> OVERLAY_CONFIGS = new HashMap();
    public ForgeConfigSpec.BooleanValue SHOW_LOW_ENERGY_MANA_WARNING;
    public ForgeConfigSpec.EnumValue<DamageNumbersEnum> ENABLE_FLOATING_DMG;
    public ForgeConfigSpec.BooleanValue RENDER_SIMPLE_MOB_BAR;
    public ForgeConfigSpec.BooleanValue RENDER_DEATH_STATISTICS;
    public ForgeConfigSpec.BooleanValue RENDER_ITEM_RARITY_BACKGROUND;
    public ForgeConfigSpec.BooleanValue SHOW_DURABILITY;
    public ForgeConfigSpec.BooleanValue RENDER_MOB_HEALTH_GUI;
    public ForgeConfigSpec.BooleanValue ONLY_RENDER_MOB_LOOKED_AT;
    public ForgeConfigSpec.BooleanValue MODIFY_TOOLTIP_LENGTH;
    public ForgeConfigSpec.BooleanValue IN_DEPTH_TOOLTIPS_BY_DEFAULT;
    public ForgeConfigSpec.BooleanValue HOTBAR_SWAPPING;
    public ForgeConfigSpec.BooleanValue HIDE_SPELL_HOTBAR_WHEN_NO_SPELL;
    public ForgeConfigSpec.BooleanValue USE_SPELL_ANIMATIONS;
    public ForgeConfigSpec.EnumValue<GuiBarRenderOption> RENDER_FILLED_GUI_BARS;
    public ForgeConfigSpec.EnumValue<HorizontalOrVertical> STATUS_EFFECTS_OVERLAY_TYPE;
    public ForgeConfigSpec.EnumValue<HorizontalOrVertical> SPELL_HOTBAR_OVERLAY_TYPE;
    public ForgeConfigSpec.EnumValue<GlintType> ITEM_RARITY_BACKGROUND_TYPE;
    public ForgeConfigSpec.EnumValue<GuiPosition> GUI_POSITION;
    public ForgeConfigSpec.EnumValue<PlayerGUIs> PLAYER_GUI_TYPE;
    public ForgeConfigSpec.EnumValue<InteractionResultHandler.ClientSpawnStrategy> DAMAGE_PARTICLE_STYLE;
    public ForgeConfigSpec.DoubleValue ITEM_RARITY_OPACITY;
    public ForgeConfigSpec.DoubleValue HEALTH_BAR_GUI_SCALE;
    public ForgeConfigSpec.DoubleValue SKILL_TREE_ZOOM_SPEED;
    public ForgeConfigSpec.DoubleValue SPELL_PARTICLE_MULTI;
    public ForgeConfigSpec.DoubleValue DONT_CULL_PARTICLES_UNDER;
    public ForgeConfigSpec.IntValue REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES;
    public ForgeConfigSpec.IntValue SHOW_DECIMALS_ON_NUMBER_SMALLER_THAN;
    public ForgeConfigSpec.BooleanValue ENABLE_QUICK_LOOT_BUTTON;
    public ForgeConfigSpec.ConfigValue<Integer> QUICK_LOOT_BUTTON_X_OFFSET;
    public ForgeConfigSpec.ConfigValue<Integer> QUICK_LOOT_BUTTON_Y_OFFSET;

    ClientConfigs(ForgeConfigSpec.Builder b) {
        b.comment("Client Configs").push("general");
        this.SHOW_LOW_ENERGY_MANA_WARNING = b.define("show_low_mana_warning", true);
        this.RENDER_SIMPLE_MOB_BAR = b.define("render_mob_bar", true);
        this.RENDER_DEATH_STATISTICS = b.define("render_death_stats", true);
        this.RENDER_ITEM_RARITY_BACKGROUND = b.define("render_item_rarity_background", true);
        this.SHOW_DURABILITY = b.define("show_durability", true);
        this.RENDER_MOB_HEALTH_GUI = b.define("render_mob_hp_gui", true);
        this.ONLY_RENDER_MOB_LOOKED_AT = b.define("only_render_mob_looked_at", true);
        this.ENABLE_FLOATING_DMG = b.defineEnum("render_floating_damage", (Enum)DamageNumbersEnum.DEFAULT);
        this.MODIFY_TOOLTIP_LENGTH = b.define("MODIFY_TOOLTIP_LENGTH", true);
        this.IN_DEPTH_TOOLTIPS_BY_DEFAULT = b.define("IN_DEPTH_TOOLTIPS_BY_DEFAULT", true);
        this.USE_SPELL_ANIMATIONS = b.comment("Use player animations when casting mns spells. Disable in case of other animation mod incompatibility").define("USE_SPELL_ANIMATIONS", true);
        this.RENDER_FILLED_GUI_BARS = b.comment("If false, gui bars will only render when they aren't full").defineEnum("RENDER_FILLED_GUI_BARS", (Enum)GuiBarRenderOption.DEFAULT);
        this.ITEM_RARITY_OPACITY = b.defineInRange("ITEM_RARITY_OPACITY", 0.75, 0.0, 1.0);
        this.HEALTH_BAR_GUI_SCALE = b.defineInRange("health_bar_gui_scale", 1.25, 0.0, 10.0);
        this.SPELL_PARTICLE_MULTI = b.defineInRange("SPELL_PARTICLE_MULTI", 1.0, (double)0.1f, 1.0);
        this.DONT_CULL_PARTICLES_UNDER = b.defineInRange("DONT_CULL_PARTICLES_UNDER", 50.0, 0.0, 5000.0);
        this.HOTBAR_SWAPPING = b.comment("When OFF: 8 bars, 8 keybinds. When ON: 4 bars, 5 keybinds(4 for each bar, 1 for hotbar swap button)").define("HOTBAR_SWAPPING", false);
        this.HIDE_SPELL_HOTBAR_WHEN_NO_SPELL = b.define("hide_spell_hotbar_when_no_spell", true);
        this.GUI_POSITION = b.defineEnum("GUI_POSITION", (Enum)GuiPosition.TOP_LEFT);
        this.ITEM_RARITY_BACKGROUND_TYPE = b.defineEnum("ITEM_RARITY_BACKGROUND_TYPE", (Enum)GlintType.FULL);
        this.PLAYER_GUI_TYPE = b.defineEnum("PLAYER_GUI_TYPE", (Enum)PlayerGUIs.RPG);
        this.DAMAGE_PARTICLE_STYLE = b.defineEnum("DAMAGE_PARTICLE_STYLE", (Enum)InteractionResultHandler.ClientSpawnStrategy.DEFAULT);
        this.SKILL_TREE_ZOOM_SPEED = b.defineInRange("SKILL_TREE_ZOOM_SPEED", 0.15, 1.0E-6, 1.0);
        this.REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES = b.defineInRange("REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES", 45, 0, 1000);
        this.SHOW_DECIMALS_ON_NUMBER_SMALLER_THAN = b.defineInRange("SHOW_DECIMALS_ON_NUMBER_SMALLER_THAN", 15, 0, 1000000);
        b.comment("Overlays").push("overlays");
        this.STATUS_EFFECTS_OVERLAY_TYPE = b.defineEnum("STATUS_EFFECTS_OVERLAY_TYPE", (Enum)HorizontalOrVertical.HORIZONTAL);
        this.SPELL_HOTBAR_OVERLAY_TYPE = b.defineEnum("SPELL_HOTBAR_OVERLAY_TYPE", (Enum)HorizontalOrVertical.VERTICAL);
        for (OverlayConfigBuilder preset : OverlayPresets.ALL_PRESETS) {
            this.OVERLAY_PRESETS.put(preset.preset, new OverlayConfig(b, preset));
        }
        for (OverlayType type : OverlayType.values()) {
            if (type.getDefaultConfig() == null) continue;
            this.OVERLAY_CONFIGS.put(type, (ForgeConfigSpec.EnumValue<OverlayPresets.PresetEnum>)b.defineEnum(type.name() + "_CONFIG", (Enum)type.getDefaultConfig()));
        }
        b.pop();
        b.comment("Buttons").push("buttons");
        this.ENABLE_QUICK_LOOT_BUTTON = b.define("enable_quick_loot_button", true);
        this.QUICK_LOOT_BUTTON_X_OFFSET = b.define("quick_loot_button_x_offset", (Object)0);
        this.QUICK_LOOT_BUTTON_Y_OFFSET = b.define("quick_loot_button_y_offset", (Object)0);
        b.pop();
    }

    public OverlayConfig getOverlayConfig(OverlayType type) {
        OverlayPresets.PresetEnum preset = (OverlayPresets.PresetEnum)((Object)this.OVERLAY_CONFIGS.get((Object)type).get());
        return this.OVERLAY_PRESETS.get((Object)preset);
    }

    public boolean shouldRenderOverlay(OverlayType type) {
        OverlayPresets.PresetEnum preset = (OverlayPresets.PresetEnum)((Object)this.OVERLAY_CONFIGS.get((Object)type).get());
        return preset != OverlayPresets.PresetEnum.DISABLE_OVERLAY;
    }

    public static ClientConfigs getConfig() {
        return CLIENT;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfigs::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfigs)specPair.getLeft();
    }

    public static enum GlintType {
        BORDER,
        FULL;

    }

    public static enum HorizontalOrVertical {
        HORIZONTAL,
        VERTICAL;

    }
}

