/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.characters;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.characters.CharStorageData;
import com.robertx22.mine_and_slash.characters.CharacterData;
import com.robertx22.mine_and_slash.characters.CreateCharPacket;
import com.robertx22.mine_and_slash.characters.reworked_gui.ToonActionButton;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ToonActionPacket
extends MyPacket<CreateCharPacket> {
    int num;
    ToonActionButton.Action act;
    String name;

    public ToonActionPacket(ToonActionButton.Action act, Integer num, String name) {
        this.num = num;
        this.act = act;
        this.name = name;
    }

    public ResourceLocation getIdentifier() {
        return SlashRef.id("toon_action");
    }

    public void loadFromData(FriendlyByteBuf buf) {
        this.num = buf.readInt();
        this.act = (ToonActionButton.Action)buf.m_130066_(ToonActionButton.Action.class);
        this.name = buf.m_130277_();
    }

    public void saveToData(FriendlyByteBuf buf) {
        buf.writeInt(this.num);
        buf.m_130068_((Enum)this.act);
        buf.m_130070_(this.name);
    }

    public void onReceived(ExilePacketContext ctx) {
        CharStorageData chars = Load.player((Player)ctx.getPlayer()).characters;
        int current = chars.current;
        Player p = ctx.getPlayer();
        if (chars.canChangeCharactersRightNow(ctx.getPlayer())) {
            CharacterData opt = chars.map.get(this.num);
            if (opt != null) {
                if (this.act == ToonActionButton.Action.LOAD) {
                    if (this.num == current) {
                        p.m_213846_((Component)Chats.CANT_LOAD_CURRENT_CHAT.locName().m_130940_(ChatFormatting.RED));
                    } else {
                        chars.load(this.num, ctx.getPlayer());
                    }
                }
                if (this.act == ToonActionButton.Action.DELETE) {
                    if (this.num == current) {
                        p.m_213846_((Component)Chats.CANT_DEL_CURRENT_CHAT.locName().m_130940_(ChatFormatting.RED));
                    } else {
                        chars.map.remove(this.num);
                    }
                }
                if (this.act == ToonActionButton.Action.RENAME && chars.nameIsValid(p, this.name)) {
                    chars.map.get((Object)Integer.valueOf((int)this.num)).name = this.name;
                }
            }
            Load.player((Player)ctx.getPlayer()).playerDataSync.setDirty();
        }
    }

    public MyPacket<CreateCharPacket> newInstance() {
        return new ToonActionPacket(ToonActionButton.Action.LOAD, -1, "");
    }
}

