/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.commands.auto_salvage.AutoSalvageGenericConfigure;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerConfigData {
    public AutoSalvage salvage = new AutoSalvage();
    public HashMap<String, Boolean> configs = new HashMap();

    public boolean isConfigEnabled(Config id) {
        return this.configs.getOrDefault(id.id, false);
    }

    public void onLoginFillDefaults() {
        for (Config value : Config.values()) {
            if (this.configs.containsKey(value.id)) continue;
            this.configs.put(value.id, (Boolean)ServerContainer.get().defaultFeatureConfigs.get((Object)value).get());
        }
    }

    public class AutoSalvage {
        private HashMap<ToggleAutoSalvageRarity.SalvageType, HashMap<String, Boolean>> map = new HashMap();
        private HashMap<ToggleAutoSalvageRarity.SalvageType, HashMap<String, Boolean>> tmap = new HashMap();

        public HashMap<ToggleAutoSalvageRarity.SalvageType, HashMap<String, Boolean>> getTMap() {
            if (this.tmap == null) {
                this.tmap = new HashMap();
            }
            return this.tmap;
        }

        public boolean trySalvageOnPickup(Player player, ItemStack stack) {
            ExileStack ex = ExileStack.of(stack);
            if (stack.m_41793_()) {
                return false;
            }
            if (ex.get(StackKeys.DROPPED).hasAndTrue(x -> x.forcedDrop)) {
                return false;
            }
            ICommonDataItem data = ICommonDataItem.load(stack);
            boolean doSalvage = false;
            if (data != null) {
                if (data.isSalvagable(ex)) {
                    Optional<Boolean> typeSalvageEnabled = this.checkTypeSalvageConfig(data.getSalvageType(), data.getSalvageConfigurationId());
                    if (typeSalvageEnabled.isEmpty()) {
                        if (this.checkRaritySalvageConfig(data.getSalvageType(), data.getRarityId())) {
                            doSalvage = true;
                        }
                    } else {
                        doSalvage = typeSalvageEnabled.get();
                    }
                }
                if (doSalvage) {
                    SoundUtils.playSound((Entity)player, (SoundEvent)SoundEvents.f_11871_, (float)0.75f, (float)1.25f);
                    Profession salvagingProfession = (Profession)ExileDB.Professions().get("salvaging");
                    if (salvagingProfession != null) {
                        Load.player((Player)player).professions.addExp(player, salvagingProfession.GUID(), data.getAutoSalvageExpReward(), false);
                    }
                    boolean shouldAutoSalvageDrop = Load.player((Player)player).config.isConfigEnabled(Config.AUTO_SALVAGE_DROP);
                    stack.m_41774_(stack.m_41613_() + 100);
                    data.getSalvageResult(ex).forEach(e -> {
                        Backpacks backpacks = Load.backpacks(player).getBackpacks();
                        if (shouldAutoSalvageDrop) {
                            PlayerUtils.spawnAtPlayer(e, player);
                            return;
                        }
                        if (backpacks.tryAutoPickup(player, (ItemStack)e, false)) {
                            return;
                        }
                        PlayerUtils.giveItem(e, player);
                    });
                    return true;
                }
            }
            return false;
        }

        public boolean checkRaritySalvageConfig(ToggleAutoSalvageRarity.SalvageType type, String rar) {
            return this.map.getOrDefault((Object)type, new HashMap()).getOrDefault(rar, false);
        }

        public Optional<Boolean> checkTypeSalvageConfig(ToggleAutoSalvageRarity.SalvageType type, String id) {
            if (id == null) {
                return Optional.empty();
            }
            if (!this.getTMap().containsKey((Object)type)) {
                return Optional.empty();
            }
            if (this.getTMap().containsKey((Object)type) && !this.getTMap().get((Object)type).containsKey(id)) {
                return Optional.empty();
            }
            return Optional.of(this.tmap.get((Object)type).get(id));
        }

        public void toggleRaritySalvageConfig(ToggleAutoSalvageRarity.SalvageType type, String rarity) {
            boolean bool;
            HashMap<String, Boolean> m2;
            if (!this.map.containsKey((Object)type)) {
                this.map.put(type, new HashMap());
            }
            if (!(m2 = this.map.get((Object)type)).containsKey(rarity)) {
                m2.put(rarity, false);
            }
            if (bool = m2.get(rarity).booleanValue()) {
                m2.put(rarity, false);
            } else {
                m2.put(rarity, true);
            }
        }

        public void setAutoSalvageForTypeAndId(ToggleAutoSalvageRarity.SalvageType salvageType, String id, AutoSalvageGenericConfigure.AutoSalvageConfigAction action) {
            if (action == AutoSalvageGenericConfigure.AutoSalvageConfigAction.CLEAR) {
                if (!this.getTMap().containsKey((Object)salvageType)) {
                    return;
                }
                HashMap<String, Boolean> idMap = this.tmap.get((Object)salvageType);
                idMap.remove(id);
                return;
            }
            if (!this.tmap.containsKey((Object)salvageType)) {
                this.getTMap().put(salvageType, new HashMap());
            }
            this.getTMap().get((Object)salvageType).put(id, action == AutoSalvageGenericConfigure.AutoSalvageConfigAction.ENABLE);
        }

        public HashMap<String, Boolean> getConfiguredMapForSalvageType(ToggleAutoSalvageRarity.SalvageType salvageType) {
            return this.getTMap().getOrDefault((Object)salvageType, new HashMap());
        }
    }

    public static enum Config {
        CAST_FAIL("cast_fail_messages", true, Words.TITLE_FEATURE_CAST_FAIL, Words.CAST_FAIL_MSGS, false),
        MOB_DEATH_MESSAGES("mob_death_messages", false, Words.TITLE_FEATURE_MOB_KILL_LOOT, Words.MOB_DEATH_MESSAGES, false),
        EXP_CHAT_MESSAGES("exp_chat_messages", false, Words.TITLE_FEATURE_EXP_MSG, Words.EXP_CHAT_MESSAGES, false),
        DAMAGE_MESSAGES("damage_messages", false, Words.TITLE_FEATURE_DAMAGE_LOG, Words.DAMAGE_MESSAGES, false),
        PROFESSION_MESSAGES("profession_exp_messages", false, Words.TITLE_FEATURE_PROF_EXP, Words.PROFESSION_MESSAGES, false),
        AUTO_PVE("auto_pve", false, Words.TITLE_FEATURE_AUTO_TEAM, Words.AUTOMATIC_PVE, false),
        AGGRESSIVE_SUMMONS("aggressive_summons", true, Words.TITLE_FEATURE_AGGRO_SUMMONS, Words.AGGRESIVE_SUMMONS, false),
        ENABLE_EXP_GAIN("enable_exp_gain", true, Words.TITLE_FEATURE_ENABLE_EXP_GAIN, Words.ENABLE_EXP_GAIN, false),
        AUTO_SALVAGE_DROP("auto_salvage_drop", false, Words.TITLE_FEATURE_AUTO_SALVAGE_DROP, Words.AUTO_SALVAGE_DROP, false),
        STAT_ORDER_TEST("stat_order_test", false, Words.TITLE_FEATURE_STAT_ORDER_DEBUG, Words.STAT_ORDER_TEST, true),
        DAMAGE_CONFLICT_MSG("damage_conflict_check", false, Words.TITLE_FEATURE_DMG_CONFLICT_DEBUG, Words.DMG_CONFLICT_CHECK, true);

        public String id;
        public Words title;
        public Words word;
        public boolean isDebug;
        public boolean enabledByDefault;

        private Config(String id, boolean enabledByDefault, Words title, Words word, boolean isdebug) {
            this.id = id;
            this.title = title;
            this.word = word;
            this.isDebug = isdebug;
            this.enabledByDefault = enabledByDefault;
        }
    }
}

