/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.profession.buffs.StatBuff;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashPotions;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.ExplainedResultUtil;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class PlayerBuffData
implements IStatCtx {
    public HashMap<Type, Buff> map = new HashMap();

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        for (Buff buff : this.map.values()) {
            for (ExactStatData stat : buff.stats) {
                stats.add(ExactStatData.copy(stat));
            }
        }
        return Arrays.asList(new SimpleStatCtx(StatContext.StatCtxType.FOOD_BUFF, stats));
    }

    public void onTick(Player p, int ticks) {
        for (Buff buff : this.map.values()) {
            buff.ticks -= ticks;
        }
        this.map.entrySet().removeIf(x -> ((Buff)x.getValue()).ticks < 1);
    }

    public boolean tryAdd(Player p, StatBuff buff, int lvl, int perc, Type type, int ticks) {
        if (lvl > Load.Unit((Entity)p).getLevel()) {
            p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.EAT_FOOD_ERROR, Chats.TOO_LOW_LEVEL));
            return false;
        }
        List<ExactStatData> stats = buff.getStats(lvl, perc);
        Buff data = new Buff(buff.GUID(), stats, ticks);
        this.map.put(type, data);
        return true;
    }

    public static class Buff {
        public String id;
        public List<ExactStatData> stats;
        public int ticks = 0;

        public StatBuff getBuff() {
            return (StatBuff)ExileDB.StatBuffs().get(this.id);
        }

        public Buff(String id, List<ExactStatData> stats, int ticks) {
            this.id = id;
            this.stats = stats;
            this.ticks = ticks;
        }
    }

    public static enum Type implements IAutoLocName
    {
        POTION("buff_potion", "Elixir", 36000, () -> (MobEffect)SlashPotions.POTION.get(), Professions.ALCHEMY),
        MEAL("meal", "Meal", 72000, () -> (MobEffect)SlashPotions.MEAL.get(), Professions.COOKING),
        FISH("fish", "Seafood", 72000, () -> (MobEffect)SlashPotions.FISH.get(), Professions.COOKING);

        public String id;
        public String name;
        public int durationTicks;
        public Supplier<MobEffect> effect;
        public String profession;

        private Type(String id, String name, int durationTicks, Supplier<MobEffect> sup, String prof) {
            this.id = id;
            this.profession = prof;
            this.name = name;
            this.effect = sup;
            this.durationTicks = durationTicks;
        }

        public boolean isFood() {
            return this == MEAL || this == FISH;
        }

        @Override
        public IBaseAutoLoc.AutoLocGroup locNameGroup() {
            return IBaseAutoLoc.AutoLocGroup.Foods;
        }

        @Override
        public String locNameLangFileGUID() {
            return "mmorpg.buff_consumption." + this.GUID();
        }

        @Override
        public String locNameForLangFile() {
            return this.name;
        }

        public String GUID() {
            return this.name.toLowerCase(Locale.ROOT);
        }
    }
}

