/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.mine_and_slash.capability.player.helper.MyInventory;
import com.robertx22.mine_and_slash.database.data.stats.types.JewelSocketStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.jewel.JewelItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class JewelData
implements IStatCtx {
    public MyInventory jewelInventory;
    private transient Player player;
    private transient List<String> wearingUniqueJewel = new ArrayList<String>();

    public JewelData(Player player) {
        this((int)Load.Unit((Entity)player).getUnit().getCalculatedStat(JewelSocketStat.getInstance()).getValue(), player);
    }

    public JewelData(int size, Player player) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            if (player == null) {
                this.player = ClientOnly.getPlayer();
            }
        } else {
            this.player = player;
        }
        this.jewelInventory = new MyInventory(size);
        this.jewelInventory.m_19164_(container -> JewelData.updatePlayerData(player));
    }

    public static boolean updatePlayerData(Player player) {
        if (player instanceof ServerPlayer) {
            Load.player((Player)player).cachedStats.ALLOCATED.setDirty();
        }
        return false;
    }

    public void recalc(Player player) {
        this.wearingUniqueJewel.clear();
        for (int i = 0; i < this.jewelInventory.m_6643_(); ++i) {
            if (this.isWearableWithUniqueRegistry(this.jewelInventory.m_8020_(i), player)) continue;
            this.unequip(player, i);
        }
        int jewelSocketsMaxStat = JewelData.getJewelSocketsMaxStat(player);
        if (this.jewelInventory.m_6643_() != jewelSocketsMaxStat) {
            MyInventory newInventory = new MyInventory(jewelSocketsMaxStat);
            for (int i = 0; i < this.jewelInventory.m_6643_(); ++i) {
                ItemStack item = this.jewelInventory.m_8020_(i);
                if (i < newInventory.m_6643_()) {
                    newInventory.m_19173_(item);
                    continue;
                }
                PlayerUtils.forceUnequipItem(item.m_41777_(), player);
                item.m_41774_(100);
            }
            this.jewelInventory = newInventory;
        }
    }

    public boolean isWearable(ItemStack itemStack, Player player) {
        JewelItemData jewelItemData = (JewelItemData)StackSaving.JEWEL.loadFrom(itemStack);
        if (jewelItemData == null || player == null) {
            return false;
        }
        if (!jewelItemData.canWear(Load.Unit((Entity)player))) {
            return false;
        }
        if (!jewelItemData.isUnique()) {
            return true;
        }
        if (jewelItemData.uniq.id.isEmpty()) {
            return true;
        }
        return !this.wearingUniqueJewel.contains(jewelItemData.uniq.id);
    }

    public boolean isWearableWithUniqueRegistry(ItemStack itemStack, Player player) {
        boolean isWearable = this.isWearable(itemStack, player);
        if (!isWearable) {
            return false;
        }
        JewelItemData jewelItemData = (JewelItemData)StackSaving.JEWEL.loadFrom(itemStack);
        if (jewelItemData.uniq.id.isEmpty()) {
            return true;
        }
        this.wearingUniqueJewel.add(jewelItemData.uniq.id);
        return true;
    }

    public void unequip(Player p, int i) {
        ItemStack stack = this.jewelInventory.m_8020_(i);
        if (!stack.m_41619_()) {
            PlayerUtils.giveItem(stack.m_41777_(), p);
            stack.m_41774_(100);
        }
    }

    public void socket(ItemStack stack) {
        for (int i = 0; i < this.jewelInventory.getTotalSlots(); ++i) {
            if (!this.jewelInventory.m_8020_(i).m_41619_()) continue;
            this.jewelInventory.m_6836_(i, stack.m_41777_());
        }
    }

    public static int getJewelSocketsMaxStat(Player p) {
        int max = (int)Load.Unit((Entity)p).getUnit().getCalculatedStat(JewelSocketStat.getInstance()).getValue();
        return max;
    }

    public boolean hasFreeJewelSlots(Player p) {
        return this.jewelInventory.hasFreeSlots();
    }

    public List<JewelItemData> getAllJewels() {
        ArrayList<JewelItemData> list = new ArrayList<JewelItemData>();
        for (int i = 0; i < this.jewelInventory.getTotalSlots(); ++i) {
            ItemStack stack = this.jewelInventory.m_8020_(i);
            JewelItemData data = (JewelItemData)StackSaving.JEWEL.loadFrom(stack);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        for (JewelItemData jewel : this.getAllJewels()) {
            for (StatContext stac : jewel.getStatAndContext(en)) {
                list.add(stac);
            }
        }
        return list;
    }
}

