/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.addons.orbs_of_crafting.currency.IItemAsCurrency;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.a_libraries.curios.CuriosSlots;
import com.robertx22.mine_and_slash.a_libraries.curios.MyCuriosUtils;
import com.robertx22.mine_and_slash.capability.player.container.BackpackMenu;
import com.robertx22.mine_and_slash.capability.player.data.IGoesToBackpack;
import com.robertx22.mine_and_slash.capability.player.helper.BackpackInventory;
import com.robertx22.mine_and_slash.database.data.game_balance_config.BackpackTabConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DataSaverCheckUtil;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.RuneItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.RarityStoneItem;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Backpacks {
    Player player;
    private HashMap<BackpackType, BackpackInventory> map = new HashMap();

    public Backpacks(Player player) {
        this.player = player;
        for (BackpackType type : BackpackType.values()) {
            this.map.put(type, new BackpackInventory(player, type));
        }
    }

    public BackpackInventory getInv(BackpackType type) {
        return this.map.get((Object)type);
    }

    public boolean tryAutoPickup(Player p, ItemStack stack, boolean shouldPlaySound) {
        if (p.m_150109_().m_18947_((Item)SlashItems.MASTER_BAG.get()) < 1 && !this.hasCuriosBackpack(p)) {
            return false;
        }
        boolean result = false;
        for (BackpackType type : BackpackType.values()) {
            BackpackInventory bag;
            if (!type.isValid(stack) || !(bag = this.getInv(type)).m_19183_(stack)) continue;
            bag.m_19173_(stack.m_41777_());
            stack.m_41774_(stack.m_41613_() + 10);
            if (shouldPlaySound) {
                SoundUtils.playSound((Entity)this.player, (SoundEvent)SoundEvents.f_12019_);
            }
            result = true;
            break;
        }
        return result;
    }

    private boolean hasCuriosBackpack(Player p) {
        ItemStack backpackItem = MyCuriosUtils.get(CuriosSlots.MASTER_BAG.name, p, 0);
        return !backpackItem.m_41619_();
    }

    public boolean tryAutoPickup(Player p, ItemStack stack) {
        return this.tryAutoPickup(p, stack, true);
    }

    public void openBackpack(BackpackType type, Player p) {
        if (!p.m_9236_().f_46443_) {
            BackpackInventory inv = this.getInv(type);
            p.m_5893_((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> new BackpackMenu(type, i, playerEntity, (Container)playerInventory, (Container)inv), (Component)Component.m_237113_((String)"")));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BackpackType {
        GEARS("gear", Words.Gear){

            @Override
            public boolean isValid(ItemStack stack) {
                return StackSaving.GEARS.has(stack) || StackSaving.JEWEL.has(stack) || StackSaving.STAT_SOULS.has(stack);
            }
        }
        ,
        MAPS("map", Words.Maps){

            @Override
            public boolean isValid(ItemStack stack) {
                return StackSaving.MAP.has(stack) || DataSaverCheckUtil.checkForDataSaver("ancient_obelisks_obelisk", stack) || DataSaverCheckUtil.checkForDataSaver("the_harvest_map", stack);
            }
        }
        ,
        CURRENCY("currency", Words.Currency){

            @Override
            public boolean isValid(ItemStack stack) {
                Optional cur = ExileCurrency.get((ItemStack)stack);
                if (cur.isPresent()) {
                    return true;
                }
                return stack.m_41720_() instanceof IItemAsCurrency || stack.m_41720_() instanceof RuneItem || stack.m_41720_() instanceof RarityStoneItem;
            }
        }
        ,
        SKILL_GEMS("skill_gem", Words.SkillGem){

            @Override
            public boolean isValid(ItemStack stack) {
                return StackSaving.SKILL_GEM.has(stack);
            }
        }
        ,
        PROFESSION("profession", Words.PROFESSIONS){

            @Override
            public boolean isValid(ItemStack stack) {
                Item item = stack.m_41720_();
                return item instanceof IGoesToBackpack;
            }
        };

        public String id;
        public Words name;

        private BackpackType(String id, Words name) {
            this.id = id;
            this.name = name;
        }

        public int getRows() {
            return this.getConfig().rows;
        }

        public int getSize() {
            return this.getRows() * 9;
        }

        public int getStackMultiplier() {
            return this.getConfig().stack_multiplier;
        }

        public BackpackTabConfig getConfig() {
            return GameBalanceConfig.get().backpack_tabs.get((Object)this);
        }

        public ResourceLocation getIcon() {
            return SlashRef.guiId("backpack/" + this.id);
        }

        public abstract boolean isValid(ItemStack var1);
    }
}

