/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.entity;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SummonPetAction;
import com.robertx22.mine_and_slash.database.data.spells.summons.entity.SummonEntity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SummonedPetData {
    public String spell = "";
    public int ticks = 0;
    public int aggro_radius = 10;
    public boolean counts_towards_max_summons;
    public int ticks_left_to_check_owner = 0;

    public void setup(Spell spell, int ticks, int aggro_radius, boolean counts_towards_max_summons) {
        this.spell = spell.GUID();
        this.ticks = ticks;
        this.aggro_radius = aggro_radius;
        this.counts_towards_max_summons = counts_towards_max_summons;
    }

    public boolean isEmpty() {
        return this.spell.isEmpty();
    }

    public Spell getSourceSpell() {
        return (Spell)ExileDB.Spells().get(this.spell);
    }

    public void tick(LivingEntity en) {
        if (!en.m_9236_().f_46443_) {
            boolean registeredWithOwner = this.registeredWithOwner(en);
            if (this.ticks != SummonPetAction.INFINITE_DURATION && this.ticks-- < 1 || !registeredWithOwner) {
                SoundUtils.playSound((Entity)en, (SoundEvent)SoundEvents.f_11910_);
                this.discard(en);
            }
        }
    }

    private boolean registeredWithOwner(LivingEntity en) {
        LivingEntity livingEntity;
        SummonEntity summonEntity;
        if (this.ticks_left_to_check_owner-- > 0) {
            return true;
        }
        this.ticks_left_to_check_owner = 100;
        if (!(en instanceof SummonEntity) || (summonEntity = (SummonEntity)en).m_269323_() == null || !((livingEntity = summonEntity.m_269323_()) instanceof Player)) {
            return false;
        }
        Player player = (Player)livingEntity;
        return Load.player(player).getSummonedData().isOwnBySpell(this.spell, en.m_20148_());
    }

    public void discard(LivingEntity en) {
        en.m_146870_();
        if (!(en instanceof SummonEntity)) {
            return;
        }
        SummonEntity summonEntity = (SummonEntity)en;
        this.onDeath(summonEntity);
    }

    public void onDeath(SummonEntity summonEntity) {
        LivingEntity livingEntity;
        if (summonEntity.m_269323_() == null || !((livingEntity = summonEntity.m_269323_()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Load.player(player).removeSummon(this.spell, summonEntity.m_20148_());
    }
}

