/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.entity;

import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.library_of_exile.utils.LoadSave;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.capability.DirtySync;
import com.robertx22.mine_and_slash.capability.bases.EntityGears;
import com.robertx22.mine_and_slash.capability.bases.INeededForClient;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.capability.entity.EntityAilmentData;
import com.robertx22.mine_and_slash.capability.entity.EntityLeechData;
import com.robertx22.mine_and_slash.capability.entity.SummonedPetData;
import com.robertx22.mine_and_slash.capability.entity.UnsavedMaxEffectStacksData;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.capability.player.data.RestedExpData;
import com.robertx22.mine_and_slash.characters.PlayerStats;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.config.forge.compat.CompatConfig;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.mob_affixes.MobAffix;
import com.robertx22.mine_and_slash.database.data.profession.PlayerUTIL;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.AttackInformation;
import com.robertx22.mine_and_slash.event_hooks.my_events.CachedEntityStats;
import com.robertx22.mine_and_slash.event_hooks.ontick.UnequipGear;
import com.robertx22.mine_and_slash.event_hooks.player.OnLogin;
import com.robertx22.mine_and_slash.loot.LootModifiersList;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.CustomExactStatsData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.MobData;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_calc.StatCalculation;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.CustomExactStats;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.UnitNbt;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpendResourceEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.levels.LevelInfo;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.threat_aggro.ThreatData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.OnScreenMessageUtils;
import com.robertx22.mine_and_slash.vanilla_mc.packets.EntityUnitPacket;
import com.robertx22.mine_and_slash.vanilla_mc.potion_effects.EntityStatusEffectsData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityData
implements ICap,
INeededForClient {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "entity_data");
    public static Capability<EntityData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityData>(){});
    final transient LazyOptional<EntityData> supp = LazyOptional.of(() -> this);
    public CachedEntityStats equipmentCache;
    private static final String RARITY = "rarity";
    private static final String LEVEL = "level";
    private static final String EXP = "exp";
    private static final String EXP_DEBT = "ex_d";
    private static final String HP = "hp";
    private static final String UUID = "uuid";
    private static final String SET_MOB_STATS = "set_mob_stats";
    private static final String NEWBIE_STATUS = "is_a_newbie";
    private static final String AFFIXES = "affix";
    private static final String ENTITY_TYPE = "ENTITY_TYPE";
    private static final String RESOURCES_LOC = "res_loc";
    private static final String STATUSES = "statuses";
    private static final String AILMENTS = "ailments";
    private static final String COOLDOWNS = "cds";
    private static final String THREAT = "th";
    private static final String PET = "pet";
    private static final String BOSS = "boss";
    private static final String CUSTOM_STATS = "custom_stats";
    private static final String LEECH = "leech";
    private static final String MAP_ID = "mapid";
    private static final String MAP_MOB = "map_mob";
    private transient int dontSyncTicks = 0;
    public DirtySync sync = new DirtySync("endata sync", x -> this.syncData()){

        @Override
        public void onSynced(Entity p) {
            super.onSynced(p);
            if (!(EntityData.this.entity instanceof Player)) {
                EntityData.this.dontSyncTicks = 20;
            }
        }

        @Override
        public void onTickTrySync(Entity p) {
            if (EntityData.this.dontSyncTicks-- > 0) {
                return;
            }
            super.onTickTrySync(p);
        }
    };
    public int immuneTicks = 0;
    public UnsavedMaxEffectStacksData maxCharges = new UnsavedMaxEffectStacksData();
    public DamageEvent lastDamageTaken = null;
    transient LivingEntity entity;
    transient EntityGears gears = new EntityGears();
    public transient HashMap<UUID, List<UUID>> mobsHit = new HashMap();
    public SummonedPetData summonedPetData = new SummonedPetData();
    public String mapUUID = "";
    public int lastHealth = 0;
    public int heartsWithoutMnsHealth = 0;
    transient Unit unit = new Unit();
    String rarity = "common";
    int level = 1;
    int exp = 0;
    int expDebt = 0;
    int maxHealth = 0;
    MobData affixes = new MobData();
    public EntityStatusEffectsData statusEffects = new EntityStatusEffectsData();
    public EntityAilmentData ailments = new EntityAilmentData();
    CooldownsData cooldowns = new CooldownsData();
    ThreatData threat = new ThreatData();
    public EntityLeechData leech = new EntityLeechData();
    public boolean didStatCalcThisTickForPlayer = false;
    EntityTypeUtils.EntityClassification type = EntityTypeUtils.EntityClassification.PLAYER;
    boolean setMobStats = false;
    String uuid = "";
    boolean isNewbie = true;
    ResourcesData resources = new ResourcesData();
    CustomExactStatsData customExactStats = new CustomExactStatsData();
    public static final String ID = "entity_data";

    public static EntityData get(LivingEntity entity) {
        return (EntityData)entity.getCapability(INSTANCE).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public EntityData(LivingEntity entity) {
        this.entity = entity;
        this.equipmentCache = new CachedEntityStats(entity);
    }

    @Override
    public void addClientNBT(CompoundTag nbt) {
        try {
            nbt.m_128405_(LEVEL, this.level);
            nbt.m_128359_(RARITY, this.rarity);
            nbt.m_128405_(HP, this.maxHealth);
            nbt.m_128359_(ENTITY_TYPE, this.type.toString());
            if (this.affixes != null) {
                LoadSave.Save((Object)this.affixes, (CompoundTag)nbt, (String)AFFIXES);
            }
            LoadSave.Save((Object)this.statusEffects, (CompoundTag)nbt, (String)STATUSES);
            if (this.unit != null && this.entity instanceof Player) {
                UnitNbt.Save(nbt, this.unit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadFromClientNBT(CompoundTag nbt) {
        try {
            this.rarity = nbt.m_128461_(RARITY);
            this.level = nbt.m_128451_(LEVEL);
            if (this.level < 1) {
                this.level = 1;
            }
            this.maxHealth = nbt.m_128451_(HP);
            try {
                String typestring = nbt.m_128461_(ENTITY_TYPE);
                this.type = EntityTypeUtils.EntityClassification.valueOf(typestring);
            }
            catch (Exception e) {
                this.type = EntityTypeUtils.EntityClassification.OTHER;
            }
            this.affixes = (MobData)LoadSave.Load(MobData.class, (Object)new MobData(), (CompoundTag)nbt, (String)AFFIXES);
            if (this.affixes == null) {
                this.affixes = new MobData();
            }
            this.statusEffects = EntityData.loadOrBlank(EntityStatusEffectsData.class, new EntityStatusEffectsData(), nbt, STATUSES, new EntityStatusEffectsData());
            if (this.entity instanceof Player) {
                this.unit = UnitNbt.Load(nbt);
            }
            if (this.unit == null) {
                this.unit = new Unit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.addClientNBT(nbt);
        try {
            nbt.m_128405_(EXP, this.exp);
            nbt.m_128405_(EXP_DEBT, this.expDebt);
            nbt.m_128359_(UUID, this.uuid);
            nbt.m_128359_(MAP_ID, this.mapUUID);
            nbt.m_128379_(SET_MOB_STATS, this.setMobStats);
            nbt.m_128379_(NEWBIE_STATUS, this.isNewbie);
            LoadSave.Save((Object)this.cooldowns, (CompoundTag)nbt, (String)COOLDOWNS);
            LoadSave.Save((Object)this.summonedPetData, (CompoundTag)nbt, (String)PET);
            LoadSave.Save((Object)this.leech, (CompoundTag)nbt, (String)LEECH);
            LoadSave.Save((Object)this.customExactStats, (CompoundTag)nbt, (String)CUSTOM_STATS);
            if (this.customExactStats != null) {
                CustomExactStats.Save(nbt, this.customExactStats);
            }
            if (this.resources != null) {
                LoadSave.Save((Object)this.resources, (CompoundTag)nbt, (String)RESOURCES_LOC);
            }
            if (this.threat != null) {
                LoadSave.Save((Object)this.threat, (CompoundTag)nbt, (String)THREAT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public static <OBJ> OBJ loadOrBlank(Class theclass, OBJ newobj, CompoundTag nbt, String loc, OBJ blank) {
        try {
            Object data = LoadSave.Load((Class)theclass, newobj, (CompoundTag)nbt, (String)loc);
            if (data == null) {
                return blank;
            }
            return (OBJ)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return blank;
        }
    }

    public void deserializeNBT(CompoundTag nbt) {
        try {
            this.loadFromClientNBT(nbt);
            this.exp = nbt.m_128451_(EXP);
            this.expDebt = nbt.m_128451_(EXP_DEBT);
            this.uuid = nbt.m_128461_(UUID);
            this.mapUUID = nbt.m_128461_(MAP_ID);
            this.setMobStats = nbt.m_128471_(SET_MOB_STATS);
            if (nbt.m_128441_(NEWBIE_STATUS)) {
                this.isNewbie = nbt.m_128471_(NEWBIE_STATUS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.summonedPetData = EntityData.loadOrBlank(SummonedPetData.class, new SummonedPetData(), nbt, PET, new SummonedPetData());
            this.threat = EntityData.loadOrBlank(ThreatData.class, new ThreatData(), nbt, THREAT, new ThreatData());
            this.customExactStats = EntityData.loadOrBlank(CustomExactStatsData.class, new CustomExactStatsData(), nbt, CUSTOM_STATS, new CustomExactStatsData());
            this.resources = EntityData.loadOrBlank(ResourcesData.class, new ResourcesData(), nbt, RESOURCES_LOC, new ResourcesData());
            this.cooldowns = EntityData.loadOrBlank(CooldownsData.class, new CooldownsData(), nbt, COOLDOWNS, new CooldownsData());
            this.leech = EntityData.loadOrBlank(EntityLeechData.class, new EntityLeechData(), nbt, LEECH, new EntityLeechData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAllDirtyOnLoginEtc() {
        this.setEquipsChanged();
        this.sync.setDirty();
        this.didStatCalcThisTickForPlayer = true;
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            Load.player((Player)p).cachedStats.setAllDirty();
            Load.player((Player)p).playerDataSync.setDirty();
        }
    }

    public void setEquipsChanged() {
        this.equipmentCache.setAllDirty();
    }

    public CooldownsData getCooldowns() {
        return this.cooldowns;
    }

    public EntityStatusEffectsData getStatusEffectsData() {
        return this.statusEffects;
    }

    public float getMaximumResource(ResourceType type) {
        if (type == ResourceType.blood) {
            return this.getUnit().bloodData().getValue();
        }
        if (type == ResourceType.mana) {
            return this.getUnit().manaData().getValue();
        }
        if (type == ResourceType.health) {
            return this.getUnit().healthData().getValue();
        }
        if (type == ResourceType.energy) {
            return this.getUnit().energyData().getValue();
        }
        if (type == ResourceType.magic_shield) {
            return this.getUnit().magicShieldData().getValue();
        }
        return 0.0f;
    }

    public void onDeathDoPenalty() {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            int loss = (int)((double)this.getExpRequiredForLevelUp() * (Double)ServerContainer.get().EXP_LOSS_ON_DEATH.get());
            int debt = (int)((double)this.getExpRequiredForLevelUp() * (Double)ServerContainer.get().EXP_DEBT_ON_DEATH.get());
            int maxdebt = (int)((double)this.getExpRequiredForLevelUp() * (Double)ServerContainer.get().MAX_EXP_DEBT_MULTI.get());
            this.expDebt += debt;
            if (debt > maxdebt) {
                this.expDebt = maxdebt;
            }
            if ((loss = MathHelper.clamp(loss, 0, this.exp)) > 0) {
                this.exp = MathHelper.clamp(this.exp - loss, 0, Integer.MAX_VALUE);
            }
            p.m_213846_((Component)Chats.DEATH_EXP_LOSS_MSG.locName(loss, debt).m_130940_(ChatFormatting.RED));
        }
    }

    public void setType() {
        this.type = EntityTypeUtils.getType(this.entity);
    }

    public EntityTypeUtils.EntityClassification getType() {
        return this.type;
    }

    public ThreatData getThreat() {
        return this.threat;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void unarmedAttack(AttackInformation data) {
        Player p;
        float cost = ((Double)ServerContainer.get().UNARMED_ENERGY_COST.get()).floatValue();
        cost = Energy.getInstance().scale(ModType.FLAT, cost, this.getLevel());
        SpendResourceEvent event = new SpendResourceEvent(this.entity, null, ResourceType.energy, cost);
        event.calculateEffects();
        LivingEntity livingEntity = data.getAttackerEntity();
        if (livingEntity instanceof Player && PlayerUTIL.isFake(p = (Player)livingEntity)) {
            Load.Unit((Entity)p).equipmentCache.setAllDirty();
        } else if (event.data.getNumber() > this.resources.getEnergy()) {
            data.setCanceled(true);
            return;
        }
        event.Activate();
        WeaponTypes weptype = WeaponTypes.none;
        int num = (int)data.getAttackerEntityData().getUnit().getCalculatedStat(WeaponDamage.getInstance()).getValue();
        if (num > 0) {
            DamageEvent dmg = (DamageEvent)EventBuilder.ofDamage(data, data.getAttackerEntity(), data.getTargetEntity(), num).setupDamage(AttackType.hit, weptype, PlayStyle.STR).setIsBasicAttack().build();
            dmg.data.setBoolean(EventData.UNARMED_ATTACK, true);
            dmg.Activate();
        } else {
            data.setAmount(0.0f);
            data.setCanceled(true);
        }
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public void setRarity(String rarity) {
        this.rarity = rarity;
        this.sync.setDirty();
        this.equipmentCache.setAllDirty();
    }

    public void syncToClient(Player player) {
    }

    private void syncData() {
        if (this.entity.m_9236_().f_46443_) {
            return;
        }
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            Packets.sendToClient((Player)p, (MyPacket)new EntityUnitPacket((Entity)p));
        } else if (Unit.shouldSendUpdatePackets(this.entity)) {
            Packets.sendToTracking((MyPacket)Unit.getUpdatePacketFor(this.entity, this), (Entity)this.entity);
        }
    }

    public String getRarity() {
        return this.rarity;
    }

    public String getUUID() {
        return this.uuid;
    }

    public MobRarity getMobRarity() {
        if (ExileDB.MobRarities().isRegistered(this.rarity)) {
            return (MobRarity)ExileDB.MobRarities().get(this.rarity);
        }
        return (MobRarity)ExileDB.MobRarities().get("common");
    }

    public void setUUID(UUID id) {
        this.uuid = id.toString();
    }

    public MutableComponent getName() {
        MutableComponent part;
        if (this.entity instanceof Player) {
            return ExileText.emptyLine().get().m_7220_(this.entity.m_5446_());
        }
        MobRarity rarity = this.getMobRarity();
        ChatFormatting rarformat = rarity.textFormatting();
        MutableComponent name = ExileText.emptyLine().get().m_7220_(this.entity.m_5446_()).m_130940_(rarformat);
        Object icons = "";
        for (MobAffix x : this.getAffixData().getAffixes()) {
            icons = (String)icons + CLOC.translate((FormattedText)x.locName());
        }
        if (!((String)icons).isEmpty()) {
            icons = (String)icons + " ";
        }
        MutableComponent finalName = ExileText.ofText((String)icons).get().m_7220_((Component)name);
        MutableComponent tx = part = ExileText.emptyLine().get().m_7220_((Component)finalName).m_130940_(rarformat);
        return tx;
    }

    public void recalcStats_DONT_CALL() {
        LivingEntity livingEntity;
        if (this.entity.m_9236_().m_5776_()) {
            return;
        }
        if (this.unit == null) {
            this.unit = new Unit();
        }
        if ((livingEntity = this.entity) instanceof Player) {
            Player p = (Player)livingEntity;
            if (this.didStatCalcThisTickForPlayer) {
                if (MMORPG.RUN_DEV_TOOLS) {
                    // empty if block
                }
                return;
            }
        }
        int oldhp = this.maxHealth;
        this.unit = new Unit();
        List<StatContext> stats = StatCalculation.getStatsWithoutSuppGems(this.entity, this);
        StatCalculation.calc(this.unit, stats, this.entity, null, -1);
        LivingEntity livingEntity2 = this.entity;
        if (livingEntity2 instanceof Player) {
            Player p = (Player)livingEntity2;
            this.didStatCalcThisTickForPlayer = true;
            PlayerData data = Load.player(p);
            data.cachedStats.allStatsWithoutSuppGems = stats;
            data.setSpellUnitsDirty();
            Load.player((Player)p).spellCastingData.calcSpellLevels(this.unit);
            Load.player(p).getSkillGemInventory().removeAurasIfCantWear(p);
            UnequipGear.check(p);
            data.getSkillGemInventory().removeSupportGemsIfTooMany(p);
            data.jewelData.recalc(p);
            this.maxCharges.calc(this.unit.getStats());
            this.sync.setDirty();
        } else {
            this.sync.setDirty();
        }
        this.maxHealth = (int)this.getUnit().getCalculatedStat(Health.getInstance()).getValue();
        HealthUtils.addHearts(this.entity);
    }

    public boolean canUseWeapon(GearItemData weaponData) {
        return weaponData != null;
    }

    public void onLogin(Player player) {
        try {
            if (this.unit == null) {
                this.unit = new Unit();
            }
            if (this.isNewbie()) {
                this.setNewbieStatus(false);
                this.resources.restore(this.entity, ResourceType.energy, 100.0f);
                this.resources.restore(this.entity, ResourceType.mana, 100.0f);
                if (((Boolean)ServerContainer.get().GET_STARTER_ITEMS.get()).booleanValue()) {
                    OnLogin.GiveStarterItems(player);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSyncedMaxHealth() {
        return this.maxHealth;
    }

    public CustomExactStatsData getCustomExactStats() {
        return this.customExactStats;
    }

    public ResourcesData getResources() {
        return this.resources;
    }

    public float getCurrentMana() {
        return this.resources.getMana();
    }

    public void mobStatsAreSet() {
        this.setMobStats = true;
    }

    public void attackWithWeapon(AttackInformation data) {
        if (data.weaponData.GetBaseGearType().getWeaponMechanic() != null) {
            Player p;
            GearSlot slot = data.weaponData.GetBaseGearType().getGearSlot();
            float cost = Energy.getInstance().scale(ModType.FLAT, slot.weapon_data.energy_cost_per_mob_attacked, this.getLevel());
            if (!Load.Unit((Entity)this.entity).cooldowns.isOnCooldown("swing_cost")) {
                Load.Unit((Entity)this.entity).cooldowns.setOnCooldown("swing_cost", 3);
                cost += Energy.getInstance().scale(ModType.FLAT, slot.weapon_data.energy_cost_per_swing, this.getLevel());
            }
            SpendResourceEvent event = new SpendResourceEvent(this.entity, null, ResourceType.energy, cost);
            event.calculateEffects();
            LivingEntity livingEntity = data.getAttackerEntity();
            if (livingEntity instanceof Player && PlayerUTIL.isFake(p = (Player)livingEntity)) {
                Load.Unit((Entity)p).equipmentCache.setAllDirty();
                Load.Unit((Entity)p).recalcStats_DONT_CALL();
            } else if (event.data.getNumber() > this.resources.getEnergy()) {
                data.setCanceled(true);
                return;
            }
            event.Activate();
            data.weaponData.GetBaseGearType().getWeaponMechanic().attack(data);
        } else {
            data.setCanceled(true);
        }
    }

    public float getMobBaseDamage() {
        float multi = ((Double)ServerContainer.get().VANILLA_MOB_DMG_AS_EXILE_DMG.get()).floatValue();
        float num = 8.0f * multi;
        num = StatScaling.MOB_DAMAGE.scale(num, this.getLevel());
        return num;
    }

    public void mobBasicAttack(AttackInformation data) {
        if (this.cooldowns.isOnCooldown("basic_attack")) {
            data.setCanceled(true);
            return;
        }
        this.cooldowns.setOnCooldown("basic_attack", 5);
        float multi = ((Double)ServerContainer.get().VANILLA_MOB_DMG_AS_EXILE_DMG.get()).floatValue();
        float num = (float)((double)data.getAmount() * CompatConfig.get().mobPercentBonusDamage() / 100.0 + CompatConfig.get().mobFlatDmg());
        num *= multi;
        PlayStyle style = PlayStyle.STR;
        if (data.getSource() != null && data.getSource().m_269533_(DamageTypeTags.f_268524_)) {
            style = PlayStyle.DEX;
        }
        num = StatScaling.MOB_DAMAGE.scale(num, this.getLevel());
        DamageEvent dmg = (DamageEvent)EventBuilder.ofDamage(data, this.entity, data.getTargetEntity(), num).setupDamage(AttackType.hit, WeaponTypes.none, style).setIsBasicAttack().build();
        dmg.Activate();
    }

    public boolean isNewbie() {
        return this.isNewbie;
    }

    public void setNewbieStatus(boolean bool) {
        this.isNewbie = bool;
    }

    public boolean needsToBeGivenStats() {
        return !this.setMobStats;
    }

    public int getExpRequiredForLevelUp() {
        return LevelUtils.getExpRequiredForLevel(this.getLevel() + 1);
    }

    public EntityGears getCurrentGears() {
        return this.gears;
    }

    public MobData getAffixData() {
        return this.affixes;
    }

    public void SetMobLevelAtSpawn(Player nearestPlayer) {
        this.setMobStats = true;
        this.setMobLvlNormally(this.entity, nearestPlayer);
    }

    private void setMobLvlNormally(LivingEntity entity, Player nearestPlayer) {
        LevelInfo lvl = LevelUtils.determineLevel(entity, entity.m_9236_(), entity.m_20183_(), nearestPlayer, true);
        this.setLevel(lvl.getLevel());
    }

    public int GiveExp(Player player, int i, LootModifiersList mods) {
        if (player.m_21224_()) {
            return i;
        }
        if (this.expDebt > 0) {
            int reduced = MathHelper.clamp(i / 2, 0, this.expDebt);
            i -= reduced;
            this.expDebt -= reduced;
        }
        RestedExpData rested = Load.player((Player)player).rested_xp;
        rested.onGiveCombatExp(i);
        if (rested.bonusCombatExp > 0) {
            int added = MathHelper.clamp(rested.bonusCombatExp, 0, i);
            rested.bonusCombatExp -= added;
            i += added;
        }
        this.setExp(this.exp + i);
        float perc = MathHelper.clamp(1.0f * (float)this.exp / (float)this.getExpRequiredForLevelUp() * 100.0f, 0.0f, 100.0f);
        MutableComponent msg = Gui.EXP_GAIN_PERCENT.locName(i, "", NumberUtils.singleDigitFloat(perc)).m_130940_(ChatFormatting.GREEN);
        if (mods != null && Load.player((Player)player).config.isConfigEnabled(PlayerConfigData.Config.EXP_CHAT_MESSAGES)) {
            msg.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)mods.getHoverText())));
            player.m_213846_((Component)msg);
        }
        OnScreenMessageUtils.actionBar((ServerPlayer)player, msg);
        if (this.exp >= this.getExpRequiredForLevelUp()) {
            if (this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                this.LevelUp(player);
            }
            return i;
        }
        return i;
    }

    public boolean isSummon() {
        return this.entity instanceof TamableAnimal && !this.summonedPetData.isEmpty();
    }

    public TamableAnimal getSummonClass() {
        return (TamableAnimal)this.entity;
    }

    public boolean CheckIfCanLevelUp() {
        return this.getExp() >= this.getExpRequiredForLevelUp();
    }

    public int getRemainingExp() {
        int num = this.getExp() - this.getExpRequiredForLevelUp();
        if (num < 0) {
            num = 0;
        }
        return num;
    }

    public boolean CheckLevelCap() {
        return this.getLevel() + 1 <= GameBalanceConfig.get().MAX_LEVEL;
    }

    public boolean LevelUp(Player player) {
        if (!this.CheckIfCanLevelUp()) {
            player.m_5661_((Component)Chats.Not_enough_experience.locName(), false);
        } else if (!this.CheckLevelCap()) {
            player.m_5661_((Component)Chats.Can_not_go_over_maximum_level.locName(), false);
        }
        if (this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
            if (player instanceof ServerPlayer) {
                // empty if block
            }
            this.getResources().restore((LivingEntity)player, ResourceType.mana, 2.1474836E9f);
            this.getResources().restore((LivingEntity)player, ResourceType.health, 2.1474836E9f);
            this.getResources().restore((LivingEntity)player, ResourceType.blood, 2.1474836E9f);
            this.setExp(this.getRemainingExp());
            this.setLevel(this.level + 1);
            OnScreenMessageUtils.sendLevelUpMessage(player, Words.LEVEL_UP_TYPE_PLAYER.locName(), this.level - 1, this.level);
            return true;
        }
        return false;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int lvl) {
        this.level = Mth.m_14045_((int)lvl, (int)1, (int)GameBalanceConfig.get().MAX_LEVEL);
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player p = (Player)livingEntity;
            p.m_7166_(Stats.f_12988_.m_12902_((Object)PlayerStats.LEVELS_GAINED));
            p.m_6278_(Stats.f_12988_.m_12902_((Object)PlayerStats.LEVELS_GAINED), lvl);
        }
        this.equipmentCache.setAllDirty();
        this.sync.setDirty();
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public void onSpellHitTarget(Entity spellEntity, LivingEntity target) {
        UUID id = target.m_20148_();
        UUID key = spellEntity.m_20148_();
        if (!this.mobsHit.containsKey(key)) {
            this.mobsHit.put(key, new ArrayList());
        }
        this.mobsHit.get(key).add(id);
        if (this.mobsHit.size() > 1000) {
            this.mobsHit.clear();
        }
    }

    public boolean alreadyHit(Entity spellEntity, LivingEntity target) {
        UUID key = spellEntity.m_20148_();
        if (!this.mobsHit.containsKey(key)) {
            return false;
        }
        return this.mobsHit.get(key).contains(target.m_20148_());
    }

    public String getCapIdForSyncing() {
        return ID;
    }
}

