/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.chunk;

import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkCap
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "chunk");
    public static Capability<ChunkCap> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkCap>(){});
    final transient LazyOptional<ChunkCap> supp = LazyOptional.of(() -> this);
    transient LevelChunk chunk;
    public boolean generatedMobs = false;
    public boolean generatedTerrain = false;
    List<CompoundTag> savedMobs = new ArrayList<CompoundTag>();
    public List<UUID> mobIds = new ArrayList<UUID>();

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public ChunkCap(LevelChunk chunk) {
        this.chunk = chunk;
    }

    public void tryLoadMobs(Level world) {
        if (!this.savedMobs.isEmpty()) {
            try {
                List saved = this.savedMobs.stream().toList();
                this.savedMobs.clear();
                this.mobIds.clear();
                for (CompoundTag nbt : saved) {
                    Entity en = EntityType.m_20645_((CompoundTag)nbt, (Level)world, x -> x);
                    world.m_7967_(en);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void trySaveMob(LivingEntity en) {
        if (en instanceof Player) {
            return;
        }
        if (this.savedMobs.size() > 30) {
            if (MMORPG.RUN_DEV_TOOLS) {
                ExileLog.get().warn("Saved too many mobs in 1 chunk, stopping just in case", new Object[0]);
            }
            return;
        }
        if (this.mobIds.contains(en.m_20148_())) {
            return;
        }
        this.mobIds.add(en.m_20148_());
        CompoundTag nbt = en.serializeNBT();
        this.savedMobs.add(nbt);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        try {
            nbt.m_128379_("gen", this.generatedTerrain);
            nbt.m_128379_("genmobs", this.generatedMobs);
            nbt.m_128405_("mobs", this.savedMobs.size());
            for (int i = 0; i < this.savedMobs.size(); ++i) {
                nbt.m_128365_("" + i, (Tag)this.savedMobs.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ExileLog.get().warn("Mob Unloading/Loading Error", new Object[0]);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        try {
            this.generatedTerrain = nbt.m_128471_("gen");
            this.generatedMobs = nbt.m_128471_("genmobs");
            int mobs = nbt.m_128451_("mobs");
            this.savedMobs = new ArrayList<CompoundTag>();
            this.mobIds = new ArrayList<UUID>();
            for (int i = 0; i < mobs; ++i) {
                CompoundTag mobnbt = nbt.m_128469_("" + i);
                UUID id = mobnbt.m_128342_("UUID");
                if (id == null) continue;
                this.savedMobs.add(mobnbt);
                this.mobIds.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ExileLog.get().warn("Mob Unloading/Loading Error", new Object[0]);
        }
    }

    public String getCapIdForSyncing() {
        return "chunk_data";
    }
}

