/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.datapacks.generators;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.GemItems;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RuneItems;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.GemItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.RuneItem;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.fml.loading.FMLPaths;

public class LootTableGenerator {
    static Gson GSON = Deserializers.m_78800_().setPrettyPrinting().create();
    public static ResourceLocation RUNE_SALVAGE_RECIPE = SlashRef.id("runes_salvage_recipe");
    public static ResourceLocation GEM_SALVAGE_RECIPE = SlashRef.id("gems_salvage_recipe");
    public static ResourceLocation CURRENCIES_SALVAGE_RECIPE = SlashRef.id("currencies_salvage_recipe");

    protected Path getBasePath() {
        return FMLPaths.GAMEDIR.get();
    }

    protected Path movePath(Path target) {
        String movedpath = target.toString();
        movedpath = movedpath.replace("run/", "src/generated/resources/");
        movedpath = movedpath.replace("run\\", "src/generated/resources/");
        return Paths.get(movedpath, new String[0]);
    }

    private Path resolve(Path path, String id) {
        return path.resolve("data/mmorpg/loot_tables/" + id + ".json");
    }

    protected void generateAll(CachedOutput cache) {
        Path path = this.getBasePath();
        this.getLootTables().entrySet().forEach(x -> {
            Path target = this.movePath(this.resolve(path, ((ResourceLocation)x.getKey()).m_135815_()));
            DataProvider.m_253162_((CachedOutput)cache, (JsonElement)GSON.toJsonTree(x.getValue()), (Path)target);
        });
    }

    private HashMap<ResourceLocation, LootTable> getLootTables() {
        HashMap<ResourceLocation, LootTable> map = new HashMap<ResourceLocation, LootTable>();
        LootTable.Builder gems = LootTable.m_79147_();
        LootPool.Builder gemloot = LootPool.m_79043_();
        gemloot.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
        GemItems.ALL.forEach(x -> gemloot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)x.get())).m_79707_(((GemItem)x.get()).weight)));
        gems.m_79161_(gemloot);
        LootTable.Builder runes = LootTable.m_79147_();
        LootPool.Builder runeloot = LootPool.m_79043_();
        runeloot.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
        RuneItems.ALL.forEach(x -> runeloot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)x.get())).m_79707_(((RuneItem)x.get()).weight)));
        runes.m_79161_(runeloot);
        LootTable.Builder currencies = LootTable.m_79147_();
        LootPool.Builder curLoot = LootPool.m_79043_();
        curLoot.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
        for (ExileCurrency x2 : LibDatabase.Currency().getList()) {
            curLoot.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)x2.getItem()).m_79707_(x2.Weight()));
        }
        currencies.m_79161_(curLoot);
        map.put(RUNE_SALVAGE_RECIPE, runes.m_79167_());
        map.put(GEM_SALVAGE_RECIPE, gems.m_79167_());
        map.put(CURRENCIES_SALVAGE_RECIPE, currencies.m_79167_());
        return map;
    }
}

