/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.stats.base;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EmptyAccessor;
import com.robertx22.mine_and_slash.database.data.stats.StatGuiGroup;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DataPackStatAccessor;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DataPackStatEffect;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DatapackStat;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action.StatEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.condition.StatCondition;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ErrorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class DatapackStatBuilder<T extends IGUID> {
    private DataPackStatAccessor<T> accessor;
    private HashMap<T, DatapackStat> stats = new HashMap();
    private HashMap<T, Consumer<DatapackStat>> modify = new HashMap();
    private Function<T, String> idMaker;
    private Function<T, String> locNameMaker;
    private Function<T, String> locDescMaker;
    private Function<T, Elements> elementMaker;
    private StatGuiGroup group = StatGuiGroup.NONE;
    public HashMap<EffectPlace, EffectMaker<T>> EFFECTS = new HashMap();
    private Consumer<DatapackStat> modifyAfterDone;
    public boolean usesMoreMulti = false;
    private String priority = "";
    private EffectSides side = EffectSides.Source;
    private List<String> events = new ArrayList<String>();
    public static Set<DatapackStat> STATS_TO_ADD_TO_SERIALIZATION = new HashSet<DatapackStat>();

    public DatapackStatBuilder() {
        for (EffectPlace value : EffectPlace.values()) {
            this.EFFECTS.put(value, new EffectMaker());
        }
    }

    public static DatapackStatBuilder<EmptyAccessor> ofSingle(String id, Elements ele) {
        DatapackStatBuilder<EmptyAccessor> b = new DatapackStatBuilder<EmptyAccessor>();
        b.accessor = new DataPackStatAccessor();
        b.idMaker = x -> id;
        b.elementMaker = x -> ele;
        b.addSpecificType(EmptyAccessor.INSTANCE);
        return b;
    }

    public static <T extends IGUID> DatapackStatBuilder<T> of(Function<T, String> id, Function<T, Elements> ele) {
        DatapackStatBuilder<T> b = new DatapackStatBuilder<T>();
        b.accessor = new DataPackStatAccessor();
        b.idMaker = id;
        b.elementMaker = ele;
        return b;
    }

    public DatapackStatBuilder<T> addAllOfType(List<T> list) {
        list.forEach(x -> this.addSpecificType(x));
        return this;
    }

    public DatapackStatBuilder<T> addAllOfType(T[] list) {
        for (T t : list) {
            this.addSpecificType(t);
        }
        return this;
    }

    public DatapackStatBuilder<T> addSpecificType(T t) {
        this.add(t);
        return this;
    }

    public DatapackStatBuilder<T> modifyAfterDone(Consumer<DatapackStat> modifyAfterDone) {
        this.modifyAfterDone = modifyAfterDone;
        return this;
    }

    private void add(T t) {
        this.stats.put(t, new DatapackStat());
    }

    public DatapackStatBuilder<T> addCondition(StatCondition condition) {
        return this.addCondition(EffectPlace.FIRST, condition);
    }

    public DatapackStatBuilder<T> addCondition(EffectPlace place, StatCondition condition) {
        Objects.requireNonNull(condition);
        this.EFFECTS.get((Object)((Object)place)).conditions.add(condition);
        return this;
    }

    public DatapackStatBuilder<T> addCondition(Function<T, StatCondition> condition) {
        Objects.requireNonNull(condition);
        this.EFFECTS.get((Object)((Object)EffectPlace.FIRST)).conditionMaker.add(condition);
        return this;
    }

    public DatapackStatBuilder<T> addConditions(Function<T, List<StatCondition>> condition) {
        Objects.requireNonNull(condition);
        this.EFFECTS.get((Object)((Object)EffectPlace.FIRST)).conditionListMaker.add(condition);
        return this;
    }

    public DatapackStatBuilder<T> addEffect(StatEffect effect) {
        return this.addEffect(EffectPlace.FIRST, effect);
    }

    public DatapackStatBuilder<T> addEffect(EffectPlace place, StatEffect effect) {
        Objects.requireNonNull(effect);
        this.EFFECTS.get((Object)((Object)place)).effects.add(effect);
        return this;
    }

    public DatapackStatBuilder<T> addEffect(Function<T, StatEffect> effect) {
        Objects.requireNonNull(effect);
        this.EFFECTS.get((Object)((Object)EffectPlace.FIRST)).effectMaker.add(effect);
        return this;
    }

    public DatapackStatBuilder<T> worksWithEvent(String event) {
        this.events.add(event);
        return this;
    }

    public DatapackStatBuilder<T> setUsesMoreMultiplier() {
        this.usesMoreMulti = true;
        return this;
    }

    public DatapackStatBuilder<T> setPriority(StatPriority priority) {
        this.priority = priority.GUID();
        return this;
    }

    public DatapackStatBuilder<T> setSide(EffectSides side) {
        this.side = side;
        return this;
    }

    public DatapackStatBuilder<T> getGroup(StatGuiGroup group) {
        this.group = group;
        return this;
    }

    public DatapackStatBuilder<T> setLocName(Function<T, String> id) {
        this.locNameMaker = id;
        return this;
    }

    public DatapackStatBuilder<T> setLocDesc(Function<T, String> id) {
        this.locDescMaker = id;
        return this;
    }

    public DataPackStatAccessor<T> build() {
        Objects.requireNonNull(this.idMaker);
        Objects.requireNonNull(this.elementMaker);
        Objects.requireNonNull(this.locNameMaker);
        Objects.requireNonNull(this.locDescMaker);
        ErrorUtils.ifFalse(!this.stats.isEmpty());
        this.stats.entrySet().forEach(x -> {
            DatapackStat stat = (DatapackStat)x.getValue();
            stat.id = this.idMaker.apply((IGUID)x.getKey());
            stat.ele = this.elementMaker.apply((IGUID)x.getKey());
            stat.locdesc = this.locDescMaker.apply((IGUID)x.getKey());
            stat.locname = this.locNameMaker.apply((IGUID)x.getKey());
            stat.gui_group = this.group;
            if (this.usesMoreMulti) {
                stat.setUsesMoreMultiplier();
            }
            if (this.modify.containsKey(x.getKey())) {
                this.modify.get(x.getKey()).accept(stat);
            }
            if (this.modifyAfterDone != null) {
                this.modifyAfterDone.accept(stat);
            }
            for (Map.Entry<EffectPlace, EffectMaker<T>> en : this.EFFECTS.entrySet()) {
                EffectMaker<T> effectMaker = en.getValue();
                if (effectMaker.isEmpty()) continue;
                DataPackStatEffect dataEffect = new DataPackStatEffect();
                dataEffect.order = this.priority;
                dataEffect.events = this.events;
                dataEffect.side = this.side;
                effectMaker.conditions.forEach(c -> dataEffect.ifs.add(c.GUID()));
                effectMaker.effects.forEach(c -> dataEffect.effects.add(c.GUID()));
                if (effectMaker.effectMaker != null) {
                    IGUID key = (IGUID)x.getKey();
                    for (Function<IGUID, StatEffect> function : effectMaker.effectMaker) {
                        StatEffect effect = function.apply(key);
                        if (effect == null) {
                            System.out.print("Can't make effect for key: " + key.toString());
                        }
                        dataEffect.effects.add(effect.GUID());
                    }
                }
                if (effectMaker.conditionMaker != null) {
                    for (Function<IGUID, Object> function : effectMaker.conditionMaker) {
                        dataEffect.ifs.add(((StatCondition)function.apply((IGUID)x.getKey())).GUID());
                    }
                }
                if (effectMaker.conditionListMaker != null) {
                    for (Function<IGUID, Object> function : effectMaker.conditionListMaker) {
                        for (StatCondition c2 : (List)function.apply((IGUID)x.getKey())) {
                            dataEffect.ifs.add(c2.GUID());
                        }
                    }
                }
                stat.effect.add(dataEffect);
            }
            this.accessor.add((IGUID)x.getKey(), stat);
            STATS_TO_ADD_TO_SERIALIZATION.add(stat);
        });
        return this.accessor;
    }

    public static enum EffectPlace {
        FIRST,
        SECOND;

    }

    public static class EffectMaker<T> {
        private List<Function<T, StatEffect>> effectMaker = new ArrayList<Function<T, StatEffect>>();
        private List<Function<T, StatCondition>> conditionMaker = new ArrayList<Function<T, StatCondition>>();
        private List<Function<T, List<StatCondition>>> conditionListMaker = new ArrayList<Function<T, List<StatCondition>>>();
        private List<StatCondition> conditions = new ArrayList<StatCondition>();
        private List<StatEffect> effects = new ArrayList<StatEffect>();

        public boolean isEmpty() {
            return this.effectMaker.isEmpty() && this.effects.isEmpty();
        }
    }
}

