/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.spells.impl;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.a_libraries.player_animations.SpellAnimations;
import com.robertx22.mine_and_slash.aoe_data.database.spells.PartBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellCalcs;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellConfiguration;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.conditions.EffectCondition;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlocks;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.tags.imp.SpellTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;

public class TotemSpells
implements ExileRegistryInit {
    static Double RADIUS = 3.0;
    public static String MANA_TOTEM_ID = "astral_totem";
    public static String HEAL_TOTEM_ID = "rejuv_totem";
    public static String GUARD_TOTEM_ID = "guard_totem";

    SpellBuilder of(Block block, String id, SpellConfiguration config, String name, List<SpellTag> tags, SimpleParticleType particle) {
        return SpellBuilder.of(id, PlayStyle.INT, config, name, tags).animations(SpellAnimations.STAFF_CAST_WAVE_LOOP, SpellAnimations.STAFF_CAST_FINISH).onCast(PartBuilder.playSound(SoundEvents.f_12049_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create((EntityType)SlashEntities.SIMPLE_PROJECTILE.get(), 1.0, 0.0))).onExpire(PartBuilder.justAction(SpellAction.SUMMON_BLOCK.create(block, 150.0).put(MapField.ENTITY_NAME, "block").put(MapField.BLOCK_FALL_SPEED, 0.0).put(MapField.FIND_NEAREST_SURFACE, true).put(MapField.IS_BLOCK_FALLING, false))).onTick("block", PartBuilder.playSound(SoundEvents.f_144243_, 0.5, 1.0).addCondition(EffectCondition.EVERY_X_TICKS.create(20.0))).onTick("block", PartBuilder.particleOnTick(2.0, particle, 2.0, 0.5)).onTick("block", PartBuilder.groundEdgeParticles(particle, 50.0, RADIUS, 0.5).addCondition(EffectCondition.EVERY_X_TICKS.create(20.0)));
    }

    public void registerAll() {
        this.of((Block)SlashBlocks.BLUE_TOTEM.get(), MANA_TOTEM_ID, SpellConfiguration.Builder.nonInstant(18, 600, 20), "Astral Totem", Arrays.asList(SpellTags.totem, SpellTags.area), ParticleTypes.f_123771_).manualDesc("Summon a totem which restores " + SpellCalcs.TOTEM_MANA.getLocDmgTooltip() + " mana to allies around it.").onTick("block", PartBuilder.restoreManaInRadius(SpellCalcs.TOTEM_MANA, RADIUS).tick(20.0)).build();
        this.of((Block)SlashBlocks.GREEN_TOTEM.get(), HEAL_TOTEM_ID, SpellConfiguration.Builder.nonInstant(18, 600, 20), "Rejuvenating Totem", Arrays.asList(SpellTags.totem, SpellTags.area), ParticleTypes.f_123748_).manualDesc("Summon a totem which restores " + SpellCalcs.TOTEM_HEAL.getLocDmgTooltip() + " health to allies around it.").onTick("block", PartBuilder.healInAoe(SpellCalcs.TOTEM_HEAL, RADIUS).tick(20.0)).build();
    }
}

