/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.spells.impl;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.aoe_data.database.spells.PartBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellCalcs;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EffectCtx;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellConfiguration;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import java.util.Arrays;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;

public class CurseSpells
implements ExileRegistryInit {
    public static String CURSE_OF_AGONY = "curse_of_agony";
    public static String CURSE_OF_WEAK = "curse_of_weak";
    public static String CURSE_OF_DESPAIR = "curse_of_despair";

    static void curse(String id, String name, EffectCtx effect) {
        SpellBuilder.of(id, PlayStyle.INT, SpellConfiguration.Builder.instant(10, 600).setSwingArm(), name, Arrays.asList(SpellTags.area, SpellTags.curse, SpellTags.CHAOS)).manualDesc("Curse enemies with " + effect.locname + " and deal " + SpellCalcs.CURSE.getLocDmgTooltip() + " " + Elements.Shadow.getIconNameDmg()).onCast(PartBuilder.justAction(SpellAction.SUMMON_AT_SIGHT.create((EntityType)SlashEntities.SIMPLE_PROJECTILE.get(), 1.0, 0.0))).onExpire(PartBuilder.playSound(SoundEvents.f_12561_, 1.0, 1.0)).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123762_, 200.0, 3.0)).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123765_, 200.0, 3.0)).onExpire(PartBuilder.damageInAoe(SpellCalcs.CURSE, Elements.Shadow, 3.0)).onExpire(PartBuilder.addExileEffectToEnemiesInAoe(effect.resourcePath, 3.0, 300.0)).build();
    }

    public void registerAll() {
        CurseSpells.curse(CURSE_OF_AGONY, "Curse of Agony", ModEffects.CURSE_AGONY);
        CurseSpells.curse(CURSE_OF_WEAK, "Curse of Weakness", ModEffects.CURSE_WEAKNESS);
        CurseSpells.curse(CURSE_OF_DESPAIR, "Curse of Despair", ModEffects.DESPAIR);
    }
}

