/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailments;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.ExileEffectBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.PartBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellCalcs;
import com.robertx22.mine_and_slash.aoe_data.database.stats.DefenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.OffenseStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.ProcStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.ResourceStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.SpellChangeStats;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EffectCtx;
import com.robertx22.mine_and_slash.aoe_data.database.stats.old.DatapackStats;
import com.robertx22.mine_and_slash.database.data.exile_effects.EffectType;
import com.robertx22.mine_and_slash.database.data.exile_effects.VanillaStatData;
import com.robertx22.mine_and_slash.database.data.spells.SetAdd;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.AggroAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleMotion;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.TargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentResistance;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DodgeRating;
import com.robertx22.mine_and_slash.database.data.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.SkillDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.HealthRegen;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.ManaRegen;
import com.robertx22.mine_and_slash.tags.all.EffectTags;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ModEffects
implements ExileRegistryInit {
    public static List<EffectCtx> ALL = new ArrayList<EffectCtx>();
    public static EffectCtx ICE_GOLEM_BUFF = new EffectCtx("ice_golem_buff", "Ice Golem Buff", Elements.Cold, EffectType.beneficial);
    public static EffectCtx LIGHTNING_GOLEM_BUFF = new EffectCtx("lightning_golem_buff", "Lightning Golem Buff", Elements.Nature, EffectType.beneficial);
    public static EffectCtx FIRE_GOLEM_BUFF = new EffectCtx("fire_golem_buff", "Fire Golem Buff", Elements.Fire, EffectType.beneficial);
    public static EffectCtx POWER_CHARGE = new EffectCtx("power_charge", "Power Charge", Elements.Physical, EffectType.beneficial);
    public static EffectCtx FRENZY_CHARGE = new EffectCtx("frenzy_charge", "Frenzy Charge", Elements.Physical, EffectType.beneficial);
    public static EffectCtx ENDURANCE_CHARGE = new EffectCtx("endurance_charge", "Endurance Charge", Elements.Physical, EffectType.beneficial);
    public static EffectCtx VAMPIRIC_BLOOD = new EffectCtx("vamp_blood", "Vamp Blood", Elements.Fire, EffectType.beneficial);
    public static EffectCtx DRACONIC_BLOOD = new EffectCtx("draconic_blood", "Dragon Blood", Elements.Fire, EffectType.beneficial);
    public static EffectCtx REJUVENATE = new EffectCtx("rejuvenation", "Rejuvenation", Elements.Physical, EffectType.beneficial);
    public static EffectCtx VALOR = new EffectCtx("valor", "Valor", Elements.Physical, EffectType.beneficial);
    public static EffectCtx PERSEVERANCE = new EffectCtx("perseverance", "Perseverance", Elements.Physical, EffectType.beneficial);
    public static EffectCtx VIGOR = new EffectCtx("vigor", "Vigor", Elements.Physical, EffectType.beneficial);
    public static EffectCtx TAUNT_STANCE = new EffectCtx("taunt_stance", "Taunt Stance", Elements.Physical, EffectType.beneficial);
    public static EffectCtx UNDYING_WILL = new EffectCtx("undying_will", "Undying Will", Elements.Physical, EffectType.beneficial);
    public static EffectCtx MAGE_CIRCLE = new EffectCtx("mage_circle", "Mage Circle", Elements.Elemental, EffectType.beneficial);
    public static EffectCtx PETRIFY = new EffectCtx("petrify", "Petrify", Elements.Shadow, EffectType.negative);
    public static EffectCtx BLIND = new EffectCtx("blind", "Blind", Elements.Shadow, EffectType.negative);
    public static EffectCtx STUN = new EffectCtx("stun", "Stun", Elements.Physical, EffectType.negative);
    public static EffectCtx GALE_FORCE = new EffectCtx("gale_force", "Gale Force", Elements.Physical, EffectType.beneficial);
    public static EffectCtx SLOW = new EffectCtx("slow", "Lethargy", Elements.Physical, EffectType.negative);
    public static EffectCtx WOUNDS = new EffectCtx("wounds", "Wounds", Elements.Physical, EffectType.negative);
    public static EffectCtx CURSE_AGONY = new EffectCtx("agony", "Physical Agony", Elements.Elemental, EffectType.negative);
    public static EffectCtx CURSE_WEAKNESS = new EffectCtx("weak", "Elemental Weakness", Elements.Elemental, EffectType.negative);
    public static EffectCtx DESPAIR = new EffectCtx("despair", "Despair of Chaos", Elements.Elemental, EffectType.negative);
    public static EffectCtx CHARM = new EffectCtx("charm", "Charm", Elements.Elemental, EffectType.negative);
    public static EffectCtx GROUNDING = new EffectCtx("ground", "Grounding", Elements.Physical, EffectType.negative);
    public static EffectCtx SHRED = new EffectCtx("shred", "Shred", Elements.Physical, EffectType.negative);
    public static EffectCtx THORN = new EffectCtx("thorn", "Thorn", Elements.Physical, EffectType.negative);
    public static EffectCtx INNER_CALM = new EffectCtx("inner_calm", "Inner Calm", Elements.Physical, EffectType.beneficial);
    public static EffectCtx BONE_CHILL = new EffectCtx("bone_chill", "Bone Chill", Elements.Cold, EffectType.negative);
    public static EffectCtx FROST_LICH = new EffectCtx("frost_lich", "Frost Lich", Elements.Cold, EffectType.beneficial);
    public static EffectCtx ESSENCE_OF_FROST = new EffectCtx("essence_of_frost", "Essence of Frost", Elements.Cold, EffectType.beneficial);
    public static EffectCtx BLIZZARD_REDUCE_HEAL_STRENGTH = new EffectCtx("blizzard_reduce_heal_strength", "Blizzard Debuff", Elements.Cold, EffectType.negative);
    public static int ESSENCE_OF_FROST_MAX_STACKS = 5;

    public static List<EffectCtx> getCurses() {
        return Arrays.asList(CURSE_AGONY, DESPAIR, CURSE_WEAKNESS, SLOW, WOUNDS);
    }

    public static void init() {
    }

    public void registerAll() {
        ExileEffectBuilder.of(GALE_FORCE).vanillaStat(VanillaStatData.create(Attributes.f_22279_, 0.01f, ModType.MORE, UUID.fromString("3fb10485-f309-465f-afc6-a23b0d6cf4c1"))).stat(2.0f, 2.0f, DodgeRating.getInstance(), ModType.PERCENT).addTags(EffectTags.positive).maxStacks(20).build();
        ExileEffectBuilder.of(ENDURANCE_CHARGE).stat(5.0f, 5.0f, new ElementalResist(Elements.Physical), ModType.FLAT).stat(5.0f, 5.0f, new ElementalResist(Elements.Fire), ModType.FLAT).stat(5.0f, 5.0f, new ElementalResist(Elements.Cold), ModType.FLAT).stat(5.0f, 5.0f, new ElementalResist(Elements.Nature), ModType.FLAT).maxStacks(3).addTags(EffectTags.offensive, EffectTags.charge).build();
        ExileEffectBuilder.of(FRENZY_CHARGE).stat(3.0f, 3.0f, OffenseStats.TOTAL_DAMAGE.get(), ModType.MORE).stat(5.0f, 5.0f, SpellChangeStats.CAST_SPEED.get(), ModType.FLAT).maxStacks(3).addTags(EffectTags.offensive, EffectTags.charge).build();
        ExileEffectBuilder.of(POWER_CHARGE).stat(25.0f, 25.0f, OffenseStats.CRIT_CHANCE.get(), ModType.PERCENT).maxStacks(3).addTags(EffectTags.offensive, EffectTags.charge).build();
        ExileEffectBuilder.of(ICE_GOLEM_BUFF).stat(2.0f, 5.0f, OffenseStats.CRIT_CHANCE.get(), ModType.FLAT).stat(5.0f, 10.0f, OffenseStats.ACCURACY.get(), ModType.FLAT).maxStacks(1).addTags(EffectTags.offensive, EffectTags.golem).build();
        ExileEffectBuilder.of(FIRE_GOLEM_BUFF).stat(10.0f, 20.0f, OffenseStats.TOTAL_DAMAGE.get(), ModType.FLAT).maxStacks(1).addTags(EffectTags.offensive, EffectTags.golem).build();
        ExileEffectBuilder.of(LIGHTNING_GOLEM_BUFF).stat(3.0f, 6.0f, SpellChangeStats.CAST_SPEED.get(), ModType.FLAT).maxStacks(1).addTags(EffectTags.offensive, EffectTags.golem).build();
        ExileEffectBuilder.of(ESSENCE_OF_FROST).maxStacks(ESSENCE_OF_FROST_MAX_STACKS).stat(OffenseStats.CRIT_DAMAGE.get().mod(1.0f, 5.0f)).stat(OffenseStats.ELEMENTAL_DAMAGE.get(Elements.Cold).mod(1.0f, 5.0f)).stat(new AilmentDamage(Ailments.FREEZE).mod(2.0f, 5.0f)).build();
        ExileEffectBuilder.of(FROST_LICH).maxStacks(1).stat(DatapackStats.ARMOR_PER_MANA.mod(1.0f, 5.0f)).stat(ProcStats.PROC_SHATTER.get().mod(25.0f, 100.0f)).build();
        ExileEffectBuilder.of(BONE_CHILL).maxStacks(5).stat(-5.0f, -10.0f, new AilmentResistance(Ailments.FREEZE), ModType.FLAT).stat(-2.0f, -5.0f, new ElementalResist(Elements.Cold), ModType.FLAT).build();
        ExileEffectBuilder.of(THORN).maxStacks(5).desc("Attacking an enemy with Thorns consumes the thorns to deal " + SpellCalcs.THORN_BUSH.getLocDmgTooltip() + " " + Elements.Physical.getIconNameDmg()).spell(SpellBuilder.forEffect().addSpecificAction(SpellCtx.ON_ENTITY_ATTACKED, PartBuilder.damage(SpellCalcs.THORN_CONSUME, Elements.Physical)).addSpecificAction(SpellCtx.ON_ENTITY_ATTACKED, PartBuilder.removeExileEffectStacksToTarget(ModEffects.THORN.resourcePath)).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123797_, 2.0, 0.5).tick(2.0)).buildForEffect()).build();
        ExileEffectBuilder.of(SHRED).maxStacks(3).stat(-10.0f, -25.0f, Armor.getInstance(), ModType.FLAT).stat(-1.0f, -3.0f, new ElementalResist(Elements.Elemental), ModType.FLAT).stat(-2.0f, -5.0f, Armor.getInstance(), ModType.PERCENT).build();
        ExileEffectBuilder.of(GROUNDING).maxStacks(1).spell(SpellBuilder.forEffect().onTick(PartBuilder.justAction(SpellAction.SET_ADD_MOTION.create(SetAdd.ADD, 1.0, ParticleMotion.Downwards)).addTarget(TargetSelector.CASTER.create())).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123765_, 2.0, 0.5).tick(20.0)).buildForEffect()).build();
        ExileEffectBuilder.of(CHARM).maxStacks(5).stat(-1.0f, -3.0f, Armor.getInstance(), ModType.PERCENT).stat(-1.0f, -3.0f, DodgeRating.getInstance(), ModType.PERCENT).stat(-1.0f, -3.0f, new ElementalResist(Elements.Elemental), ModType.FLAT).build();
        ExileEffectBuilder.of(CURSE_AGONY).maxStacks(1).stat(-10.0f, -20.0f, Armor.getInstance(), ModType.MORE).stat(5.0f, 10.0f, DatapackStats.MOVE_SPEED).spell(SpellBuilder.forEffect().onTick(PartBuilder.aoeParticles(ParticleTypes.f_123797_, 2.0, 0.5).tick(20.0)).buildForEffect()).addTags(EffectTags.curse, EffectTags.negative).build();
        ExileEffectBuilder.of(CURSE_WEAKNESS).maxStacks(1).stat(-10.0f, -20.0f, new ElementalResist(Elements.Elemental)).spell(SpellBuilder.forEffect().onTick(PartBuilder.aoeParticles(ParticleTypes.f_123771_, 2.0, 0.5).tick(20.0)).buildForEffect()).addTags(EffectTags.curse, EffectTags.negative).build();
        ExileEffectBuilder.of(DESPAIR).maxStacks(1).stat(-15.0f, -25.0f, new ElementalResist(Elements.Shadow)).spell(SpellBuilder.forEffect().onTick(PartBuilder.aoeParticles(ParticleTypes.f_123753_, 2.0, 0.5).tick(20.0)).buildForEffect()).addTags(EffectTags.curse, EffectTags.negative).build();
        ExileEffectBuilder.of(SLOW).vanillaStat(VanillaStatData.create(Attributes.f_22279_, -0.25f, ModType.MORE, UUID.fromString("3fb10485-f309-468f-afc6-a23b0d6cf4c1"))).vanillaStat(VanillaStatData.create(Attributes.f_22283_, -0.1f, ModType.MORE, UUID.fromString("00fb60a7-904b-462f-a7cb-a557f02e362e"))).addTags(EffectTags.negative).build();
        ExileEffectBuilder.of(STUN).addTags(EffectTags.immobilizing, EffectTags.negative).vanillaStat(VanillaStatData.create(Attributes.f_22279_, -10.0f, ModType.MORE, UUID.fromString("3fb10485-f309-468f-afc6-a23b0d6cf4c1"))).vanillaStat(VanillaStatData.create(Attributes.f_22283_, -10.0f, ModType.MORE, UUID.fromString("00fb60a7-904b-462f-a7cb-a557f02e362e"))).vanillaStat(VanillaStatData.create(Attributes.f_22281_, -10.0f, ModType.MORE, UUID.fromString("10fb60a7-904b-462f-a7cb-a557f02e362e"))).build();
        ExileEffectBuilder.of(BLIND).vanillaStat(VanillaStatData.create(Attributes.f_22281_, -10.0f, ModType.MORE, UUID.fromString("5eccf34c-29f7-4eea-bbad-82a905594064"))).vanillaStat(VanillaStatData.create(Attributes.f_22283_, -10.0f, ModType.MORE, UUID.fromString("57eb6210-2a42-4ad3-a604-6f679d440a9b"))).spell(SpellBuilder.forEffect().onTick(PartBuilder.aoeParticles(ParticleTypes.f_123765_, 3.0, 1.0).tick(20.0)).buildForEffect()).addTags(EffectTags.immobilizing).build();
        ExileEffectBuilder.of(WOUNDS).stat(-25.0f, -25.0f, ResourceStats.HEAL_STRENGTH.get(), ModType.FLAT).build();
        ExileEffectBuilder.of(PETRIFY).addTags(EffectTags.immobilizing).vanillaStat(VanillaStatData.create(Attributes.f_22279_, -10.0f, ModType.MORE, UUID.fromString("bd9d32fa-c8c2-455c-92aa-4a94c2a70cd5"))).spell(SpellBuilder.forEffect().onTick(PartBuilder.aoeParticles(ParticleTypes.f_123753_, 10.0, 1.0).tick(20.0)).onExpire(PartBuilder.justAction(SpellAction.DEAL_DAMAGE.create(SpellCalcs.PETRIFY, Elements.Shadow)).setTarget(TargetSelector.TARGET.create())).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123796_, 15.0, 1.0)).onExpire(PartBuilder.justAction(SpellAction.PLAY_SOUND.create(SoundEvents.f_12344_, 1.0, 1.0))).buildForEffect()).build();
        ExileEffectBuilder.of(DRACONIC_BLOOD).stat(2.0f, 4.0f, ResourceStats.SPELL_LIFESTEAL.get(), ModType.FLAT).maxStacks(1).addTags(EffectTags.positive).build();
        ExileEffectBuilder.of(VAMPIRIC_BLOOD).stat(2.0f, 5.0f, ResourceStats.LIFESTEAL.get(), ModType.FLAT).maxStacks(1).addTags(EffectTags.positive).build();
        ExileEffectBuilder.of(MAGE_CIRCLE).stat(10.0f, 25.0f, OffenseStats.CRIT_DAMAGE.get(), ModType.FLAT).stat(5.0f, 20.0f, SkillDamage.getInstance(), ModType.FLAT).maxStacks(1).addTags(EffectTags.offensive).build();
        ExileEffectBuilder.of(TAUNT_STANCE).stat(10.0f, 25.0f, SpellChangeStats.THREAT_GENERATED.get()).stat(25.0f, 50.0f, SpellChangeStats.MORE_THREAT_WHEN_TAKING_DAMAGE.get()).spell(SpellBuilder.forEffect().onTick(PartBuilder.justAction(SpellAction.AGGRO.create(SpellCalcs.TAUNT, AggroAction.Type.AGGRO)).setTarget(TargetSelector.AOE.create(10.0, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.enemies)).tick(60.0)).buildForEffect()).maxStacks(1).build();
        ExileEffectBuilder.of(UNDYING_WILL).stat(-25.0f, -75.0f, DefenseStats.DAMAGE_RECEIVED.get()).stat(1.0f, 2.0f, HealthRegen.getInstance()).maxStacks(1).build();
        ExileEffectBuilder.of(VIGOR).stat(0.25f, 0.5f, HealthRegen.getInstance()).stat(0.25f, 0.5f, ManaRegen.getInstance()).stat(10.0f, 10.0f, OffenseStats.DAMAGE_PER_SPELL_TAG.get(SpellTags.song), ModType.MORE).maxStacks(3).addTags(EffectTags.song).build();
        ExileEffectBuilder.of(PERSEVERANCE).stat(5.0f, 10.0f, new ElementalResist(Elements.Physical)).stat(5.0f, 10.0f, new ElementalResist(Elements.Shadow)).stat(5.0f, 10.0f, new ElementalResist(Elements.Fire)).stat(5.0f, 10.0f, new ElementalResist(Elements.Cold)).stat(5.0f, 10.0f, new ElementalResist(Elements.Nature)).stat(10.0f, 10.0f, OffenseStats.DAMAGE_PER_SPELL_TAG.get(SpellTags.song), ModType.MORE).maxStacks(3).addTags(EffectTags.song, EffectTags.defensive).build();
        ExileEffectBuilder.of(VALOR).stat(5.0f, 10.0f, OffenseStats.TOTAL_DAMAGE.get(), ModType.FLAT).stat(2.0f, 5.0f, OffenseStats.CRIT_CHANCE.get(), ModType.FLAT).stat(10.0f, 10.0f, OffenseStats.DAMAGE_PER_SPELL_TAG.get(SpellTags.song), ModType.MORE).maxStacks(3).addTags(EffectTags.song, EffectTags.offensive).build();
        ExileEffectBuilder.of(REJUVENATE).maxStacks(5).addTags(EffectTags.heal_over_time).stat(ResourceStats.REJUV_HEAL_SELF.get().mod(25.0f, 50.0f)).stat(OffenseStats.DAMAGE_PER_SPELL_TAG.get(SpellTags.thorns).mod(2.0f, 10.0f).more()).spell(SpellBuilder.forEffect().onTick(PartBuilder.justAction(SpellAction.RESTORE_HEALTH.create(SpellCalcs.REJUVENATION)).setTarget(TargetSelector.TARGET.create()).tick(20.0)).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123750_, 5.0, 1.0).tick(20.0)).buildForEffect()).build();
        ExileEffectBuilder.of(INNER_CALM).maxStacks(1).addTags(EffectTags.heal_over_time).spell(SpellBuilder.forEffect().onTick(PartBuilder.justAction(SpellAction.RESTORE_MANA.create(SpellCalcs.REJUVENATION)).setTarget(TargetSelector.TARGET.create()).tick(20.0)).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123809_, 15.0, 1.0).tick(20.0)).buildForEffect()).build();
        ExileEffectBuilder.of(BLIZZARD_REDUCE_HEAL_STRENGTH).maxStacks(1).addTags(EffectTags.negative).stat(-30.0f, -50.0f, ResourceStats.HEAL_STRENGTH.get(), ModType.FLAT).build();
    }
}

