/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.neat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.mine_and_slash.a_libraries.neat.EffectIcon;
import com.robertx22.mine_and_slash.a_libraries.neat.NeatConfig;
import com.robertx22.mine_and_slash.a_libraries.neat.NeatRenderType;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.data.mob_affixes.MobAffix;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class HealthBarRenderer {
    private static final DecimalFormat HEALTH_FORMAT = new DecimalFormat("#.##");
    private static final TagKey<EntityType<?>> FORGE_BOSS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge", "bosses"));
    private static final TagKey<EntityType<?>> FABRIC_BOSS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("c", "bosses"));
    private static final int magicShieldColor = FastColor.ARGB32.m_13660_((int)190, (int)66, (int)241, (int)224);
    private static final int magicShieldShadowColor = HealthBarRenderer.makeShadowColor(magicShieldColor);

    private static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        HitResult pos = HealthBarRenderer.raycast(e, 32.0);
        Vec3 positionVector = e.m_146892_();
        double distance = pos.m_82450_().m_82554_(positionVector);
        Vec3 lookVector = e.m_20154_();
        Vec3 reachVector = positionVector.m_82520_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0);
        List entitiesInBoundingBox = e.m_9236_().m_45933_(e, e.m_20191_().m_82377_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0).m_82363_(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            Entity lookedEntity = null;
            if (entity.m_6087_()) {
                double distanceToEntity;
                AABB collisionBox = entity.m_6921_();
                Optional interceptPosition = collisionBox.m_82371_(positionVector, reachVector);
                if (collisionBox.m_82390_(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.m_82554_((Vec3)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance)) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static HitResult raycast(Entity e, double len) {
        Vec3 origin = e.m_146892_();
        Vec3 ray = e.m_20154_();
        Vec3 next = origin.m_82549_(ray.m_82541_().m_82490_(len));
        return e.m_9236_().m_45547_(new ClipContext(origin, next, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e));
    }

    private static ItemStack getIcon(LivingEntity entity, boolean boss) {
        if (boss) {
            return new ItemStack((ItemLike)Items.f_42686_);
        }
        MobType type = entity.m_6336_();
        if (type == MobType.f_21642_) {
            return new ItemStack((ItemLike)Items.f_42591_);
        }
        if (type == MobType.f_21641_) {
            return new ItemStack((ItemLike)Items.f_42583_);
        }
        return ItemStack.f_41583_;
    }

    private static int getColor(LivingEntity entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            }
            if (entity instanceof Monster) {
                r = 255;
                g = 0;
                b = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = Mth.m_14036_((float)entity.m_21223_(), (float)0.0f, (float)entity.m_21233_());
        float hue = Math.max(0.0f, health / entity.m_21233_() / 3.0f - 0.07f);
        return Mth.m_14169_((float)hue, (float)1.0f, (float)1.0f);
    }

    private static int makeShadowColor(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return FastColor.ARGB32.m_13660_((int)a, (int)(r * 61 / 100), (int)(g * 61 / 100), (int)(b * 61 / 100));
    }

    private static boolean isBoss(Entity entity) {
        return entity.m_6095_().m_204039_(FORGE_BOSS_TAG) || entity.m_6095_().m_204039_(FABRIC_BOSS_TAG);
    }

    private static boolean shouldShowPlate(LivingEntity living, Entity cameraEntity) {
        if (living == cameraEntity) {
            return false;
        }
        if (!NeatConfig.instance.renderInF1() && !Minecraft.m_91404_() || !NeatConfig.draw) {
            return false;
        }
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)living.m_6095_());
        if (NeatConfig.instance.blacklist().contains(id.toString())) {
            return false;
        }
        float distance = living.m_20270_(cameraEntity);
        if (distance > (float)NeatConfig.instance.maxDistance() || !living.m_142582_(cameraEntity)) {
            return false;
        }
        if (!NeatConfig.instance.showOnBosses() && HealthBarRenderer.isBoss((Entity)living)) {
            return false;
        }
        if (!NeatConfig.instance.showOnPlayers() && living instanceof Player) {
            return false;
        }
        if (!NeatConfig.instance.showFullHealth() && living.m_21223_() >= living.m_21233_()) {
            return false;
        }
        if (NeatConfig.instance.showOnlyFocused() && HealthBarRenderer.getEntityLookedAt(cameraEntity) != living) {
            return false;
        }
        boolean visible = true;
        if (cameraEntity instanceof Player) {
            Player cameraPlayer = (Player)cameraEntity;
            visible = !living.m_20177_(cameraPlayer);
        }
        Team livingTeam = living.m_5647_();
        Team cameraTeam = cameraEntity.m_5647_();
        if (livingTeam != null) {
            return switch (livingTeam.m_7470_()) {
                default -> throw new IncompatibleClassChangeError();
                case Team.Visibility.ALWAYS -> visible;
                case Team.Visibility.NEVER -> false;
                case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                    if (cameraTeam == null) {
                        yield visible;
                    }
                    if (livingTeam.m_83536_(cameraTeam) && (livingTeam.m_6259_() || visible)) {
                        yield true;
                    }
                    yield false;
                }
                case Team.Visibility.HIDE_FOR_OWN_TEAM -> cameraTeam == null ? visible : !livingTeam.m_83536_(cameraTeam) && visible;
            };
        }
        return visible;
    }

    static List<EffectIcon> getIcons(Entity e) {
        if (e instanceof LivingEntity) {
            LivingEntity en = (LivingEntity)e;
            return Load.Unit((Entity)en).getStatusEffectsData().exileMap.entrySet().stream().map(x -> Pair.of((Object)EffectIcon.of(((ExileEffect)ExileDB.ExileEffects().get((String)x.getKey())).getTexture(), ((ExileEffectInstanceData)x.getValue()).stacks), (Object)((ExileEffectInstanceData)x.getValue()).ticks_left)).sorted((x, y) -> -Integer.compare((Integer)x.getValue(), (Integer)y.getValue())).map(Pair::getLeft).filter(x -> x.location() != null).collect(Collectors.toCollection(ArrayList::new));
        }
        return Collections.EMPTY_LIST;
    }

    public static void hookRender(Entity entity, PoseStack poseStack, MultiBufferSource buffers, Quaternionf cameraOrientation) {
        LivingEntity living;
        Minecraft mc = Minecraft.m_91087_();
        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_20197_().isEmpty() && living.m_20197_().get(0) instanceof LivingEntity) {
            return;
        }
        if (!HealthBarRenderer.shouldShowPlate(living, mc.f_91063_.m_109153_().m_90592_())) {
            return;
        }
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        float textScale = 0.5f;
        int barHeight = NeatConfig.instance.barHeight();
        boolean boss = HealthBarRenderer.isBoss((Entity)living);
        List<EffectIcon> icons = HealthBarRenderer.getIcons(entity);
        MutableComponent name = HealthBarRenderer.getNameString(entity, living, mc);
        float nameLen = (float)(mc.f_91062_.m_92895_(name.getString()) + icons.size() * 5) * 0.5f;
        float halfSize = Math.max((float)NeatConfig.instance.plateSize(), nameLen / 2.0f + 10.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)living.m_20206_() + NeatConfig.instance.heightAbove(), 0.0);
        poseStack.m_252781_(cameraOrientation);
        poseStack.m_85836_();
        poseStack.m_85841_(-0.0267f, -0.0267f, 0.0267f);
        RenderType renderType = NeatRenderType.getHealthBarType();
        float padding = NeatConfig.instance.backgroundPadding();
        int bgHeight = NeatConfig.instance.backgroundHeight();
        if (NeatConfig.instance.drawBackground()) {
            VertexConsumer builder = buffers.m_6299_(renderType);
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize - padding, (float)(-bgHeight), 0.01f).m_6122_(0, 0, 0, 64).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize - padding, (float)barHeight + padding, 0.01f).m_6122_(0, 0, 0, 64).m_7421_(0.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize + padding, (float)barHeight + padding, 0.01f).m_6122_(0, 0, 0, 64).m_7421_(1.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize + padding, (float)(-bgHeight), 0.01f).m_6122_(0, 0, 0, 64).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        }
        int currentHealthPlusMagicShield = HealthUtils.getCurrentHealthPlusMagicShield(living);
        int currentHealth = HealthUtils.getCurrentHealth(living);
        int maxHealthPlusMagicShield = HealthUtils.getMaxHealthPlusMagicShield(living);
        float healthBarPercent = HealthUtils.getHealthBarPercent(living);
        float healthHalfSize = halfSize * healthBarPercent;
        float healthPart = Math.min(1.0f, (float)currentHealth * 1.0f / (float)currentHealthPlusMagicShield);
        int alpha = 127;
        int argb = HealthBarRenderer.getColor(living, NeatConfig.instance.colorByType(), boss) & 0xFFFFFF | 0x7F000000;
        int argbShadow = HealthBarRenderer.makeShadowColor(argb);
        VertexConsumer builder = buffers.m_6299_(renderType);
        Matrix4f poseInHere = poseStack.m_85850_().m_252922_();
        float healthLayerZ = 0.001f;
        float backgroundLayerZ = 0.002f;
        builder.m_252986_(poseInHere, -halfSize, 0.0f, healthLayerZ).m_193479_(argb).m_7421_(0.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize, (float)barHeight, healthLayerZ).m_193479_(argbShadow).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize + 2.0f * healthHalfSize * healthPart, (float)barHeight, 0.001f).m_193479_(argbShadow).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize + 2.0f * healthHalfSize * healthPart, 0.0f, healthLayerZ).m_193479_(argb).m_7421_(1.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize + 2.0f * healthHalfSize * healthPart, 0.0f, healthLayerZ).m_193479_(magicShieldColor).m_7421_(0.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize + 2.0f * healthHalfSize * healthPart, (float)barHeight, healthLayerZ).m_193479_(magicShieldShadowColor).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize + 2.0f * healthHalfSize, (float)barHeight, healthLayerZ).m_193479_(magicShieldShadowColor).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseInHere, -halfSize + 2.0f * healthHalfSize, 0.0f, healthLayerZ).m_193479_(magicShieldColor).m_7421_(1.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
        if (healthHalfSize < halfSize) {
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize + 2.0f * healthHalfSize, 0.0f, backgroundLayerZ).m_6122_(0, 0, 0, 127).m_7421_(0.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, backgroundLayerZ).m_6122_(0, 0, 0, 127).m_7421_(0.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, (float)barHeight, backgroundLayerZ).m_6122_(0, 0, 0, 127).m_7421_(1.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, 0.0f, backgroundLayerZ).m_6122_(0, 0, 0, 127).m_7421_(1.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
        }
        int white = 0xFFFFFF;
        boolean black = false;
        poseStack.m_85836_();
        poseStack.m_252880_(-halfSize, -4.5f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        mc.f_91062_.m_272077_((Component)name, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
        float healthValueTextScale = 0.375f;
        poseStack.m_85836_();
        poseStack.m_252880_(-halfSize, -4.5f, 0.0f);
        poseStack.m_85841_(0.375f, 0.375f, 0.375f);
        int h = NeatConfig.instance.hpTextHeight();
        if (NeatConfig.instance.showCurrentHP()) {
            String hpStr = MMORPG.formatBigNumber(currentHealthPlusMagicShield);
            mc.f_91062_.m_271703_(hpStr, 2.0f, (float)h, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showMaxHP()) {
            String maxHpStr = ChatFormatting.BOLD + MMORPG.formatBigNumber(maxHealthPlusMagicShield);
            mc.f_91062_.m_271703_(maxHpStr, (float)((int)(halfSize / 0.375f * 2.0f) - mc.f_91062_.m_92895_(maxHpStr) - 2), (float)h, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showPercentage()) {
            String percStr = (int)(100.0f * healthBarPercent) + "%";
            mc.f_91062_.m_271703_(percStr, (float)((int)(halfSize / 0.375f)) - (float)mc.f_91062_.m_92895_(percStr) / 2.0f, (float)h, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (NeatConfig.instance.enableDebugInfo() && mc.f_91066_.f_92063_) {
            ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)living.m_6095_());
            mc.f_91062_.m_271703_("ID: \"" + id + "\"", 0.0f, (float)(h + 16), 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        if (!icons.isEmpty()) {
            int size = 8;
            float iconInterval = 1.6f;
            poseStack.m_85836_();
            poseStack.m_85841_(-0.0267f, -0.0267f, 1.0f);
            poseStack.m_252880_(halfSize + padding, (float)bgHeight, 0.0f);
            float horizontalOffset = (float)(icons.size() * 8) + (float)(icons.size() - 1) * 1.6f;
            poseStack.m_252880_(-horizontalOffset, 0.0f, 0.0f);
            for (int i = 0; i < icons.size(); ++i) {
                if (i != 0) {
                    poseStack.m_252880_(9.6f, 0.0f, 0.0f);
                }
                icons.get(i).renderOnHealthBar(poseStack, buffers, 8);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    @NotNull
    public static MutableComponent getNameString(Entity entity, LivingEntity living, Minecraft mc) {
        int lvl = Load.Unit((Entity)living).getLevel();
        int playerlvl = Load.Unit((Entity)mc.f_91074_).getLevel();
        int diffabove = lvl - playerlvl;
        MutableComponent level = !(entity instanceof Player) && diffabove > (Integer)ServerContainer.get().LEVEL_DISTANCE_SKULL_SHOW.get() ? (((Boolean)ServerContainer.get().SKULL_HIDES_LEVEL.get()).booleanValue() ? Component.m_237113_((String)UNICODE.SKULL).m_130940_(ChatFormatting.RED) : Component.m_237113_((String)(lvl + " " + UNICODE.SKULL)).m_130940_(ChatFormatting.RED)) : Component.m_237113_((String)("" + lvl)).m_130940_(ChatFormatting.YELLOW);
        Component prefix = CommonComponents.f_237098_;
        Component name = living.m_5446_();
        Component suffix = CommonComponents.f_237098_;
        for (MobAffix affix : Load.Unit(entity).getAffixData().getAffixes()) {
            if (affix.type.isPrefix()) {
                prefix = affix.locName();
                continue;
            }
            suffix = affix.locName();
        }
        MutableComponent rarity = Load.Unit((Entity)living).getMobRarity().locName();
        ChatFormatting rarityColor = Load.Unit((Entity)living).getMobRarity().textFormatting();
        if (living instanceof Player) {
            rarity = CommonComponents.f_237098_;
            rarityColor = ChatFormatting.RED;
        }
        List<Component> rarity1 = List.of(rarity, prefix, name, suffix);
        for (Component component : rarity1) {
            if (!(component instanceof MutableComponent)) continue;
            ((MutableComponent)component).m_130940_(rarityColor);
        }
        Object[] array = (Component[])rarity1.toArray(Component[]::new);
        return Formatter.MOB_NAME_TEMPLATE.locName(ArrayUtils.addFirst((Object[])array, (Object)level)).m_130940_(ChatFormatting.YELLOW);
    }
}

