/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.jei;

import com.robertx22.library_of_exile.deferred.RegObj;
import com.robertx22.mine_and_slash.a_libraries.jei.RunewordExtension;
import com.robertx22.mine_and_slash.database.data.runewords.RunewordRecipe;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RuneItems;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.RuneItem;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RunewordCategory
implements IRecipeCategory<RunewordRecipe> {
    final IDrawable background;
    IGuiHelper guiHelper;
    RecipeType<RunewordRecipe> recipeType;
    final IDrawable icon;
    RunewordExtension recipeExtension;

    RunewordCategory(IGuiHelper guiHelper, RecipeType<RunewordRecipe> type) {
        this.guiHelper = guiHelper;
        this.recipeType = type;
        this.icon = guiHelper.createDrawableItemStack(((RuneItem)((RegObj)((Map.Entry)RuneItems.MAP.entrySet().stream().findFirst().get()).getValue()).get()).m_7968_());
        Dimensions dimension = this.calculateDimension();
        int maxWidth = dimension.width;
        int maxLines = dimension.lines;
        this.recipeExtension = new RunewordExtension(maxWidth);
        int height = this.recipeExtension.calculateMaxHeight(maxLines);
        this.background = guiHelper.createBlankDrawable(maxWidth, height);
    }

    private Dimensions calculateDimension() {
        AtomicInteger maxWidth = new AtomicInteger();
        AtomicInteger maxLines = new AtomicInteger();
        Font font = Minecraft.m_91087_().f_91062_;
        ExileDB.RuneWords().getList().forEach(word -> {
            word.stats.forEach(stat -> {
                List<Component> statTooltips = stat.getEstimationTooltip(1);
                for (Component statLine : statTooltips) {
                    int lineWidth = font.m_92852_((FormattedText)statLine);
                    maxWidth.set(Math.max(maxWidth.get(), lineWidth));
                }
            });
            maxLines.set(Math.max(maxLines.get(), word.stats.size()));
        });
        return new Dimensions(maxWidth.get(), maxLines.get());
    }

    public RecipeType<RunewordRecipe> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return Words.Runeword.locName();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RunewordRecipe recipe, IFocusGroup focuses) {
        this.recipeExtension.setRecipe(builder, recipe);
    }

    public void draw(RunewordRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int recipeWidth = this.getWidth();
        int recipeHeight = this.getHeight();
        this.recipeExtension.drawRunewordInfo(recipe, recipeWidth, recipeHeight, guiGraphics);
    }

    @Nullable
    public ResourceLocation getRegistryName(RunewordRecipe recipe) {
        return new ResourceLocation(recipe.id);
    }

    private class Dimensions {
        int width;
        int lines;

        Dimensions(int width, int height) {
            this.width = width;
            this.lines = height;
        }
    }
}

