/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.jei;

import com.robertx22.mine_and_slash.a_libraries.jei.CraftingCategory;
import com.robertx22.mine_and_slash.a_libraries.jei.CraftingTransfer;
import com.robertx22.mine_and_slash.a_libraries.jei.RunewordCategory;
import com.robertx22.mine_and_slash.a_libraries.jei.RunewordRecipes;
import com.robertx22.mine_and_slash.a_libraries.jei.iHideJei;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.profession.screen.AlchemyScreen;
import com.robertx22.mine_and_slash.database.data.profession.screen.CookingScreen;
import com.robertx22.mine_and_slash.database.data.profession.screen.GearCraftingScreen;
import com.robertx22.mine_and_slash.database.data.profession.screen.InfusingScreen;
import com.robertx22.mine_and_slash.database.data.runewords.RunewordRecipe;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashBlocks;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.vanilla_mc.items.crates.gem_crate.LootCrateItem;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JeiIntegration
implements IModPlugin {
    public static HashMap<String, RecipeType<ProfessionRecipe>> map = new HashMap();
    public static RecipeType<RunewordRecipe> runewordsRecipeType = RecipeType.create((String)"mmorpg", (String)"runewords", RunewordRecipe.class);

    public ResourceLocation getPluginUid() {
        return SlashRef.id("plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        this.init();
        for (Map.Entry<String, RecipeType<ProfessionRecipe>> en : map.entrySet()) {
            Profession pro = (Profession)ExileDB.Professions().get(en.getKey());
            registration.addRecipeCategories(new IRecipeCategory[]{new CraftingCategory(pro.id, helper, en.getValue(), (Component)pro.locName())});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new RunewordCategory(helper, runewordsRecipeType)});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ArrayList<ItemStack> itemsToHide = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof iHideJei)) continue;
            itemsToHide.add(item.m_7968_());
        }
        itemsToHide.add(((Item)SlashItems.INVISIBLE_ICON.get()).m_7968_());
        itemsToHide.add(((Item)SlashItems.TEST_GEN.get()).m_7968_());
        itemsToHide.add(((LootCrateItem)((Object)SlashItems.LOOT_CRATE.get())).m_7968_());
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, itemsToHide);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.init();
        for (Map.Entry<String, RecipeType<ProfessionRecipe>> en : map.entrySet()) {
            Profession pro = (Profession)ExileDB.Professions().get(en.getKey());
            if (!SlashBlocks.STATIONS.containsKey(pro.id)) continue;
            registration.addRecipeCatalyst(new ItemStack((ItemLike)SlashBlocks.STATIONS.get(pro.id).get()), new RecipeType[]{en.getValue()});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        this.init();
        for (Map.Entry<String, RecipeType<ProfessionRecipe>> en : map.entrySet()) {
            Profession pro = (Profession)ExileDB.Professions().get(en.getKey());
            CraftingTransfer t = new CraftingTransfer(pro.id, map.get(pro.id));
            registration.addRecipeTransferHandler((IRecipeTransferInfo)t);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        this.init();
        registration.addRecipeClickArea(GearCraftingScreen.class, 76, 1, 25, 14, new RecipeType[]{map.get(Professions.GEAR_CRAFTING)});
        registration.addRecipeClickArea(AlchemyScreen.class, 76, 1, 25, 14, new RecipeType[]{map.get(Professions.ALCHEMY)});
        registration.addRecipeClickArea(CookingScreen.class, 76, 1, 25, 14, new RecipeType[]{map.get(Professions.COOKING)});
        registration.addRecipeClickArea(InfusingScreen.class, 76, 1, 25, 14, new RecipeType[]{map.get(Professions.INFUSING)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.init();
        for (Map.Entry<String, RecipeType<ProfessionRecipe>> en : map.entrySet()) {
            List list = ExileDB.Recipes().getFilterWrapped((Predicate<ProfessionRecipe>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$registerRecipes$0(java.util.Map$Entry com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe ), (Lcom/robertx22/mine_and_slash/database/data/profession/ProfessionRecipe;)Z)(en)).list;
            list.sort(Comparator.comparingInt(x -> x.tier));
            registration.addRecipes(en.getValue(), list);
        }
        registration.addRecipes(runewordsRecipeType, RunewordRecipes.Generate(ExileDB.RuneWords()));
    }

    public void init() {
        if (map.isEmpty()) {
            for (String pro : Professions.STATION_PROFESSIONS) {
                map.put(pro, (RecipeType<ProfessionRecipe>)RecipeType.create((String)"mmorpg", (String)pro, ProfessionRecipe.class));
            }
        }
    }

    private static /* synthetic */ boolean lambda$registerRecipes$0(Map.Entry en, ProfessionRecipe x) {
        return x.profession.equals(en.getKey());
    }
}

