/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.robertx22.mine_and_slash.a_libraries.jei.CraftingExtension;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CraftingCategory
implements IExtendableRecipeCategory<ProfessionRecipe, ICraftingCategoryExtension> {
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final ICraftingGridHelper craftingGridHelper;
    public static final String TEXTURE_GUI_PATH = "textures/jei/gui/";
    public static final String TEXTURE_GUI_VANILLA = "textures/jei/gui/gui_vanilla.png";
    public static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/jei/gui/gui_vanilla.png");
    ICraftingCategoryExtension recipeExtension;
    RecipeType<ProfessionRecipe> type;
    Component word;
    String prof;

    public CraftingCategory(String prof, IGuiHelper guiHelper, RecipeType<ProfessionRecipe> type, Component word) {
        this.prof = prof;
        ResourceLocation location = RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)SlashItems.STATIONS.get(prof).get()));
        this.word = word;
        this.type = type;
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    public RecipeType<ProfessionRecipe> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return this.word;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ProfessionRecipe recipe, IFocusGroup focuses) {
        this.recipeExtension = new CraftingExtension(recipe);
        this.recipeExtension.setRecipe(builder, this.craftingGridHelper, focuses);
    }

    public void draw(ProfessionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int recipeWidth = this.getWidth();
        int recipeHeight = this.getHeight();
        this.recipeExtension.drawInfo(recipeWidth, recipeHeight, guiGraphics, mouseX, mouseY);
    }

    public List<Component> getTooltipStrings(ProfessionRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> list = new ArrayList<Component>();
        int diffx = (int)Math.abs(mouseX - 70.0);
        int diffy = (int)Math.abs(mouseY - 22.0);
        if (diffx < 10 && diffy < 10) {
            list.addAll(recipe.getTooltipJEI());
        }
        list.addAll(this.recipeExtension.getTooltipStrings(mouseX, mouseY));
        return list;
    }

    public boolean handleInput(ProfessionRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return this.recipeExtension.handleInput(mouseX, mouseY, input);
    }

    public boolean isHandled(ProfessionRecipe recipe) {
        return true;
    }

    public <R extends ProfessionRecipe> void addCategoryExtension(Class<? extends R> recipeClass, Function<R, ? extends ICraftingCategoryExtension> extensionFactory) {
    }

    public <R extends ProfessionRecipe> void addCategoryExtension(Class<? extends R> recipeClass, Predicate<R> extensionFilter, Function<R, ? extends ICraftingCategoryExtension> extensionFactory) {
    }

    public ResourceLocation getRegistryName(ProfessionRecipe recipe) {
        return new ResourceLocation(recipe.result);
    }
}

