/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.GearModification;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemModificationSers;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarityType;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.SocketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import net.minecraft.network.chat.MutableComponent;

public class UpgradeRarityItemMod
extends GearModification {
    public UpgradeType type;

    public UpgradeRarityItemMod(String id, UpgradeType type) {
        super(ItemModificationSers.UPGRADE_GEAR_RARITY, id);
        this.type = type;
    }

    public static int uniformRescaleInt(int x, MinMax from, MinMax to) {
        return Math.min(to.min + (x - from.min) * (to.max - to.min + 1) / (from.max - from.min), to.max);
    }

    @Override
    public void modifyGear(ExileStack stack, ItemModificationResult r) {
        stack.get(StackKeys.GEAR).edit(gear -> {
            int index;
            GearRarity oldRarity = gear.getRarity();
            GearRarity newRarity = this.type.getNewRarity((GearItemData)gear);
            gear.rar = newRarity.GUID();
            MinMax oldRange = oldRarity.stat_percents;
            MinMax newRange = newRarity.stat_percents;
            gear.affixes.getPrefixesAndSuffixes().forEach(affix -> {
                affix.p = affix.p < oldRange.max ? Integer.valueOf(UpgradeRarityItemMod.uniformRescaleInt(affix.p, new MinMax(0, oldRange.max), new MinMax(0, newRange.max))) : Integer.valueOf(Math.max(affix.p, newRange.max));
                while (affix.p > affix.getRarity().stat_percents.max) {
                    affix.rar = affix.getRarity().getHigherRarity().GUID();
                }
            });
            gear.baseStats.p = UpgradeRarityItemMod.uniformRescaleInt(gear.baseStats.p, oldRarity.base_stat_percents, newRarity.base_stat_percents);
            for (int affixesToAdd = newRarity.getAffixAmount() - gear.affixes.getNumberOfAffixes(); affixesToAdd > 0; --affixesToAdd) {
                gear.affixes.addOneRandomAffix((GearItemData)gear);
            }
            for (index = gear.sockets.getSocketedGemsCount() - 1; index >= newRarity.sockets.max; --index) {
                SocketData socket = gear.sockets.getSocketed().get(index);
                r.extraItemsCreated.add(socket.getOriginalItemStack());
                gear.sockets.getSocketed().remove(index);
            }
            for (index = gear.sockets.getTotalSockets() - 1; index >= newRarity.sockets.max; --index) {
                gear.sockets.removeSocket();
            }
        });
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return ItemModification.OutcomeType.GOOD;
    }

    public Class<?> getClassForSerialization() {
        return UpgradeRarityItemMod.class;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.type.action.locName(), this.type.affixPlural.locName()});
    }

    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of((String)"mmorpg").desc(ExileTranslation.registry((ExileRegistry)this, (String)"%1$s, increasing Numbers and adding %2$s"));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum UpgradeType {
        UPGRADE(Words.UPGRADE_RARITY, Words.AN_AFFIX){

            @Override
            public GearRarity getNewRarity(GearItemData gear) {
                return gear.getRarity().getHigherRarity();
            }
        }
        ,
        RANDOMIZE(Words.RANDOMIZE_RARITY, Words.AFFIXES){

            @Override
            public GearRarity getNewRarity(GearItemData gear) {
                GearRarity oldRarity = gear.getRarity();
                return (GearRarity)ExileDB.GearRarities().getFilterWrapped(x -> {
                    if (x == oldRarity) {
                        return false;
                    }
                    if (gear.lvl < x.min_lvl) {
                        return false;
                    }
                    return x.type == GearRarityType.NORMAL;
                }).random();
            }
        };

        public Words action;
        public Words affixPlural;

        private UpgradeType(Words action, Words affixPlural) {
            this.action = action;
            this.affixPlural = affixPlural;
        }

        public abstract GearRarity getNewRarity(GearItemData var1);
    }
}

