/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.GearModification;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemModificationSers;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;

public class RerollAffixNumbersItemMod
extends GearModification {
    public AffixFinder data;

    public RerollAffixNumbersItemMod(String id, AffixFinder data) {
        super(ItemModificationSers.REROLL_AFFIX_NUMBERS, id);
        this.data = data;
    }

    @Override
    public void modifyGear(ExileStack stack, ItemModificationResult r) {
        stack.get(StackKeys.GEAR).edit(gear -> this.getData().getAffixes(gear.affixes.getPrefixesAndSuffixes()).forEach(affix -> affix.RerollNumbers()));
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return ItemModification.OutcomeType.GOOD;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.getData().getTooltip()});
    }

    public Class<?> getClassForSerialization() {
        return RerollAffixNumbersItemMod.class;
    }

    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of((String)"mmorpg").desc(ExileTranslation.registry((ExileRegistry)this, (String)"Re-rolls %1$s Numbers"));
    }

    protected AffixFinder getData() {
        return this.data != null ? this.data : AffixFinder.AFFIX;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AffixFinder {
        AFFIX(Words.AFFIX){

            @Override
            public List<AffixData> getAffixes(List<AffixData> affixes) {
                return affixes;
            }
        }
        ,
        PREFIX(Words.PREFIX){

            @Override
            public List<AffixData> getAffixes(List<AffixData> affixes) {
                return affixes.stream().filter(x -> x.ty.isPrefix()).toList();
            }
        }
        ,
        SUFFIX(Words.SUFFIX){

            @Override
            public List<AffixData> getAffixes(List<AffixData> affixes) {
                return affixes.stream().filter(x -> x.ty.isSuffix()).toList();
            }
        };

        private Words word;

        private AffixFinder(Words word) {
            this.word = word;
        }

        protected Words getWordINTERNAL() {
            return this.word;
        }

        public MutableComponent getTooltip() {
            return this.word.locName();
        }

        public abstract List<AffixData> getAffixes(List<AffixData> var1);
    }
}

