/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked;

import com.robertx22.addons.orbs_of_crafting.currency.base.CodeCurrency;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.ExileCurrencies;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.addon.ExtendedOrb;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemMods;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_req.ItemReqs;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.keys.RarityKeyInfo;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.keys.SkillItemTierKey;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.registry.helpers.ExileKey;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolder;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolderSection;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyMap;
import com.robertx22.library_of_exile.registry.helpers.IdKey;
import com.robertx22.library_of_exile.registry.helpers.KeyInfo;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import com.robertx22.mine_and_slash.loot.req.DropRequirement;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.orbs_of_crafting.misc.ShapedRecipeUTIL;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import com.robertx22.orbs_of_crafting.register.Modifications;
import com.robertx22.temp.SkillItemTier;
import com.robertx22.the_harvest.main.HarvestEntries;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class HarvestCurrencies
extends ExileKeyHolderSection<ExileCurrencies> {
    public ExileKeyMap<ExileCurrency, SkillItemTierKey> HARVEST_ESSENCE = new ExileKeyMap(this.get(), "harvest_essence").ofList(Arrays.stream(SkillItemTier.values()).toList().stream().filter(x -> x != SkillItemTier.TIER5).map(x -> new SkillItemTierKey((SkillItemTier)((Object)x))).collect(Collectors.toList())).build((id, info) -> {
        HarvestCurrencies.harvestOnlyDrop(id);
        return ExileCurrency.Builder.of((String)id, (String)("Harvested " + info.tier.word + " Essence"), (ExileKey[])new ExileKey[]{ItemReqs.INSTANCE.IS_GEAR}).rarity(info.tier.rar).addRequirement(ItemReqs.INSTANCE.IS_NOT_CORRUPTED).addRequirement(ItemReqs.INSTANCE.IS_NOT_MIRRORED).addRequirement(ItemReqs.INSTANCE.NOT_CRAFTED).addRequirement(ItemReqs.INSTANCE.HAS_AFFIX_OF_RARITY.get((KeyInfo)new RarityKeyInfo(info.tier.rar))).addModification(Modifications.INSTANCE.DESTROY_ITEM, 15).addModification(ItemMods.INSTANCE.UPGRADE_SPECIFIC_AFFIX_RARITY.get((KeyInfo)new RarityKeyInfo(info.tier.rar)), 85).potentialCost(1).weight(5).buildCurrency(this.get());
    });
    public ExileKey<ExileCurrency, IdKey> HARVEST_AFFIX_UPGRADE;
    public ExileKey<ExileCurrency, IdKey> HARVEST_POTENTIAL_UPGRADE;
    public ExileKey<ExileCurrency, IdKey> HARVEST_QUALITY;
    public ExileKey<ExileCurrency, IdKey> HARVEST_UNIQUE_STATS;

    public HarvestCurrencies(ExileCurrencies holder) {
        super((ExileKeyHolder)holder);
        this.HARVEST_AFFIX_UPGRADE = ExileCurrency.Builder.of((String)"entangled_affix_upgrade", (String)"Entangled Orb of Upgrade", (ExileKey[])new ExileKey[]{ItemReqs.INSTANCE.IS_GEAR}).rarity("legendary").addRequirement(ItemReqs.INSTANCE.IS_NOT_CORRUPTED).addRequirement(ItemReqs.INSTANCE.IS_NOT_MIRRORED).addRequirement(ItemReqs.INSTANCE.HAS_AFFIXES).addModification(ItemMods.INSTANCE.UPGRADE_LOWEST_AFFIX, 50).addModification(ItemMods.INSTANCE.CORRUPT_GEAR_NO_AFFIXES, 50).potentialCost(1).weight(CodeCurrency.Weights.UBER).build(this.get());
        this.HARVEST_POTENTIAL_UPGRADE = ExileCurrency.Builder.of((String)"entangled_potential", (String)"Entangled Orb of Potential", (ExileKey[])new ExileKey[]{ItemReqs.INSTANCE.IS_GEAR}).rarity("legendary").addRequirement(ItemReqs.INSTANCE.IS_NOT_CORRUPTED).addRequirement(ItemReqs.INSTANCE.IS_NOT_MIRRORED).addModification(ItemMods.INSTANCE.ADD_25_POTENTIAL, 75).addModification(ItemMods.INSTANCE.CORRUPT_GEAR_NO_AFFIXES, 25).potentialCost(0).weight(CodeCurrency.Weights.UBER).build(this.get());
        this.HARVEST_QUALITY = ExileCurrency.Builder.of((String)"entangled_quality", (String)"Entangled Orb of Quality", (ExileKey[])new ExileKey[]{ItemReqs.INSTANCE.IS_GEAR}).rarity("legendary").addRequirement(ItemReqs.INSTANCE.IS_NOT_CORRUPTED).addRequirement(ItemReqs.INSTANCE.IS_NOT_MIRRORED).addRequirement(ItemReqs.INSTANCE.UNDER_21_QUALITY).addModification(ItemMods.INSTANCE.ADD_UP_TO_5_GEAR_QUALITY, 75).addModification(ItemMods.INSTANCE.CORRUPT_GEAR_NO_AFFIXES, 25).potentialCost(0).weight(CodeCurrency.Weights.UBER).build(this.get());
        this.HARVEST_UNIQUE_STATS = ExileCurrency.Builder.of((String)"entangled_unique_reroll", (String)"Entangled Orb of Imperfection", (ExileKey[])new ExileKey[]{ItemReqs.INSTANCE.IS_GEAR}).rarity("legendary").addRequirement(ItemReqs.INSTANCE.IS_NOT_CORRUPTED).addRequirement(ItemReqs.INSTANCE.IS_NOT_MIRRORED).addRequirement(ItemReqs.INSTANCE.IS_RARITY.get((KeyInfo)new RarityKeyInfo("unique"))).addModification(ItemMods.INSTANCE.ADD_10_PERCENT_UNIQUE_STATS, 30).addModification(ItemMods.INSTANCE.CORRUPT_GEAR_NO_AFFIXES, 70).potentialCost(0).weight(CodeCurrency.Weights.UBER).build(this.get());
    }

    public static void harvestOnlyDrop(String id) {
        new ExtendedOrb(id, DropRequirement.Builder.of().setOnlyDropsInLeague("the_harvest").build()).addToSerializables((ExileRegistrationInfo)MMORPG.SERIAZABLE_REGISTRATION_INFO);
    }

    public void init() {
        HarvestCurrencies.harvestOnlyDrop(this.HARVEST_UNIQUE_STATS.GUID());
        HarvestCurrencies.harvestOnlyDrop(this.HARVEST_QUALITY.GUID());
        HarvestCurrencies.harvestOnlyDrop(this.HARVEST_POTENTIAL_UPGRADE.GUID());
        HarvestCurrencies.harvestOnlyDrop(this.HARVEST_AFFIX_UPGRADE.GUID());
        for (Map.Entry en : this.HARVEST_ESSENCE.map.entrySet()) {
            ((ExileKey)en.getValue()).addRecipe(LibDatabase.CURRENCY, x -> ShapedRecipeUTIL.of((ItemLike)x.getItem(), (int)1).m_126127_(Character.valueOf('X'), (ItemLike)this.HARVEST_AFFIX_UPGRADE.getItem()).m_126127_(Character.valueOf('Y'), (ItemLike)RarityItems.RARITY_STONE.get(((SkillItemTierKey)x.info).tier.higherTier().rar).get()).m_126130_("YYY").m_126130_("YXY").m_126130_("YYY"));
        }
        this.HARVEST_AFFIX_UPGRADE.addRecipe(LibDatabase.CURRENCY, x -> ShapedRecipeUTIL.of((ItemLike)x.getItem(), (int)1).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42416_).m_126127_(Character.valueOf('Y'), (ItemLike)HarvestEntries.BLUE.get()).m_126130_("YYY").m_126130_("YXY").m_126130_("YYY"));
        this.HARVEST_POTENTIAL_UPGRADE.addRecipe(LibDatabase.CURRENCY, x -> ShapedRecipeUTIL.of((ItemLike)x.getItem(), (int)1).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('Y'), (ItemLike)HarvestEntries.PURPLE.get()).m_126130_("YYY").m_126130_("YXY").m_126130_("YYY"));
        this.HARVEST_QUALITY.addRecipe(LibDatabase.CURRENCY, x -> ShapedRecipeUTIL.of((ItemLike)x.getItem(), (int)1).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('Y'), (ItemLike)HarvestEntries.GREEN.get()).m_126130_("YYY").m_126130_("YXY").m_126130_("YYY"));
        this.HARVEST_QUALITY.addConditional("the_harvest", x -> ShapedRecipeUTIL.of((ItemLike)this.HARVEST_UNIQUE_STATS.getItem(), (int)1).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41959_).m_126127_(Character.valueOf('Y'), (ItemLike)HarvestEntries.PURPLE.get()).m_126130_("YYY").m_126130_("YXY").m_126130_("YYY"));
    }
}

