/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.world;

import com.mojang.serialization.Codec;
import io.github.colochampre.riskofrain_mobs.RoRConfig;
import io.github.colochampre.riskofrain_mobs.init.BiomeModifierInit;
import io.github.colochampre.riskofrain_mobs.init.EntityInit;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class RoRBiomeModifier
implements BiomeModifier {
    public static final RoRBiomeModifier INSTANCE = new RoRBiomeModifier();

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && biome.containsTag(BiomeTags.f_215817_) && !biome.m_203565_(Biomes.f_220594_) && !biome.m_203656_(Tags.Biomes.IS_VOID)) {
            if ((Integer)RoRConfig.SERVER.DRONES_SPAWN_RATE.get() > 0) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.GUNNER_DRONE_ENTITY.get(), ((Integer)RoRConfig.SERVER.DRONES_SPAWN_RATE.get()).intValue(), 1, 1));
            }
            if ((Integer)RoRConfig.SERVER.LEMURIAN_OVERWORLD_SPAWN_RATE.get() > 0 && !biome.m_203656_(Tags.Biomes.IS_MUSHROOM)) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.LEMURIAN_ENTITY.get(), ((Integer)RoRConfig.SERVER.LEMURIAN_OVERWORLD_SPAWN_RATE.get()).intValue(), ((Integer)RoRConfig.SERVER.LEMURIAN_MIN_GROUP_SIZE.get()).intValue(), ((Integer)RoRConfig.SERVER.LEMURIAN_MAX_GROUP_SIZE.get()).intValue()));
            }
            if ((Integer)RoRConfig.SERVER.STONE_GOLEM_OVERWORLD_SPAWN_RATE.get() > 0 && !biome.m_203656_(Tags.Biomes.IS_MUSHROOM)) {
                builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.STONE_GOLEM_ENTITY.get(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_OVERWORLD_SPAWN_RATE.get()).intValue(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_MIN_GROUP_SIZE.get()).intValue(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_MAX_GROUP_SIZE.get()).intValue()));
            }
        }
        if (phase == BiomeModifier.Phase.ADD && biome.containsTag(BiomeTags.f_207612_) && !biome.m_203656_(Tags.Biomes.IS_VOID)) {
            if ((Integer)RoRConfig.SERVER.LEMURIAN_NETHER_SPAWN_RATE.get() > 0) {
                if (biome.m_203565_(Biomes.f_48200_) || biome.m_203565_(Biomes.f_48201_)) {
                    builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.LEMURIAN_ENTITY.get(), Mth.m_14165_((double)((double)((Integer)RoRConfig.SERVER.LEMURIAN_NETHER_SPAWN_RATE.get()).intValue() / 2.0)), ((Integer)RoRConfig.SERVER.LEMURIAN_MIN_GROUP_SIZE.get()).intValue(), ((Integer)RoRConfig.SERVER.LEMURIAN_MAX_GROUP_SIZE.get()).intValue()));
                } else {
                    builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.LEMURIAN_ENTITY.get(), ((Integer)RoRConfig.SERVER.LEMURIAN_NETHER_SPAWN_RATE.get()).intValue(), ((Integer)RoRConfig.SERVER.LEMURIAN_MIN_GROUP_SIZE.get()).intValue(), ((Integer)RoRConfig.SERVER.LEMURIAN_MAX_GROUP_SIZE.get()).intValue()));
                }
            }
            if ((Integer)RoRConfig.SERVER.STONE_GOLEM_NETHER_SPAWN_RATE.get() > 0) {
                if (biome.m_203565_(Biomes.f_48200_) || biome.m_203565_(Biomes.f_48201_)) {
                    builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.STONE_GOLEM_ENTITY.get(), Mth.m_14165_((double)((double)((Integer)RoRConfig.SERVER.STONE_GOLEM_NETHER_SPAWN_RATE.get()).intValue() / 2.0)), ((Integer)RoRConfig.SERVER.STONE_GOLEM_MIN_GROUP_SIZE.get()).intValue(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_MAX_GROUP_SIZE.get()).intValue()));
                } else {
                    builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.STONE_GOLEM_ENTITY.get(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_NETHER_SPAWN_RATE.get()).intValue(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_MIN_GROUP_SIZE.get()).intValue(), ((Integer)RoRConfig.SERVER.STONE_GOLEM_MAX_GROUP_SIZE.get()).intValue()));
                }
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BiomeModifierInit.ROR_ENTITY_MODIFIER_TYPE.get();
    }
}

