/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.events;

import io.github.colochampre.riskofrain_mobs.RoRConfig;
import io.github.colochampre.riskofrain_mobs.entities.AbstractFlyingDroneEntity;
import io.github.colochampre.riskofrain_mobs.entities.GunnerDroneEntity;
import io.github.colochampre.riskofrain_mobs.entities.LemurianEntity;
import io.github.colochampre.riskofrain_mobs.entities.StoneGolemEntity;
import io.github.colochampre.riskofrain_mobs.init.EntityInit;
import io.github.colochampre.riskofrain_mobs.init.SoundInit;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ModCommonEvents {

    @Mod.EventBusSubscriber(modid="riskofrain_mobs", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.LEMURIAN_ENTITY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, LemurianEntity::canSpawn);
                SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.STONE_GOLEM_ENTITY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, StoneGolemEntity::canSpawn);
                SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.GUNNER_DRONE_ENTITY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, GunnerDroneEntity::checkDroneSpawnRules);
            });
        }

        @SubscribeEvent
        public static void entityAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityInit.LEMURIAN_ENTITY.get(), LemurianEntity.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.STONE_GOLEM_ENTITY.get(), StoneGolemEntity.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.GUNNER_DRONE_ENTITY.get(), GunnerDroneEntity.createAttributes().m_22265_());
        }
    }

    @Mod.EventBusSubscriber(modid="riskofrain_mobs")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void playerDeathSound(LivingDeathEvent event) {
            LivingEntity livingEntity;
            if (((Boolean)RoRConfig.SERVER.DEATH_SOUND.get()).booleanValue() && (livingEntity = event.getEntity()) instanceof Player) {
                Player player = (Player)livingEntity;
                Level level = player.m_9236_();
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundInit.PLAYER_DEATH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }

        @SubscribeEvent
        public static void immuneDrones(LivingAttackEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof AbstractFlyingDroneEntity) {
                AbstractFlyingDroneEntity drone = (AbstractFlyingDroneEntity)livingEntity;
                if (event.getSource().m_7640_() instanceof LivingEntity) {
                    boolean isTamed = drone.m_21824_();
                    if (isTamed) {
                        return;
                    }
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

