/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.events;

import io.github.colochampre.riskofrain_mobs.client.models.GunnerDroneModel;
import io.github.colochampre.riskofrain_mobs.client.models.LemurianModel;
import io.github.colochampre.riskofrain_mobs.client.models.StoneGolemModel;
import io.github.colochampre.riskofrain_mobs.client.renderer.BulletRenderer;
import io.github.colochampre.riskofrain_mobs.client.renderer.GunnerDroneRenderer;
import io.github.colochampre.riskofrain_mobs.client.renderer.LemurianRenderer;
import io.github.colochampre.riskofrain_mobs.client.renderer.StoneGolemRenderer;
import io.github.colochampre.riskofrain_mobs.init.EntityInit;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="riskofrain_mobs", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModClientEvents {
    public static final ModelLayerLocation LEMURIAN_LAYER = new ModelLayerLocation(new ResourceLocation("riskofrain_mobs", "lemurian_entity"), "main");
    public static final ModelLayerLocation STONE_GOLEM_LAYER = new ModelLayerLocation(new ResourceLocation("riskofrain_mobs", "stone_golem_entity"), "main");
    public static final ModelLayerLocation GUNNER_DRONE_LAYER = new ModelLayerLocation(new ResourceLocation("riskofrain_mobs", "gunner_drone_entity"), "main");

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityInit.LEMURIAN_ENTITY.get(), LemurianRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.STONE_GOLEM_ENTITY.get(), StoneGolemRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.GUNNER_DRONE_ENTITY.get(), GunnerDroneRenderer::new);
        event.registerEntityRenderer((EntityType)EntityInit.DRONE_BULLET_ENTITY.get(), BulletRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions events) {
        events.registerLayerDefinition(LEMURIAN_LAYER, LemurianModel::createBodyLayer);
        events.registerLayerDefinition(STONE_GOLEM_LAYER, StoneGolemModel::createBodyLayer);
        events.registerLayerDefinition(GUNNER_DRONE_LAYER, GunnerDroneModel::createBodyLayer);
    }
}

