/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities.goals;

import io.github.colochampre.riskofrain_mobs.entities.StoneGolemEntity;
import io.github.colochampre.riskofrain_mobs.init.SoundInit;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class StoneGolemAttackGoal
extends Goal {
    private final StoneGolemEntity golem;
    private int laserAttackTick;
    private int laserCooldown = 0;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public StoneGolemAttackGoal(StoneGolemEntity entity, double speed, boolean memory) {
        this.golem = entity;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = memory;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.golem.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.golem.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.golem.m_217043_().m_188503_(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.golem.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.golem.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.golem.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.golem.m_21573_().m_26571_();
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.laserAttackTick = -10;
        LivingEntity livingentity = this.golem.m_5448_();
        if (livingentity != null) {
            this.golem.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
        }
        this.golem.m_21573_().m_26536_(this.path, this.speedModifier);
        this.golem.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        this.golem.setActiveAttackTarget(0);
        this.golem.m_6710_(null);
        this.golem.m_21561_(false);
        this.golem.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.golem.m_5448_();
        --this.laserCooldown;
        if (livingentity != null) {
            boolean flag = this.golem.m_142582_((Entity)livingentity);
            this.golem.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
            this.meleeAttackTick(livingentity);
            if (!flag) {
                this.golem.m_6710_(null);
            } else {
                this.laserTick(livingentity);
            }
        }
    }

    private void meleeAttackTick(LivingEntity livingentity) {
        double d0 = this.golem.m_262793_(livingentity);
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.golem.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.golem.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.golem.m_217043_().m_188503_(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.golem.m_21573_().m_26570_() != null ? ((finalPathPoint = this.golem.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.golem.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void laserTick(LivingEntity livingentity) {
        if (this.laserCooldown <= 0) {
            ++this.laserAttackTick;
        }
        if (this.laserAttackTick == 0) {
            this.golem.setActiveAttackTarget(livingentity.m_19879_());
            if (!this.golem.m_20067_()) {
                this.golem.m_9236_().m_7605_((Entity)this.golem, (byte)21);
                this.golem.m_5496_(this.getLaserChargeSound(), 2.0f, 1.0f);
            }
        } else if (this.laserAttackTick >= this.golem.getAttackDuration()) {
            float f = 2.0f;
            Vec3 vec3 = this.golem.m_20154_().m_82542_(1.0, 1.0, 1.0).m_82541_().m_82490_(3.0);
            if (this.golem.m_9236_().m_46791_() == Difficulty.HARD) {
                f *= 2.0f;
            }
            this.golem.m_5496_(this.getLaserFireSound(), 3.0f, 1.0f);
            livingentity.m_5496_(this.getLaserFireSound(), 3.0f, 1.0f);
            livingentity.m_6469_(this.golem.m_269291_().m_269104_((Entity)this.golem, (Entity)this.golem), f);
            livingentity.m_6469_(this.golem.m_269291_().m_269333_((LivingEntity)this.golem), this.golem.getAttackDamage() / 2.0f);
            livingentity.m_246865_(vec3);
            this.golem.m_6710_(null);
            this.laserCooldown = 85;
        }
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity, double distance) {
        double d0 = this.getAttackReachSqr(livingEntity);
        if (distance <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.golem.m_6674_(InteractionHand.MAIN_HAND);
            this.golem.m_7327_((Entity)livingEntity);
            this.golem.strongKnockback((Entity)livingEntity);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(40);
    }

    protected SoundEvent getLaserChargeSound() {
        return (SoundEvent)SoundInit.STONE_GOLEM_LASER_CHARGE.get();
    }

    protected SoundEvent getLaserFireSound() {
        return (SoundEvent)SoundInit.STONE_GOLEM_LASER_FIRE.get();
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return this.golem.m_20205_() * 1.5f * this.golem.m_20205_() * 1.5f + entity.m_20205_();
    }
}

