/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities.goals;

import io.github.colochampre.riskofrain_mobs.entities.GunnerDroneEntity;
import io.github.colochampre.riskofrain_mobs.init.SoundInit;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class GunnerDroneAttackGoal
extends Goal {
    private final float maxAttackDistance;
    private final GunnerDroneEntity drone;
    private int attackStep;
    private int attackTime;

    public GunnerDroneAttackGoal(GunnerDroneEntity entity, float maxAttackDistance) {
        this.drone = entity;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.drone.m_5448_();
        return livingentity != null && livingentity.m_6084_() && this.drone.m_6779_(livingentity);
    }

    public void m_8056_() {
        super.m_8056_();
        this.drone.m_21561_(true);
        this.attackStep = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.drone.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.drone.m_6710_(null);
        }
        this.drone.m_21561_(false);
        this.drone.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity livingentity = this.drone.m_5448_();
        if (livingentity != null) {
            boolean flag = this.drone.m_21574_().m_148306_((Entity)livingentity);
            double d0 = this.drone.m_20280_((Entity)livingentity);
            Vec3 vec3a = this.drone.m_20184_();
            Vec3 vec3b = this.drone.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(0.05).m_82548_();
            if (!flag) {
                this.drone.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 0.8);
            } else {
                this.drone.m_21563_().m_24960_((Entity)livingentity, 30.0f, 90.0f);
                if (livingentity.m_20188_() > this.drone.m_20188_()) {
                    this.drone.m_20256_(this.drone.m_20184_().m_82520_(0.0, ((double)0.2f - vec3a.f_82480_) * (double)0.2f, 0.0));
                    this.drone.f_19812_ = true;
                }
                if (d0 < (double)this.maxAttackDistance && flag) {
                    if (d0 < (double)this.maxAttackDistance * 0.3) {
                        this.drone.m_20256_(this.drone.m_20184_().m_82520_(vec3b.f_82479_ / 2.0, 0.0, vec3b.f_82481_ / 2.0));
                        this.drone.f_19812_ = true;
                    }
                    if (d0 > (double)this.maxAttackDistance * 0.75 && !(d0 < (double)this.maxAttackDistance * 0.5)) {
                        this.drone.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 0.8);
                    }
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 30;
                        } else if (this.attackStep <= 5) {
                            this.attackTime = 4;
                        } else {
                            this.attackTime = 30;
                            this.attackStep = 0;
                            this.drone.m_6710_(null);
                        }
                        if (this.attackStep > 1) {
                            if (!this.drone.m_20067_()) {
                                this.drone.m_5496_(this.getDroneShootSound(), 1.5f, 1.0f);
                            }
                            for (int i = 0; i < 1; ++i) {
                                this.drone.m_6504_(livingentity, this.maxAttackDistance);
                            }
                        }
                        this.drone.m_21563_().m_24960_((Entity)livingentity, 30.0f, 90.0f);
                    }
                }
            }
            super.m_8037_();
        }
    }

    protected SoundEvent getDroneShootSound() {
        return (SoundEvent)SoundInit.GUNNER_DRONE_SHOOT.get();
    }
}

