/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities;

import io.github.colochampre.riskofrain_mobs.RoRConfig;
import io.github.colochampre.riskofrain_mobs.entities.goals.StoneGolemAttackGoal;
import io.github.colochampre.riskofrain_mobs.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneGolemEntity
extends Monster {
    private static final ResourceLocation STONE_GOLEM_LOOT_TABLE = new ResourceLocation("riskofrain_mobs", "entities/stone_golem_entity");
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(StoneGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final HurtByTargetGoal hurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[0]);
    private int attackTimer;
    public int clientSideAttackTime;
    private LivingEntity clientSideCachedAttackTarget;

    public StoneGolemEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.f_21364_ = 24;
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new StoneGolemAttackGoal(this, 0.8, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WanderingTrader.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_8107_() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.f_21345_.m_25352_(3, (Goal)this.hurtByTargetGoal);
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        this.destroyLeavesBlocks();
        this.doFloorParticleEffect();
        this.doLaserParticleEffects();
        super.m_8107_();
    }

    public static boolean canSpawn(EntityType<StoneGolemEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return StoneGolemEntity.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        this.m_5496_(this.getStepSound(), 3.0f, 1.0f);
        this.m_5496_(this.getStepSound(), 3.0f, 1.2f);
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    private void destroyLeavesBlocks() {
        if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        this.attackTimer = 15;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f);
        this.m_5496_((SoundEvent)SoundInit.STONE_GOLEM_CLAP.get(), 3.0f, 1.0f);
        return flag;
    }

    private void doFloorParticleEffect() {
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (!blockstate.m_60795_()) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
        }
    }

    private void doLaserParticleEffects() {
        if (this.m_6084_()) {
            if (this.m_9236_().f_46443_ && this.hasActiveAttackTarget()) {
                LivingEntity livingentity;
                if (this.clientSideAttackTime < this.getAttackDuration()) {
                    ++this.clientSideAttackTime;
                }
                if ((livingentity = this.getActiveAttackTarget()) != null) {
                    this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                    this.m_21563_().m_8128_();
                    double d5 = this.getAttackAnimationScale(0.0f);
                    double d0 = livingentity.m_20185_() - this.m_20185_();
                    double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                    double d2 = livingentity.m_20189_() - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.f_19796_.m_188500_();
                    while (d4 < d3) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + d0 * (d4 += 1.8 - d5 + this.f_19796_.m_188500_() * (1.7 - d5)), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.hasActiveAttackTarget()) {
                this.m_146922_(this.f_20885_);
            }
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance instance, @NotNull MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        this.m_5496_(this.getSpawnSound(), 4.0f, 1.0f);
        return super.m_6518_(level, instance, type, groupData, compoundTag);
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    public void setActiveAttackTarget(int p_32818_) {
        this.f_19804_.m_135381_(DATA_ID_ATTACK_TARGET, (Object)p_32818_);
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET) != 0;
    }

    public float getAttackAnimationScale(float scale) {
        return ((float)this.clientSideAttackTime + scale) / (float)this.getAttackDuration();
    }

    public float getAttackDamage() {
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            f *= 1.5f;
        }
        return f;
    }

    public int getAttackDuration() {
        return 75;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent getAttackSound() {
        return (SoundEvent)SoundInit.STONE_GOLEM_CLAP.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.STONE_GOLEM_DEATH.get();
    }

    protected SoundEvent getDeathVoiceSound() {
        return (SoundEvent)SoundInit.STONE_GOLEM_GROWL.get();
    }

    public void m_6667_(@NotNull DamageSource src) {
        this.m_5496_(this.getDeathVoiceSound(), 1.5f, 1.0f);
        super.m_6667_(src);
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundInit.STONE_GOLEM_HURT.get();
    }

    protected SoundEvent getSpawnSound() {
        return (SoundEvent)SoundInit.STONE_GOLEM_SPAWN.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)SoundInit.STONE_GOLEM_STEP.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        this.m_5496_(this.getStepSound(), 3.0f, 1.0f);
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        return STONE_GOLEM_LOOT_TABLE;
    }

    public int m_6056_() {
        return 24;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 3.5f;
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.attackTimer = 15;
            this.m_5496_((SoundEvent)SoundInit.STONE_GOLEM_CLAP.get(), 3.0f, 1.0f);
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6673_(@NotNull DamageSource src) {
        return src == this.m_269291_().m_269109_() || src == this.m_269291_().m_269047_() || src == this.m_269291_().m_269318_() || src == this.m_269291_().m_269387_() || src == this.m_269291_().m_269233_() || src == this.m_269291_().m_269549_() || super.m_6673_(src);
    }

    public static boolean isMoving(LivingEntity entity) {
        return entity.m_20185_() != entity.f_19790_ || entity.m_20189_() != entity.f_19792_;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (DATA_ID_ATTACK_TARGET.equals(accessor)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public boolean m_6785_(double distance) {
        return (Boolean)RoRConfig.SERVER.STONE_GOLEMS_DESPAWN.get();
    }

    public void strongKnockback(Entity entity) {
        double d0 = entity.m_20185_() - this.m_20185_();
        double d1 = entity.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }
}

