/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities;

import io.github.colochampre.riskofrain_mobs.RoRConfig;
import io.github.colochampre.riskofrain_mobs.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;

public class LemurianEntity
extends Monster {
    private int attackTimer;
    private boolean selectingHand = true;
    private boolean rightHandSelected = true;

    public LemurianEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 12;
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 6.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WanderingTrader.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22281_, 3.5).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public static boolean canSpawn(EntityType<LemurianEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return LemurianEntity.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        this.m_5496_(this.getStepSound(), 0.8f, 1.0f);
        this.m_5496_(this.getStepSound(), 0.8f, 1.0f);
        return super.m_142535_(p_147187_, p_147188_, p_147189_);
    }

    public boolean m_7327_(Entity entity) {
        this.attackTimer = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        boolean flag = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f);
        this.m_5496_((SoundEvent)SoundInit.LEMURIAN_ATTACK.get(), 1.0f, 1.0f);
        return flag;
    }

    public float getAttackDamage() {
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            f *= 2.0f;
        }
        return f;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean getIsRightHandSelected() {
        this.rightHandSelected = !this.rightHandSelected;
        return this.rightHandSelected;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.LEMURIAN_AMBIENT.get();
    }

    protected SoundEvent getAttackSound() {
        return (SoundEvent)SoundInit.LEMURIAN_ATTACK.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.LEMURIAN_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return (SoundEvent)SoundInit.LEMURIAN_HURT.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)SoundInit.LEMURIAN_STEP.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean getIsSelectedHand() {
        return this.selectingHand;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 1.62f;
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.attackTimer = 10;
            this.m_5496_((SoundEvent)SoundInit.LEMURIAN_ATTACK.get(), 1.0f, 1.0f);
        } else {
            super.m_7822_(b);
        }
    }

    public boolean m_6785_(double distance) {
        return (Boolean)RoRConfig.SERVER.LEMURIANS_DESPAWN.get();
    }

    public void setIsSelectingHand(boolean value) {
        this.selectingHand = value;
    }

    public static boolean isMoving(LivingEntity entity) {
        return entity.m_20185_() != entity.f_19790_ || entity.m_20189_() != entity.f_19792_;
    }
}

