/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities;

import io.github.colochampre.riskofrain_mobs.entities.AbstractFlyingDroneEntity;
import io.github.colochampre.riskofrain_mobs.entities.BulletEntity;
import io.github.colochampre.riskofrain_mobs.entities.goals.GunnerDroneAttackGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GunnerDroneEntity
extends AbstractFlyingDroneEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> DATA_BODY_COLOR = SynchedEntityData.m_135353_(GunnerDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final GunnerDroneAttackGoal attackGoal = new GunnerDroneAttackGoal(this, 16.0f);

    public GunnerDroneEntity(EntityType<? extends GunnerDroneEntity> entity, Level level) {
        super(entity, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, entity -> entity instanceof Enemy && !(entity instanceof Creeper)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    @Override
    public float m_5610_(@NotNull BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 20.0f : 0.0f;
    }

    @Override
    public void m_8107_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        }
        super.m_8107_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BODY_COLOR, (Object)DyeColor.LIGHT_BLUE.m_41060_());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("BodyColor", (byte)this.getBodyColor().m_41060_());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("BodyColor", 99)) {
            this.setBodyColor(DyeColor.m_41053_((int)tag.m_128451_("BodyColor")));
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        DyeColor dyecolor;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof DyeItem && this.m_21824_() && (dyecolor = ((DyeItem)item).m_41089_()) != this.getBodyColor()) {
            this.setBodyColor(dyecolor);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public DyeColor getBodyColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_BODY_COLOR)));
    }

    public void setBodyColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_BODY_COLOR, (Object)color.m_41060_());
    }

    public static boolean checkDroneSpawnRules(EntityType<GunnerDroneEntity> drone, LevelAccessor level, MobSpawnType type, BlockPos pos, RandomSource randomSource) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184234_) && GunnerDroneEntity.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions dimensions) {
        return 0.055f;
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    public void m_6504_(LivingEntity livingentity, float distanceFactor) {
        BulletEntity projectile = new BulletEntity(this.m_9236_(), this);
        double d0 = livingentity.m_20188_() - (double)1.1f;
        double d1 = livingentity.m_20185_() - this.m_20185_();
        double d2 = d0 - projectile.m_20186_();
        double d3 = livingentity.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(Math.sqrt(d0)) * 0.25;
        projectile.shoot(d1, d2 + d4, d3, 4.0f, 1.0f);
        this.m_9236_().m_7967_((Entity)projectile);
    }

    public boolean m_7757_(@NotNull LivingEntity livingentity, @NotNull LivingEntity owner) {
        if (!(livingentity instanceof Creeper)) {
            if (livingentity instanceof Wolf) {
                Wolf wolf = (Wolf)livingentity;
                return !wolf.m_21824_() || wolf.m_269323_() != owner;
            }
            if (livingentity instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)livingentity)) {
                return false;
            }
            if (livingentity instanceof AbstractHorse && ((AbstractHorse)livingentity).m_30614_()) {
                return false;
            }
            if (livingentity instanceof AbstractFlyingDroneEntity && ((AbstractFlyingDroneEntity)livingentity).m_21824_()) {
                return false;
            }
            return !(livingentity instanceof TamableAnimal) || !((TamableAnimal)livingentity).m_21824_();
        }
        return false;
    }
}

