/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities;

import io.github.colochampre.riskofrain_mobs.entities.EntityMobProjectile;
import io.github.colochampre.riskofrain_mobs.entities.GunnerDroneEntity;
import io.github.colochampre.riskofrain_mobs.init.EntityInit;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class BulletEntity
extends EntityMobProjectile {
    public BulletEntity(EntityType type, Level level) {
        super(type, level);
    }

    public BulletEntity(Level worldIn, GunnerDroneEntity drone) {
        super((EntityType)EntityInit.DRONE_BULLET_ENTITY.get(), worldIn, (Mob)drone);
        Vec3 vec3 = drone.m_20182_().m_82549_(this.calcOffsetVec(new Vec3(0.0, 0.0, (double)(0.2f * drone.m_6134_())), 0.0f, drone.m_146908_()));
        this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public BulletEntity(PlayMessages.SpawnEntity entity, Level world) {
        this((EntityType)EntityInit.DRONE_BULLET_ENTITY.get(), world);
    }

    @Override
    public void doBehavior() {
        this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.06f, 0.0));
        }
    }

    @Override
    protected boolean removeInWater() {
        return false;
    }

    @Override
    protected float getDamage() {
        return 1 + this.f_19796_.m_188503_(3);
    }

    @Override
    protected void onEntityHit(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (entity instanceof AbstractVillager || entity instanceof PatrollingMonster || entity instanceof AbstractPiglin) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50375_.m_49966_());
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
        super.onEntityHit(hitResult);
    }

    public void m_7822_(byte event) {
        super.m_7822_(event);
    }

    @Override
    protected void onImpact(HitResult result) {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
        super.onImpact(result);
    }
}

