/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.entities;

import com.google.common.collect.Sets;
import io.github.colochampre.riskofrain_mobs.entities.goals.DroneFollowOwnerGoal;
import io.github.colochampre.riskofrain_mobs.init.SoundInit;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlyingDroneEntity
extends TamableAnimal
implements FlyingAnimal {
    private static final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.f_42417_, Items.f_42587_, Items.f_151053_});
    private static final Set<Item> REPAIR_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.f_42416_, Items.f_42749_, Items.f_151050_});
    private final FloatGoal floatGoal = new FloatGoal((Mob)this);
    private final DroneFollowOwnerGoal followOwnerGoal = new DroneFollowOwnerGoal(this, 1.0, 8.0f, 4.0f, true);
    private final WaterAvoidingRandomFlyingGoal randomFlyingGoal = new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.5);
    private float rollAmount;
    private float rollAmountO;
    private int flyingSound;
    private int underWaterTicks;
    private int goldCount = this.setGoldCount();

    public AbstractFlyingDroneEntity(EntityType<? extends AbstractFlyingDroneEntity> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 16, true);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public float m_5610_(@NotNull BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 20.0f : 0.0f;
    }

    public void m_8107_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)this.followOwnerGoal);
            this.f_21345_.m_25352_(4, (Goal)this.randomFlyingGoal);
            this.f_21345_.m_25352_(6, (Goal)this.floatGoal);
        }
        this.landIfSitting();
        super.m_8107_();
    }

    public void m_8119_() {
        this.doFlyingSound();
        this.smokeIfLowHealth();
        this.waterDamage();
        this.updateRollAmount();
        super.m_8119_();
    }

    private void doFlyingSound() {
        this.flyingSound = !this.m_21824_() || this.m_20096_() || this.m_21825_() || this.m_21827_() ? 0 : ++this.flyingSound;
        if (this.flyingSound == 1 || this.flyingSound == 31) {
            this.m_5496_(this.getFlyingSound(), 0.05f, 1.0f);
            this.flyingSound = 1;
        }
    }

    private void landIfSitting() {
        Vec3 vec3 = this.m_20184_();
        if (this.m_21824_() && this.m_21827_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.1f - vec3.f_82480_, 0.0));
            this.f_19812_ = true;
        } else if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.1f + vec3.f_82480_, 0.0));
        }
    }

    private void smokeIfLowHealth() {
        if (this.isLowHealth() && this.m_21824_()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private void waterDamage() {
        this.underWaterTicks = this.m_20072_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
        }
    }

    public boolean m_142535_(float p_149683_, float p_149684_, @NotNull DamageSource source) {
        return false;
    }

    protected void m_7840_(double p_218316_, boolean p_218317_, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    protected int m_7302_(int air) {
        return air;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance instance, @NotNull MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        String price = String.valueOf(this.goldCount);
        MutableComponent component = Component.m_237113_((String)price).m_130940_(ChatFormatting.YELLOW);
        this.m_6593_((Component)component);
        this.m_20340_(true);
        return super.m_6518_(level, instance, type, groupData, compoundTag);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_()) {
            if (this.m_21223_() < this.m_21233_() && REPAIR_ITEMS.contains(itemstack.m_41720_())) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12009_, this.m_5720_(), 0.2f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                if (itemstack.m_41720_().equals(Items.f_42416_)) {
                    this.m_5634_(18.0f);
                } else if (itemstack.m_41720_().equals(Items.f_151050_)) {
                    this.m_5634_(12.0f);
                } else {
                    this.m_5634_(2.0f);
                }
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.DRONE_REPAIR.get(), this.m_5720_(), 0.2f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                return InteractionResult.SUCCESS;
            }
        } else if (!this.m_21824_()) {
            if (!TAME_ITEMS.contains(itemstack.m_41720_())) {
                MutableComponent notGold = Component.m_237115_((String)"message.riskofrain_mobs.not_gold").m_130940_(ChatFormatting.YELLOW);
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.INSUFFICIENT_FOUNDS_PROC.get(), this.m_5720_(), 0.5f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.CHAT_MESSAGE.get(), this.m_5720_(), 1.0f, 1.0f);
                    player.m_213846_((Component)notGold);
                }
                return InteractionResult.SUCCESS;
            }
            if (TAME_ITEMS.contains(itemstack.m_41720_())) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.COIN_PROC.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                this.goldCount = itemstack.m_41720_().equals(Items.f_42417_) ? (this.goldCount -= 9) : (itemstack.m_41720_().equals(Items.f_151053_) ? (this.goldCount -= 6) : --this.goldCount);
                String price = String.valueOf(this.goldCount);
                MutableComponent component = Component.m_237113_((String)price).m_130940_(ChatFormatting.YELLOW);
                this.m_6593_((Component)component);
                this.m_20340_(true);
                if (!this.m_9236_().f_46443_) {
                    if (this.goldCount <= 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.m_21828_(player);
                        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.DRONE_REPAIR.get(), this.m_5720_(), 0.6f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                        this.m_6593_(null);
                        this.m_20340_(false);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_6667_(@NotNull DamageSource source) {
        this.m_5496_(this.getShutDownSound(), 1.0f, 1.0f);
        super.m_6667_(source);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.DRONE_DEATH1.get();
    }

    protected SoundEvent getShutDownSound() {
        return (SoundEvent)SoundInit.DRONE_DEATH2.get();
    }

    protected SoundEvent getFlyingSound() {
        return (SoundEvent)SoundInit.DRONE_FLYING.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
    }

    private int setGoldCount() {
        Difficulty difficulty = this.m_9236_().m_46791_();
        this.goldCount = difficulty == Difficulty.HARD ? 54 : 36;
        return this.goldCount;
    }

    public float getRollAmount(float pitch) {
        return Mth.m_14179_((float)pitch, (float)this.rollAmountO, (float)this.rollAmount);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = !this.m_29443_() || this.isDroneMoving() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    public boolean m_6573_(@NotNull Player player) {
        return this.m_21824_() && !this.m_21825_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float damage) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            damage = (damage + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, damage);
    }

    public boolean isDroneMoving() {
        return this.m_20185_() != this.f_19790_ || this.m_20186_() != this.f_19791_ || this.m_20189_() != this.f_19792_;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean isLowHealth() {
        double health = this.m_21223_();
        return health < 10.0;
    }

    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob mob) {
        return null;
    }

    public boolean m_35506_() {
        return false;
    }
}

