/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.colochampre.riskofrain_mobs.client.models.StoneGolemModel;
import io.github.colochampre.riskofrain_mobs.client.renderer.layers.StoneGolemEyeLayer;
import io.github.colochampre.riskofrain_mobs.entities.StoneGolemEntity;
import io.github.colochampre.riskofrain_mobs.events.ModClientEvents;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class StoneGolemRenderer
extends MobRenderer<StoneGolemEntity, StoneGolemModel<StoneGolemEntity>> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("riskofrain_mobs", "textures/entity/stone_golem/stone_golem_default.png");
    private static final ResourceLocation BEAM_LOCATION = new ResourceLocation("riskofrain_mobs", "textures/entity/stone_golem/laser_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.m_110458_((ResourceLocation)BEAM_LOCATION);

    public StoneGolemRenderer(EntityRendererProvider.Context context) {
        this(context, ModClientEvents.STONE_GOLEM_LAYER, 1.0f);
        this.m_115326_((RenderLayer)new StoneGolemEyeLayer((RenderLayerParent<StoneGolemEntity, StoneGolemModel<StoneGolemEntity>>)this));
    }

    protected StoneGolemRenderer(EntityRendererProvider.Context context, ModelLayerLocation layerLocation, float shadow) {
        super(context, new StoneGolemModel(context.m_174023_(layerLocation)), shadow);
    }

    public boolean shouldRender(StoneGolemEntity golem, Frustum frustum, double p_114838_, double p_114839_, double p_114840_) {
        LivingEntity livingentity;
        if (super.m_5523_((Mob)golem, frustum, p_114838_, p_114839_, p_114840_)) {
            return true;
        }
        if (golem.hasActiveAttackTarget() && (livingentity = golem.getActiveAttackTarget()) != null) {
            Vec3 vec3 = this.getPosition(livingentity, (double)livingentity.m_20206_() * 0.5, 1.0f);
            Vec3 vec31 = this.getPosition((LivingEntity)golem, golem.m_20192_(), 1.0f);
            return frustum.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity entity, double p_114804_, float p_114805_) {
        double d0 = Mth.m_14139_((double)p_114805_, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)p_114805_, (double)entity.f_19791_, (double)entity.m_20186_()) + p_114804_;
        double d2 = Mth.m_14139_((double)p_114805_, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    public void render(StoneGolemEntity entity, float p_114830_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Mob)entity, p_114830_, partialTicks, poseStack, bufferSource, packedLight);
        this.renderLaser(entity, partialTicks, poseStack, bufferSource);
    }

    private void renderLaser(StoneGolemEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource) {
        LivingEntity livingentity = entity.getActiveAttackTarget();
        if (livingentity != null) {
            float f = entity.getAttackAnimationScale(partialTicks);
            float f1 = (float)entity.m_9236_().m_46467_() + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entity.m_20192_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, f3, 0.0f);
            Vec3 vec3 = this.getPosition(livingentity, (double)livingentity.m_20206_() * 0.5, partialTicks);
            Vec3 vec31 = this.getPosition((LivingEntity)entity, f3, partialTicks);
            Vec3 vec32 = vec3.m_82546_(vec31);
            float f4 = (float)(vec32.m_82553_() + 1.0);
            vec32 = vec32.m_82541_();
            float f5 = (float)Math.acos(vec32.f_82480_);
            float f6 = (float)Math.atan2(vec32.f_82481_, vec32.f_82479_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - f6) * 57.295776f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f5 * 57.295776f));
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int j = 64 + (int)(f8 * 191.0f);
            int k = 32 + (int)(f8 * 191.0f);
            int l = 128 - (int)(f8 * 64.0f);
            float f11 = Mth.m_14089_((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = Mth.m_14031_((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = Mth.m_14089_((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = Mth.m_14031_((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = Mth.m_14089_((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = Mth.m_14031_((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = Mth.m_14089_((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = Mth.m_14031_((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = Mth.m_14089_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = Mth.m_14031_((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = Mth.m_14089_((float)(f7 + 0.0f)) * 0.2f;
            float f22 = Mth.m_14031_((float)(f7 + 0.0f)) * 0.2f;
            float f23 = Mth.m_14089_((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = Mth.m_14031_((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = Mth.m_14089_((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = Mth.m_14031_((float)(f7 + 4.712389f)) * 0.2f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            VertexConsumer vertexconsumer = bufferSource.m_6299_(BEAM_RENDER_TYPE);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entity.f_19797_ % 2 == 0) {
                f31 = 0.5f;
            }
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            StoneGolemRenderer.vertex(vertexconsumer, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            poseStack.m_85849_();
        }
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        vertexConsumer.m_252986_(matrix4f, p_253994_, p_254492_, p_254474_).m_6122_(250, 90, 90, 255).m_7421_(p_254233_, p_253939_).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(StoneGolemEntity entity) {
        return DEFAULT_TEXTURE;
    }
}

