/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.colochampre.riskofrain_mobs.entities.LemurianEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LemurianModel<T extends LemurianEntity>
extends EntityModel<T> {
    protected final ModelPart core;
    protected ModelPart stomach_axis;
    protected ModelPart stomach;
    protected ModelPart rib_cage_axis;
    protected ModelPart rib_cage;
    protected ModelPart neck_axis;
    protected ModelPart neck;
    protected ModelPart head_axis;
    protected ModelPart head;
    protected ModelPart top_head;
    protected ModelPart top_mouth;
    protected ModelPart low_mouth_axis;
    protected ModelPart low_mouth;
    protected ModelPart left_arm_axis;
    protected ModelPart left_arm;
    protected ModelPart left_shoulder_plate;
    protected ModelPart left_forearm_axis;
    protected ModelPart left_forearm;
    protected ModelPart left_claws;
    protected ModelPart right_arm_axis;
    protected ModelPart right_arm;
    protected ModelPart right_shoulder_plate;
    protected ModelPart right_forearm_axis;
    protected ModelPart right_forearm;
    protected ModelPart right_claws;
    protected ModelPart tail_1_axis;
    protected ModelPart tail_1;
    protected ModelPart tail_2_axis;
    protected ModelPart tail_2;
    protected ModelPart tail_3_axis;
    protected ModelPart tail_3;
    protected ModelPart left_leg_1_axis;
    protected ModelPart left_leg_1;
    protected ModelPart left_leg_2_axis;
    protected ModelPart left_leg_2;
    protected ModelPart left_leg_3_axis;
    protected ModelPart left_leg_3;
    protected ModelPart left_foot_axis;
    protected ModelPart left_foot;
    protected ModelPart right_leg_1_axis;
    protected ModelPart right_leg_1;
    protected ModelPart right_leg_2_axis;
    protected ModelPart right_leg_2;
    protected ModelPart right_leg_3_axis;
    protected ModelPart right_leg_3;
    protected ModelPart right_foot_axis;
    protected ModelPart right_foot;
    private boolean rightHandSelected;

    public LemurianModel(ModelPart root) {
        this.core = root.m_171324_("core");
        this.stomach_axis = this.core.m_171324_("stomach_axis");
        this.stomach = this.stomach_axis.m_171324_("stomach");
        this.rib_cage_axis = this.stomach.m_171324_("rib_cage_axis");
        this.rib_cage = this.rib_cage_axis.m_171324_("rib_cage");
        this.neck_axis = this.rib_cage.m_171324_("neck_axis");
        this.neck = this.neck_axis.m_171324_("neck");
        this.head_axis = this.neck.m_171324_("head_axis");
        this.head = this.head_axis.m_171324_("head");
        this.top_head = this.head.m_171324_("top_head");
        this.top_mouth = this.head.m_171324_("top_mouth");
        this.low_mouth_axis = this.head.m_171324_("low_mouth_axis");
        this.low_mouth = this.low_mouth_axis.m_171324_("low_mouth");
        this.left_arm_axis = this.rib_cage.m_171324_("left_arm_axis");
        this.left_arm = this.left_arm_axis.m_171324_("left_arm");
        this.left_shoulder_plate = this.left_arm.m_171324_("left_shoulder_plate");
        this.left_forearm_axis = this.left_arm.m_171324_("left_forearm_axis");
        this.left_forearm = this.left_forearm_axis.m_171324_("left_forearm");
        this.left_claws = this.left_forearm.m_171324_("left_claws");
        this.right_arm_axis = this.rib_cage.m_171324_("right_arm_axis");
        this.right_arm = this.right_arm_axis.m_171324_("right_arm");
        this.right_shoulder_plate = this.right_arm.m_171324_("right_shoulder_plate");
        this.right_forearm_axis = this.right_arm.m_171324_("right_forearm_axis");
        this.right_forearm = this.right_forearm_axis.m_171324_("right_forearm");
        this.right_claws = this.right_forearm.m_171324_("right_claws");
        this.tail_1_axis = this.core.m_171324_("tail_1_axis");
        this.tail_1 = this.tail_1_axis.m_171324_("tail_1");
        this.tail_2_axis = this.tail_1.m_171324_("tail_2_axis");
        this.tail_2 = this.tail_2_axis.m_171324_("tail_2");
        this.tail_3_axis = this.tail_2.m_171324_("tail_3_axis");
        this.tail_3 = this.tail_3_axis.m_171324_("tail_3");
        this.left_leg_1_axis = this.core.m_171324_("left_leg_1_axis");
        this.left_leg_1 = this.left_leg_1_axis.m_171324_("left_leg_1");
        this.left_leg_2_axis = this.left_leg_1.m_171324_("left_leg_2_axis");
        this.left_leg_2 = this.left_leg_2_axis.m_171324_("left_leg_2");
        this.left_leg_3_axis = this.left_leg_2.m_171324_("left_leg_3_axis");
        this.left_leg_3 = this.left_leg_3_axis.m_171324_("left_leg_3");
        this.left_foot_axis = this.left_leg_3.m_171324_("left_foot_axis");
        this.left_foot = this.left_foot_axis.m_171324_("left_foot");
        this.right_leg_1_axis = this.core.m_171324_("right_leg_1_axis");
        this.right_leg_1 = this.right_leg_1_axis.m_171324_("right_leg_1");
        this.right_leg_2_axis = this.right_leg_1.m_171324_("right_leg_2_axis");
        this.right_leg_2 = this.right_leg_2_axis.m_171324_("right_leg_2");
        this.right_leg_3_axis = this.right_leg_2.m_171324_("right_leg_3_axis");
        this.right_leg_3 = this.right_leg_3_axis.m_171324_("right_leg_3");
        this.right_foot_axis = this.right_leg_3.m_171324_("right_foot_axis");
        this.right_foot = this.right_foot_axis.m_171324_("right_foot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition core = parts.m_171599_("core", CubeListBuilder.m_171558_().m_171514_(1, 58).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition stomach_axis = core.m_171599_("stomach_axis", CubeListBuilder.m_171558_().m_171514_(10, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition stomach = stomach_axis.m_171599_("stomach", CubeListBuilder.m_171558_().m_171514_(28, 10).m_171488_(-4.0f, -6.0f, -1.5f, 8.0f, 7.3f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rib_cage_axis = stomach.m_171599_("rib_cage_axis", CubeListBuilder.m_171558_().m_171514_(15, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)-0.25f, (float)0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition rib_cage = rib_cage_axis.m_171599_("rib_cage", CubeListBuilder.m_171558_().m_171514_(1, 10).m_171488_(-4.5f, -5.0f, -2.0f, 9.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck_axis = rib_cage.m_171599_("neck_axis", CubeListBuilder.m_171558_().m_171514_(20, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.5f, (float)0.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition neck = neck_axis.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-3.0f, -4.0f, -1.5f, 6.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_axis = neck.m_171599_("head_axis", CubeListBuilder.m_171558_().m_171514_(25, 60).m_171488_(-0.5f, -0.5f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)0.5f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition head = head_axis.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(20, 2).m_171488_(-2.5f, 0.0f, -4.0f, 5.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.25f, (float)0.25f));
        PartDefinition top_head = head.m_171599_("top_head", CubeListBuilder.m_171558_().m_171514_(77, 3).m_171488_(-2.0f, -0.5f, -2.5f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.25f, (float)-3.5f));
        PartDefinition top_mouth = head.m_171599_("top_mouth", CubeListBuilder.m_171558_().m_171514_(60, 4).m_171488_(-2.5f, -1.0f, -3.0f, 5.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-4.0f));
        PartDefinition low_mouth_axis = head.m_171599_("low_mouth_axis", CubeListBuilder.m_171558_().m_171514_(30, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-2.0f, (float)0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition low_mouth = low_mouth_axis.m_171599_("low_mouth", CubeListBuilder.m_171558_().m_171514_(39, 3).m_171488_(-2.5f, 0.0f, -4.0f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition left_arm_axis = rib_cage.m_171599_("left_arm_axis", CubeListBuilder.m_171558_().m_171514_(35, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-4.0f, (float)0.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = left_arm_axis.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(1, 31).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.5f, (float)0.0f));
        PartDefinition left_shoulder_plate = left_arm.m_171599_("left_shoulder_plate", CubeListBuilder.m_171558_().m_171514_(14, 36).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-0.5f, (float)0.0f));
        PartDefinition left_forearm_axis = left_arm.m_171599_("left_forearm_axis", CubeListBuilder.m_171558_().m_171514_(40, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)9.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition left_forearm = left_forearm_axis.m_171599_("left_forearm", CubeListBuilder.m_171558_().m_171514_(31, 36).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition left_claws = left_forearm.m_171599_("left_claws", CubeListBuilder.m_171558_().m_171514_(40, 36).m_171488_(-0.5f, 0.0f, -1.5f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)0.0f));
        PartDefinition right_arm_axis = rib_cage.m_171599_("right_arm_axis", CubeListBuilder.m_171558_().m_171514_(45, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-4.0f, (float)0.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = right_arm_axis.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(51, 31).m_171488_(-2.0f, -1.0f, -1.5f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.5f, (float)0.0f));
        PartDefinition right_shoulder_plate = right_arm.m_171599_("right_shoulder_plate", CubeListBuilder.m_171558_().m_171514_(64, 36).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-0.5f, (float)0.0f));
        PartDefinition right_forearm_axis = right_arm.m_171599_("right_forearm_axis", CubeListBuilder.m_171558_().m_171514_(50, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition right_forearm = right_forearm_axis.m_171599_("right_forearm", CubeListBuilder.m_171558_().m_171514_(81, 36).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)1.0f, (float)0.0f));
        PartDefinition right_claws = right_forearm.m_171599_("right_claws", CubeListBuilder.m_171558_().m_171514_(90, 36).m_171488_(-1.5f, 0.0f, -1.5f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)0.0f));
        PartDefinition tail_1_axis = core.m_171599_("tail_1_axis", CubeListBuilder.m_171558_().m_171514_(95, 60).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.5f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition tail_1 = tail_1_axis.m_171599_("tail_1", CubeListBuilder.m_171558_().m_171514_(1, 21).m_171488_(-2.0f, 0.0f, -3.0f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_2_axis = tail_1.m_171599_("tail_2_axis", CubeListBuilder.m_171558_().m_171514_(100, 60).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)-0.5f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition tail_2 = tail_2_axis.m_171599_("tail_2", CubeListBuilder.m_171558_().m_171514_(16, 23).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail_3_axis = tail_2.m_171599_("tail_3_axis", CubeListBuilder.m_171558_().m_171514_(105, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.5f, (float)-0.75f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition tail_3 = tail_3_axis.m_171599_("tail_3", CubeListBuilder.m_171558_().m_171514_(27, 25).m_171488_(-1.0f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_1_axis = core.m_171599_("left_leg_1_axis", CubeListBuilder.m_171558_().m_171514_(75, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)0.75f, (float)0.0f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_1 = left_leg_1_axis.m_171599_("left_leg_1", CubeListBuilder.m_171558_().m_171514_(49, 46).m_171488_(-1.0f, -1.0f, -1.75f, 4.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_2_axis = left_leg_1.m_171599_("left_leg_2_axis", CubeListBuilder.m_171558_().m_171514_(80, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)6.0f, (float)-0.5f, (float)0.9599311f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_2 = left_leg_2_axis.m_171599_("left_leg_2", CubeListBuilder.m_171558_().m_171514_(64, 50).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_3_axis = left_leg_2.m_171599_("left_leg_3_axis", CubeListBuilder.m_171558_().m_171514_(85, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.87266463f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg_3 = left_leg_3_axis.m_171599_("left_leg_3", CubeListBuilder.m_171558_().m_171514_(75, 51).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_foot_axis = left_leg_3.m_171599_("left_foot_axis", CubeListBuilder.m_171558_().m_171514_(90, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)3.25f, (float)0.0f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition left_foot = left_foot_axis.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(84, 52).m_171488_(-1.5f, 0.0f, -3.5f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_1_axis = core.m_171599_("right_leg_1_axis", CubeListBuilder.m_171558_().m_171514_(55, 60).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)0.75f, (float)0.0f, (float)-0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_1 = right_leg_1_axis.m_171599_("right_leg_1", CubeListBuilder.m_171558_().m_171514_(1, 46).m_171488_(-3.0f, -1.0f, -1.75f, 4.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_2_axis = right_leg_1.m_171599_("right_leg_2_axis", CubeListBuilder.m_171558_().m_171514_(60, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)6.0f, (float)-0.5f, (float)0.9599311f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_2 = right_leg_2_axis.m_171599_("right_leg_2", CubeListBuilder.m_171558_().m_171514_(16, 50).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_3_axis = right_leg_2.m_171599_("right_leg_3_axis", CubeListBuilder.m_171558_().m_171514_(65, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)-0.87266463f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg_3 = right_leg_3_axis.m_171599_("right_leg_3", CubeListBuilder.m_171558_().m_171514_(27, 51).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_foot_axis = right_leg_3.m_171599_("right_foot_axis", CubeListBuilder.m_171558_().m_171514_(70, 60).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)3.25f, (float)0.0f, (float)0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition right_foot = right_foot_axis.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(36, 52).m_171488_(-1.5f, 0.0f, -3.5f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)110, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.core.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(LemurianEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.getLookAnim(headYaw, headPitch);
        this.getIdleAnim(entity, ageInTicks);
        this.getWalkAnim(entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void prepareMobModel(LemurianEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        int i = entity.getAttackTimer();
        if (i > 0) {
            this.getAttackAnim(entity, i, ageInTicks);
        } else {
            entity.setIsSelectingHand(true);
            this.left_arm_axis.f_104203_ = -0.08726646f + Mth.m_14089_((float)(limbSwing * 0.75f)) * 0.75f * limbSwingAmount;
            this.left_forearm_axis.f_104203_ = -0.2617994f + Mth.m_14089_((float)(limbSwing * 0.75f)) * 0.75f * limbSwingAmount;
            this.right_arm_axis.f_104203_ = -0.08726646f + Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 0.75f * limbSwingAmount;
            this.right_forearm_axis.f_104203_ = -0.2617994f + Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 0.75f * limbSwingAmount;
            this.head_axis.f_104203_ = -0.5235988f + -Mth.m_14089_((float)(limbSwing * 1.5f)) * 0.3f * limbSwingAmount;
            this.neck_axis.f_104203_ = 0.2617994f + Mth.m_14089_((float)(limbSwing * 1.5f)) * 0.3f * limbSwingAmount;
            this.left_arm_axis.f_104205_ = 0.0f;
            this.right_arm_axis.f_104205_ = 0.0f;
            this.rib_cage_axis.f_104203_ = 0.17453292f;
            this.rib_cage_axis.f_104205_ = 0.0f;
            this.stomach_axis.f_104203_ = 0.08726646f;
            this.stomach_axis.f_104205_ = 0.0f;
        }
    }

    private void getLookAnim(float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * 0.023271058f;
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180) / 2.0f;
        this.rib_cage.f_104204_ = headYaw * ((float)Math.PI / 180) / 5.0f;
        this.stomach.f_104204_ = headYaw * ((float)Math.PI / 180) / 5.0f;
    }

    private void getIdleAnim(LemurianEntity entity, float ageInTicks) {
        this.low_mouth.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.09f;
        this.neck.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.06f;
        this.neck.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.06f;
        this.neck.f_104205_ = -Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.06f;
        this.rib_cage.f_104203_ = -Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.06f;
        this.tail_1.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.08f)) * 0.09f;
        this.tail_1.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.06f;
        this.tail_2.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.06f;
        this.tail_3.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.06f;
        if (!LemurianEntity.isMoving((LivingEntity)entity)) {
            this.head_axis.f_104203_ = -0.5235988f + Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.06f;
            this.head_axis.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.05f)) * 0.06f;
            this.head_axis.f_104205_ = -Mth.m_14089_((float)(ageInTicks * 0.05f)) * 0.06f;
            this.left_arm.f_104203_ = -0.17453292f + -Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.03f;
            this.left_arm.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.03f;
            this.right_arm.f_104203_ = -0.17453292f + Mth.m_14089_((float)(ageInTicks * 0.06f)) * 0.03f;
            this.right_arm.f_104205_ = -Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.03f;
        }
    }

    private void getWalkAnim(LemurianEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rib_cage_axis.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 0.15f * limbSwingAmount;
        this.stomach_axis.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 0.3f * limbSwingAmount;
        this.left_arm_axis.f_104204_ = -0.08726646f + Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        this.right_arm_axis.f_104204_ = -0.08726646f + Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 0.4f * limbSwingAmount;
        this.left_leg_1_axis.f_104203_ = -0.34906584f + Mth.m_14089_((float)(limbSwing * 0.75f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.left_leg_2_axis.f_104203_ = 0.9599311f + -Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.0f * limbSwingAmount;
        this.left_leg_3_axis.f_104203_ = -0.87266463f + Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.5f * limbSwingAmount;
        this.left_foot_axis.f_104203_ = 0.34906584f + -Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.right_leg_1_axis.f_104203_ = -0.34906584f + Mth.m_14089_((float)(limbSwing * 0.75f)) * 1.2f * limbSwingAmount;
        this.right_leg_2_axis.f_104203_ = 0.9599311f + -Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.0f * limbSwingAmount;
        this.right_leg_3_axis.f_104203_ = -0.87266463f + Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.5f * limbSwingAmount;
        this.right_foot_axis.f_104203_ = 0.34906584f + -Mth.m_14089_((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
        this.tail_1_axis.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.31f * limbSwingAmount;
        this.tail_2_axis.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.31f * limbSwingAmount;
        this.tail_3_axis.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.31f * limbSwingAmount;
    }

    private void getAttackAnim(LemurianEntity entity, int i, float ageInTicks) {
        int random = RandomSource.m_216327_().m_216332_(1, 3);
        if (entity.getIsSelectedHand()) {
            this.rightHandSelected = entity.getIsRightHandSelected();
            entity.setIsSelectingHand(false);
        }
        if (this.rightHandSelected) {
            this.rightPunch(i, ageInTicks);
        } else {
            this.leftPunch(i, ageInTicks);
        }
    }

    private void rightPunch(int i, float ageInTicks) {
        this.left_arm_axis.f_104203_ = -0.75f + 0.75f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        this.left_arm_axis.f_104205_ = -0.5f + 0.5f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        this.left_forearm_axis.f_104203_ = -1.25f + 1.25f * Mth.m_14156_((float)((float)i - ageInTicks), (float)5.0f);
        this.right_arm_axis.f_104205_ = -(-0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f));
        this.rib_cage_axis.f_104203_ = -(-0.25f + 0.25f * Mth.m_14156_((float)((float)i - ageInTicks), (float)5.0f));
        this.rib_cage_axis.f_104205_ = -0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        this.stomach_axis.f_104203_ = -(-0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f));
        this.stomach_axis.f_104205_ = -0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
    }

    private void leftPunch(int i, float ageInTicks) {
        this.right_arm_axis.f_104203_ = -0.75f + 0.75f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        this.right_arm_axis.f_104205_ = -(-0.5f + 0.5f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f));
        this.right_forearm_axis.f_104203_ = -1.25f + 1.25f * Mth.m_14156_((float)((float)i - ageInTicks), (float)5.0f);
        this.left_arm_axis.f_104205_ = -0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f);
        this.rib_cage_axis.f_104203_ = -(-0.25f + 0.25f * Mth.m_14156_((float)((float)i - ageInTicks), (float)5.0f));
        this.rib_cage_axis.f_104205_ = -(-0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f));
        this.stomach_axis.f_104203_ = -(-0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f));
        this.stomach_axis.f_104205_ = -(-0.1f + 0.1f * Mth.m_14156_((float)((float)i - ageInTicks), (float)10.0f));
    }
}

