/*
 * Decompiled with CFR 0.152.
 */
package io.github.colochampre.riskofrain_mobs.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.colochampre.riskofrain_mobs.entities.GunnerDroneEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.ModelUtils;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GunnerDroneModel<T extends GunnerDroneEntity>
extends EntityModel<T> {
    protected final ModelPart core;
    protected ModelPart eye;
    protected ModelPart eye_ring;
    protected ModelPart top_case;
    protected ModelPart lower_case;
    protected ModelPart eye_ring_left;
    protected ModelPart eye_ring_right;
    protected ModelPart eye_ring_front;
    protected ModelPart eye_ring_back;
    protected ModelPart top_case_left;
    protected ModelPart top_case_right;
    protected ModelPart top_case_front_1_left;
    protected ModelPart top_case_front_1_right;
    protected ModelPart top_case_front_2;
    protected ModelPart top_case_back;
    protected ModelPart top_case_top;
    protected ModelPart top_case_propeller;
    protected ModelPart propeller_rod;
    protected ModelPart wing_left;
    protected ModelPart wing_left_2;
    protected ModelPart wing_right;
    protected ModelPart wing_right_2;
    protected ModelPart wing_front;
    protected ModelPart wing_front_2;
    protected ModelPart wing_back_2;
    protected ModelPart wing_back;
    protected ModelPart lower_case_left;
    protected ModelPart lower_case_right;
    protected ModelPart lower_case_front;
    protected ModelPart lower_case_back;
    protected ModelPart gun_yaw;
    protected ModelPart gun_pitch_axis;
    protected ModelPart gun_pitch;
    protected ModelPart gun_pitch_2;
    private float bodyPitch;

    public GunnerDroneModel(ModelPart root) {
        this.core = root.m_171324_("core");
        this.eye = this.core.m_171324_("eye");
        this.eye_ring = this.eye.m_171324_("eye_ring");
        this.top_case = this.eye.m_171324_("top_case");
        this.lower_case = this.eye.m_171324_("lower_case");
        this.eye_ring_right = this.eye_ring.m_171324_("eye_ring_right");
        this.eye_ring_front = this.eye_ring.m_171324_("eye_ring_front");
        this.eye_ring_left = this.eye_ring.m_171324_("eye_ring_left");
        this.eye_ring_back = this.eye_ring.m_171324_("eye_ring_back");
        this.top_case_propeller = this.top_case.m_171324_("top_case_propeller");
        this.lower_case_right = this.lower_case.m_171324_("lower_case_right");
        this.gun_yaw = this.lower_case.m_171324_("gun_yaw");
        this.gun_pitch_axis = this.gun_yaw.m_171324_("gun_pitch_axis");
        this.lower_case_front = this.lower_case.m_171324_("lower_case_front");
        this.lower_case_back = this.lower_case.m_171324_("lower_case_back");
        this.lower_case_left = this.lower_case.m_171324_("lower_case_left");
        this.gun_pitch = this.gun_pitch_axis.m_171324_("gun_pitch");
        this.gun_pitch_2 = this.gun_pitch.m_171324_("gun_pitch_2");
        this.propeller_rod = this.top_case_propeller.m_171324_("propeller_rod");
        this.wing_left = this.propeller_rod.m_171324_("wing_left");
        this.wing_left_2 = this.wing_left.m_171324_("wing_left_2");
        this.wing_right = this.propeller_rod.m_171324_("wing_right");
        this.wing_right_2 = this.wing_right.m_171324_("wing_right_2");
        this.wing_front = this.propeller_rod.m_171324_("wing_front");
        this.wing_front_2 = this.wing_front.m_171324_("wing_front_2");
        this.wing_back = this.propeller_rod.m_171324_("wing_back");
        this.wing_back_2 = this.wing_back.m_171324_("wing_front_2_1");
        this.top_case_left = this.top_case.m_171324_("top_case_left");
        this.top_case_right = this.top_case.m_171324_("top_case_right");
        this.top_case_front_1_left = this.top_case.m_171324_("top_case_front_1_left");
        this.top_case_front_1_right = this.top_case.m_171324_("top_case_front_1_right");
        this.top_case_front_2 = this.top_case.m_171324_("top_case_front_2");
        this.top_case_back = this.top_case.m_171324_("top_case_back");
        this.top_case_top = this.top_case.m_171324_("top_case_top");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition core = parts.m_171599_("core", CubeListBuilder.m_171558_().m_171514_(1, 35).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eye = core.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(10, 31).m_171488_(-2.0f, -1.0f, -1.75f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition eye_ring = eye.m_171599_("eye_ring", CubeListBuilder.m_171558_().m_171514_(20, 40).m_171488_(-4.0f, -1.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition top_case = eye.m_171599_("top_case", CubeListBuilder.m_171558_().m_171514_(20, 17).m_171488_(-4.0f, -2.5f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)3.0f));
        PartDefinition lower_case = eye.m_171599_("lower_case", CubeListBuilder.m_171558_().m_171514_(20, 51).m_171488_(-4.0f, -0.5f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)3.0f));
        PartDefinition eye_ring_right = eye_ring.m_171599_("eye_ring_right", CubeListBuilder.m_171558_().m_171514_(53, 40).m_171488_(-1.0f, -1.0f, -4.0f, 1.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)0.0f));
        PartDefinition eye_ring_left = eye_ring.m_171599_("eye_ring_left", CubeListBuilder.m_171558_().m_171514_(1, 40).m_171488_(0.0f, -1.0f, -4.0f, 1.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)0.0f, (float)0.0f));
        PartDefinition eye_ring_front = eye_ring.m_171599_("eye_ring_front", CubeListBuilder.m_171558_().m_171514_(72, 47).m_171488_(-4.0f, -1.0f, -0.5f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition eye_ring_back = eye_ring.m_171599_("eye_ring_back", CubeListBuilder.m_171558_().m_171514_(91, 47).m_171488_(-4.0f, -1.0f, -0.5f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition top_case_propeller = top_case.m_171599_("top_case_propeller", CubeListBuilder.m_171558_().m_171514_(34, 12).m_171488_(-1.5f, -0.5f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition lower_case_right = lower_case.m_171599_("lower_case_right", CubeListBuilder.m_171558_().m_171514_(53, 52).m_171488_(-0.5f, -0.5f, -4.0f, 1.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)0.0f));
        PartDefinition gun_yaw = lower_case.m_171599_("gun_yaw", CubeListBuilder.m_171558_().m_171514_(1, 63).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition gun_pitch_axis = gun_yaw.m_171599_("gun_pitch_axis", CubeListBuilder.m_171558_().m_171514_(10, 67).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.5f));
        PartDefinition lower_case_front = lower_case.m_171599_("lower_case_front", CubeListBuilder.m_171558_().m_171514_(72, 59).m_171488_(-4.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.5f));
        PartDefinition lower_case_back = lower_case.m_171599_("lower_case_back", CubeListBuilder.m_171558_().m_171514_(91, 59).m_171488_(-4.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.5f));
        PartDefinition lower_case_left = lower_case.m_171599_("lower_case_left", CubeListBuilder.m_171558_().m_171514_(1, 52).m_171488_(-0.5f, -0.5f, -4.0f, 1.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)0.0f, (float)0.0f));
        PartDefinition gun_pitch = gun_pitch_axis.m_171599_("gun_pitch", CubeListBuilder.m_171558_().m_171514_(15, 62).m_171488_(-0.5f, -0.5f, -5.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition gun_pitch_2 = gun_pitch.m_171599_("gun_pitch_2", CubeListBuilder.m_171558_().m_171514_(30, 63).m_171488_(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-3.5f));
        PartDefinition propeller_rod = top_case_propeller.m_171599_("propeller_rod", CubeListBuilder.m_171558_().m_171514_(47, 10).m_171488_(-0.5f, -5.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition wing_left = propeller_rod.m_171599_("wing_left", CubeListBuilder.m_171558_().m_171514_(1, 5).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.25f, (float)-4.0f, (float)0.0f, (float)-0.174533f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left_2 = wing_left.m_171599_("wing_left_2", CubeListBuilder.m_171558_().m_171514_(3, 4).m_171488_(-2.5f, 0.0f, -1.0f, 5.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)0.5f));
        PartDefinition wing_right = propeller_rod.m_171599_("wing_right", CubeListBuilder.m_171558_().m_171514_(15, 5).m_171488_(0.0f, 0.0f, -0.5f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.25f, (float)-4.0f, (float)0.0f, (float)0.174533f, (float)0.0f, (float)0.0f));
        PartDefinition wing_right_2 = wing_right.m_171599_("wing_right_2", CubeListBuilder.m_171558_().m_171514_(17, 4).m_171488_(-2.5f, 0.0f, -1.0f, 5.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)-0.5f));
        PartDefinition wing_front = propeller_rod.m_171599_("wing_front", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-0.75f, (float)0.0f, (float)0.0f, (float)-0.174533f));
        PartDefinition wing_front_2 = wing_front.m_171599_("wing_front_2", CubeListBuilder.m_171558_().m_171514_(28, 1).m_171488_(-1.0f, 0.0f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)-3.0f));
        PartDefinition wing_back = propeller_rod.m_171599_("wing_back", CubeListBuilder.m_171558_().m_171514_(37, 5).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.75f, (float)0.0f, (float)0.0f, (float)0.174533f));
        PartDefinition wing_back_2 = wing_back.m_171599_("wing_front_2_1", CubeListBuilder.m_171558_().m_171514_(36, 1).m_171488_(-1.0f, 0.0f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)3.0f));
        PartDefinition top_case_left = top_case.m_171599_("top_case_left", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-0.5f, -2.5f, -4.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.5f, (float)0.0f, (float)0.0f));
        PartDefinition top_case_right = top_case.m_171599_("top_case_right", CubeListBuilder.m_171558_().m_171514_(53, 17).m_171488_(-0.5f, -2.5f, -4.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)0.0f, (float)0.0f));
        PartDefinition top_case_front_1_left = top_case.m_171599_("top_case_front_1_left", CubeListBuilder.m_171558_().m_171514_(72, 27).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)1.5f, (float)-4.5f));
        PartDefinition top_case_front_1_right = top_case.m_171599_("top_case_front_1_right", CubeListBuilder.m_171558_().m_171514_(84, 27).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)1.5f, (float)-4.5f));
        PartDefinition top_case_front_2 = top_case.m_171599_("top_case_front_2", CubeListBuilder.m_171558_().m_171514_(72, 22).m_171488_(-4.0f, -1.5f, -0.5f, 8.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-4.5f));
        PartDefinition top_case_back = top_case.m_171599_("top_case_back", CubeListBuilder.m_171558_().m_171514_(91, 24).m_171488_(-4.0f, -1.5f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)4.5f));
        PartDefinition top_case_top = top_case.m_171599_("top_case_top", CubeListBuilder.m_171558_().m_171514_(1, 7).m_171488_(-4.0f, -0.5f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)112, (int)72);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.core.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(GunnerDroneEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f1;
        this.core.f_104203_ = 0.0f;
        this.core.f_104205_ = 0.0f;
        this.eye.f_104203_ = 0.0f;
        this.gun_pitch_axis.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.gun_yaw.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        if (entity.m_21824_() && entity.m_29443_() && !entity.m_21825_()) {
            f1 = ageInTicks * (float)Math.PI * -0.3f;
            this.eye.f_104201_ = Mth.m_14089_((float)(ageInTicks * 0.18f)) * 0.9f;
            this.propeller_rod.f_104204_ = f1;
        } else if (entity.m_20096_()) {
            this.eye.f_104201_ = 0.0f;
            this.propeller_rod.f_104204_ = 0.7853982f;
        }
        if (this.bodyPitch > 0.0f && !entity.m_21824_()) {
            this.core.f_104205_ = ModelUtils.m_103125_((float)this.core.f_104205_, (float)0.2617994f, (float)this.bodyPitch);
            this.core.f_104203_ = ModelUtils.m_103125_((float)this.core.f_104205_, (float)-0.2617994f, (float)this.bodyPitch);
            this.core.f_104201_ = 23.5f;
        } else {
            this.core.f_104201_ = entity.m_20096_() && entity.m_21824_() ? 18.75f : 15.0f;
        }
        if (this.bodyPitch > 0.0f && entity.isDroneMoving()) {
            f1 = Mth.m_14089_((float)(ageInTicks * 0.18f));
            this.eye.f_104203_ = 0.1f + f1 * (float)Math.PI * 0.025f;
        }
    }

    public void prepareMobModel(GunnerDroneEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.bodyPitch = entity.getRollAmount(ageInTicks);
    }
}

