/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.regexp;

import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.regexp.GlobData;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.regexp.RECompiled;
import dev.latvian.mods.rhino.regexp.SubString;

public class RegExp {
    public static final int RA_MATCH = 1;
    public static final int RA_REPLACE = 2;
    public static final int RA_SEARCH = 3;
    protected String input;
    protected boolean multiline;
    protected SubString[] parens;
    protected SubString lastMatch;
    protected SubString lastParen;
    protected SubString leftContext;
    protected SubString rightContext;

    private static NativeRegExp createRegExp(Context cx, Scriptable scope, Object[] args, int optarg, boolean forceFlat) {
        NativeRegExp re;
        Scriptable topScope = ScriptableObject.getTopLevelScope(scope);
        if (args.length == 0 || args[0] == Undefined.instance) {
            RECompiled compiled = NativeRegExp.compileRE(cx, "", "", false);
            re = new NativeRegExp(topScope, compiled, cx);
        } else if (args[0] instanceof NativeRegExp) {
            re = (NativeRegExp)args[0];
        } else {
            String opt;
            String src = ScriptRuntime.toString(cx, args[0]);
            if (optarg < args.length) {
                args[0] = src;
                opt = ScriptRuntime.toString(cx, args[optarg]);
            } else {
                opt = null;
            }
            RECompiled compiled = NativeRegExp.compileRE(cx, src, opt, forceFlat);
            re = new NativeRegExp(topScope, compiled, cx);
        }
        return re;
    }

    private static Object matchOrReplace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RegExp reImpl, GlobData data, NativeRegExp re) {
        String str = data.str;
        data.global = (re.getFlags() & 1) != 0;
        int[] indexp = new int[]{0};
        Object result = null;
        if (data.mode == 3) {
            result = re.executeRegExp(cx, scope, reImpl, str, indexp, 0);
            result = result != null && result.equals(Boolean.TRUE) ? Integer.valueOf(reImpl.leftContext.length) : Integer.valueOf(-1);
        } else if (data.global) {
            re.lastIndex = ScriptRuntime.zeroObj;
            int count = 0;
            while (indexp[0] <= str.length() && (result = re.executeRegExp(cx, scope, reImpl, str, indexp, 0)) != null && result.equals(Boolean.TRUE)) {
                if (data.mode == 1) {
                    RegExp.match_glob(data, cx, scope, count, reImpl);
                } else {
                    if (data.mode != 2) {
                        Kit.codeBug();
                    }
                    SubString lastMatch = reImpl.lastMatch;
                    int leftIndex = data.leftIndex;
                    int leftlen = lastMatch.index - leftIndex;
                    data.leftIndex = lastMatch.index + lastMatch.length;
                    RegExp.replace_glob(data, cx, scope, reImpl, leftIndex, leftlen);
                }
                if (reImpl.lastMatch.length == 0) {
                    if (indexp[0] == str.length()) break;
                    indexp[0] = indexp[0] + 1;
                }
                ++count;
            }
        } else {
            result = re.executeRegExp(cx, scope, reImpl, str, indexp, data.mode == 2 ? 0 : 1);
        }
        return result;
    }

    private static void match_glob(GlobData mdata, Context cx, Scriptable scope, int count, RegExp reImpl) {
        if (mdata.arrayobj == null) {
            mdata.arrayobj = cx.newArray(scope, 0);
        }
        SubString matchsub = reImpl.lastMatch;
        String matchstr = matchsub.toString();
        mdata.arrayobj.put(cx, count, mdata.arrayobj, (Object)matchstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replace_glob(GlobData rdata, Context cx, Scriptable scope, RegExp reImpl, int leftIndex, int leftlen) {
        int replen;
        String lambdaStr;
        if (rdata.lambda != null) {
            SubString[] parens = reImpl.parens;
            int parenCount = parens == null ? 0 : parens.length;
            Object[] args = new Object[parenCount + 3];
            args[0] = reImpl.lastMatch.toString();
            for (int i = 0; i < parenCount; ++i) {
                SubString sub = parens[i];
                args[i + 1] = sub != null ? sub.toString() : Undefined.instance;
            }
            args[parenCount + 1] = reImpl.leftContext.length;
            args[parenCount + 2] = rdata.str;
            if (reImpl != cx.getRegExp()) {
                Kit.codeBug();
            }
            RegExp re2 = new RegExp();
            re2.multiline = reImpl.multiline;
            re2.input = reImpl.input;
            ScriptRuntime.setRegExpProxy(cx, re2);
            try {
                Scriptable parent = ScriptableObject.getTopLevelScope(scope);
                Object result = rdata.lambda.call(cx, parent, parent, args);
                lambdaStr = ScriptRuntime.toString(cx, result);
            }
            finally {
                ScriptRuntime.setRegExpProxy(cx, reImpl);
            }
            replen = lambdaStr.length();
        } else {
            lambdaStr = null;
            replen = rdata.repstr.length();
            if (rdata.dollar >= 0) {
                int[] skip = new int[1];
                int dp = rdata.dollar;
                do {
                    SubString sub;
                    if ((sub = RegExp.interpretDollar(cx, reImpl, rdata.repstr, dp, skip)) != null) {
                        replen += sub.length - skip[0];
                        dp += skip[0];
                        continue;
                    }
                    ++dp;
                } while ((dp = rdata.repstr.indexOf(36, dp)) >= 0);
            }
        }
        int growth = leftlen + replen + reImpl.rightContext.length;
        StringBuilder charBuf = rdata.charBuf;
        if (charBuf == null) {
            rdata.charBuf = charBuf = new StringBuilder(growth);
        } else {
            charBuf.ensureCapacity(rdata.charBuf.length() + growth);
        }
        charBuf.append(reImpl.leftContext.str, leftIndex, leftIndex + leftlen);
        if (rdata.lambda != null) {
            charBuf.append(lambdaStr);
        } else {
            RegExp.do_replace(rdata, cx, reImpl);
        }
    }

    private static SubString interpretDollar(Context cx, RegExp res, String da, int dp, int[] skip) {
        int daL;
        if (da.charAt(dp) != '$') {
            Kit.codeBug();
        }
        if (dp + 1 >= (daL = da.length())) {
            return null;
        }
        char dc = da.charAt(dp + 1);
        if (NativeRegExp.isDigit(dc)) {
            int tmp;
            int num = dc - 48;
            int parenCount = res.parens == null ? 0 : res.parens.length;
            if (num > parenCount) {
                return null;
            }
            int cp = dp + 2;
            if (dp + 2 < daL && NativeRegExp.isDigit(dc = da.charAt(dp + 2)) && (tmp = 10 * num + (dc - 48)) <= parenCount) {
                ++cp;
                num = tmp;
            }
            if (num == 0) {
                return null;
            }
            skip[0] = cp - dp;
            return res.getParenSubString(--num);
        }
        skip[0] = 2;
        return switch (dc) {
            case '$' -> new SubString("$");
            case '&' -> res.lastMatch;
            case '+' -> res.lastParen;
            case '`' -> res.leftContext;
            case '\'' -> res.rightContext;
            default -> null;
        };
    }

    private static void do_replace(GlobData rdata, Context cx, RegExp regExp) {
        int daL;
        StringBuilder charBuf = rdata.charBuf;
        int cp = 0;
        String da = rdata.repstr;
        int dp = rdata.dollar;
        if (dp != -1) {
            int[] skip = new int[1];
            do {
                int len = dp - cp;
                charBuf.append(da, cp, dp);
                cp = dp;
                SubString sub = RegExp.interpretDollar(cx, regExp, da, dp, skip);
                if (sub != null) {
                    len = sub.length;
                    if (len > 0) {
                        charBuf.append(sub.str, sub.index, sub.index + len);
                    }
                    cp += skip[0];
                    dp += skip[0];
                    continue;
                }
                ++dp;
            } while ((dp = da.indexOf(36, dp)) >= 0);
        }
        if ((daL = da.length()) > cp) {
            charBuf.append(da, cp, daL);
        }
    }

    private static int find_split(Context cx, Scriptable scope, String target, String separator, RegExp reProxy, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int i = ip[0];
        int length = target.length();
        if (i > length) {
            return -1;
        }
        if (re != null) {
            return reProxy.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
        }
        if (separator.length() == 0) {
            return i == length ? -1 : i + 1;
        }
        if (ip[0] >= length) {
            return length;
        }
        i = target.indexOf(separator, ip[0]);
        return i != -1 ? i : length;
    }

    public boolean isRegExp(Scriptable obj) {
        return obj instanceof NativeRegExp;
    }

    public Object compileRegExp(Context cx, String source, String flags) {
        return NativeRegExp.compileRE(cx, source, flags, false);
    }

    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return new NativeRegExp(scope, (RECompiled)compiled, cx);
    }

    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        GlobData data = new GlobData();
        data.mode = actionType;
        data.str = ScriptRuntime.toString(cx, thisObj);
        switch (actionType) {
            case 1: {
                int optarg = Integer.MAX_VALUE;
                NativeRegExp re = RegExp.createRegExp(cx, scope, args, optarg, false);
                Object rval = RegExp.matchOrReplace(cx, scope, thisObj, args, this, data, re);
                return data.arrayobj == null ? rval : data.arrayobj;
            }
            case 3: {
                int optarg = Integer.MAX_VALUE;
                NativeRegExp re = RegExp.createRegExp(cx, scope, args, optarg, false);
                return RegExp.matchOrReplace(cx, scope, thisObj, args, this, data, re);
            }
            case 2: {
                Object val;
                boolean useRE = args.length > 0 && args[0] instanceof NativeRegExp;
                NativeRegExp re = null;
                String search = null;
                if (useRE) {
                    re = RegExp.createRegExp(cx, scope, args, 2, true);
                } else {
                    Object arg0 = args.length < 1 ? Undefined.instance : args[0];
                    search = ScriptRuntime.toString(cx, arg0);
                }
                Object arg1 = args.length < 2 ? Undefined.instance : args[1];
                String repstr = null;
                Function lambda = null;
                if (arg1 instanceof Function && !(arg1 instanceof NativeRegExp)) {
                    lambda = (Function)arg1;
                } else {
                    repstr = ScriptRuntime.toString(cx, arg1);
                }
                data.lambda = lambda;
                data.repstr = repstr;
                data.dollar = repstr == null ? -1 : repstr.indexOf(36);
                data.charBuf = null;
                data.leftIndex = 0;
                if (useRE) {
                    val = RegExp.matchOrReplace(cx, scope, thisObj, args, this, data, re);
                } else {
                    String str = data.str;
                    int index = str.indexOf(search);
                    if (index >= 0) {
                        int slen = search.length();
                        this.parens = null;
                        this.lastParen = null;
                        this.leftContext = new SubString(str, 0, index);
                        this.lastMatch = new SubString(str, index, slen);
                        this.rightContext = new SubString(str, index + slen, str.length() - index - slen);
                        val = Boolean.TRUE;
                    } else {
                        val = Boolean.FALSE;
                    }
                }
                if (data.charBuf == null) {
                    if (data.global || val == null || !val.equals(Boolean.TRUE)) {
                        return data.str;
                    }
                    SubString lc = this.leftContext;
                    RegExp.replace_glob(data, cx, scope, this, lc.index, lc.length);
                }
                SubString rc = this.rightContext;
                data.charBuf.append(rc.str, rc.index, rc.index + rc.length);
                return data.charBuf.toString();
            }
        }
        throw Kit.codeBug();
    }

    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable reObj, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int result;
        block3: {
            int i = ip[0];
            int length = target.length();
            NativeRegExp re = (NativeRegExp)reObj;
            while (true) {
                int ipsave = ip[0];
                ip[0] = ++i;
                Object ret = re.executeRegExp(cx, scope, this, target, ip, 0);
                if (!Boolean.TRUE.equals(ret)) {
                    ip[0] = ipsave;
                    matchlen[0] = 1;
                    matched[0] = false;
                    return length;
                }
                i = ip[0];
                ip[0] = ipsave;
                matched[0] = true;
                SubString sep = this.lastMatch;
                matchlen[0] = sep.length;
                if (matchlen[0] != 0 || i != ip[0]) break;
                if (i != length) continue;
                result = -1;
                break block3;
            }
            result = i - matchlen[0];
        }
        int size = this.parens == null ? 0 : this.parens.length;
        parensp[0] = new String[size];
        for (int num = 0; num < size; ++num) {
            SubString parsub = this.getParenSubString(num);
            parensp[0][num] = parsub.toString();
        }
        return result;
    }

    SubString getParenSubString(int i) {
        SubString parsub;
        if (this.parens != null && i < this.parens.length && (parsub = this.parens[i]) != null) {
            return parsub;
        }
        return new SubString();
    }

    public Object js_split(Context cx, Scriptable scope, String target, Object[] args) {
        int match;
        Scriptable test;
        Scriptable result = cx.newArray(scope, 0);
        boolean limited = args.length > 1 && args[1] != Undefined.instance;
        long limit = 0L;
        if (limited) {
            limit = ScriptRuntime.toUint32(cx, args[1]);
            if (limit == 0L) {
                return result;
            }
            if (limit > (long)target.length()) {
                limit = 1 + target.length();
            }
        }
        if (args.length < 1 || args[0] == Undefined.instance) {
            result.put(cx, 0, result, (Object)target);
            return result;
        }
        String separator = null;
        int[] matchlen = new int[1];
        Scriptable re = null;
        RegExp reProxy = null;
        if (args[0] instanceof Scriptable && (reProxy = cx.getRegExp()) != null && reProxy.isRegExp(test = (Scriptable)args[0])) {
            re = test;
        }
        if (re == null) {
            separator = ScriptRuntime.toString(cx, args[0]);
            matchlen[0] = separator.length();
        }
        int[] ip = new int[]{0};
        int len = 0;
        boolean[] matched = new boolean[]{false};
        String[][] parens = new String[][]{null};
        while (!((match = RegExp.find_split(cx, scope, target, separator, reProxy, re, ip, matchlen, matched, parens)) < 0 || limited && (long)len >= limit || match > target.length())) {
            String substr = target.length() == 0 ? target : target.substring(ip[0], match);
            result.put(cx, len, result, (Object)substr);
            ++len;
            if (re != null && matched[0]) {
                int size = parens[0].length;
                for (int num = 0; !(num >= size || limited && (long)len >= limit); ++num) {
                    result.put(cx, len, result, (Object)parens[0][num]);
                    ++len;
                }
                matched[0] = false;
            }
            ip[0] = match + matchlen[0];
        }
        return result;
    }
}

