/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.salju.kobolds.init.KoboldsStructures;
import net.salju.kobolds.init.KoboldsTags;

public class AbstractKoboldStructure
extends Structure {
    public static final Codec<AbstractKoboldStructure> CODEC = RecordCodecBuilder.mapCodec(codex -> codex.group((App)AbstractKoboldStructure.m_226567_((RecordCodecBuilder.Instance)codex), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(temppool -> temppool.startPool), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(heighty -> heighty.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("heightmap").forGetter(mapster -> mapster.heightmap), (App)ResourceLocation.f_135803_.optionalFieldOf("surface_biome_tag").forGetter(tag -> tag.underBiomes)).apply((Applicative)codex, AbstractKoboldStructure::new)).codec();
    public final Holder<StructureTemplatePool> startPool;
    public final HeightProvider startHeight;
    public final Optional<Heightmap.Types> heightmap;
    public final Optional<ResourceLocation> underBiomes;

    public AbstractKoboldStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> pool, HeightProvider height, Optional<Heightmap.Types> map, Optional<ResourceLocation> under) {
        super(config);
        this.startPool = pool;
        this.startHeight = height;
        this.heightmap = map;
        this.underBiomes = under;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos pos = new BlockPos(context.f_226628_().m_45604_(), this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_())), context.f_226628_().m_45605_());
        if (!this.underCheck(context, pos) || this.waterCheck(context, pos)) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)7, (BlockPos)pos, (boolean)false, this.heightmap, (int)120);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)KoboldsStructures.KOBOLD_DEN.get();
    }

    protected boolean underCheck(Structure.GenerationContext context, BlockPos pos) {
        if (!(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            for (int x = context.f_226628_().f_45578_ - 1; x <= context.f_226628_().f_45578_ + 1; ++x) {
                for (int z = context.f_226628_().f_45579_ - 1; z <= context.f_226628_().f_45579_ + 1; ++z) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)x), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175404_((int)z), context.f_226624_().m_224579_());
                    if (!(!this.underBiomes.isEmpty() ? biome.m_203656_(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.underBiomes.get())) : biome.m_203656_(KoboldsTags.BIOMES))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean waterCheck(Structure.GenerationContext context, BlockPos pos) {
        if (!(context.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            for (int x = context.f_226628_().f_45578_ - 3; x <= context.f_226628_().f_45578_ + 3; ++x) {
                for (int z = context.f_226628_().f_45579_ - 3; z <= context.f_226628_().f_45579_ + 3; ++z) {
                    Holder biome = context.f_226623_().m_203407_(QuartPos.m_175404_((int)x), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175404_((int)z), context.f_226624_().m_224579_());
                    if (!biome.m_203656_(BiomeTags.f_207605_) && !biome.m_203656_(BiomeTags.f_207603_)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

