/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.salju.kobolds.item.KoboldPotionItem;

public class KoboldPotionUtils {
    public static ItemStack sellPotion(ItemStack stack, int chance) {
        List<MobEffect> list;
        int i;
        MobEffect primary = null;
        MobEffect secondary = null;
        int fi = 0;
        int si = 0;
        if (chance >= 90) {
            fi = 1200;
            i = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)3);
            list = KoboldPotionUtils.getSpecial();
            primary = list.get(i);
        } else if (chance >= 60) {
            primary = MobEffects.f_19601_;
            secondary = MobEffects.f_19605_;
            fi = 1;
            si = 900;
        } else {
            fi = 3600;
            i = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)6);
            list = KoboldPotionUtils.getCommon();
            primary = list.get(i);
        }
        if (chance >= 95 || chance <= 10) {
            si = 3600;
            i = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)6);
            list = KoboldPotionUtils.getCommon();
            if (list.get(i) != primary) {
                secondary = list.get(i);
            }
        }
        return KoboldPotionUtils.makePotion(stack, primary, secondary, fi, si);
    }

    public static ItemStack makePotion(ItemStack stack, MobEffect first, @Nullable MobEffect second, int fi, int si) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_("KoboldPotionEffects", 9);
        list.add((Object)new MobEffectInstance(first, fi, 0).m_19555_(new CompoundTag()));
        if (second != null) {
            list.add((Object)new MobEffectInstance(second, si, 0).m_19555_(new CompoundTag()));
        }
        tag.m_128365_("KoboldPotionEffects", (Tag)list);
        return stack;
    }

    public static ItemStack copyPotion(ItemStack stack, ItemStack copy) {
        MobEffect primary = null;
        MobEffect secondary = null;
        int fi = 0;
        int si = 0;
        if (copy.m_41720_() instanceof KoboldPotionItem && !KoboldPotionUtils.getEffects(copy).isEmpty()) {
            List<MobEffectInstance> list = KoboldPotionUtils.getEffects(copy);
            for (int i = 0; i < list.size(); ++i) {
                MobEffectInstance instance = list.get(i);
                if (i == 0) {
                    primary = instance.m_19544_();
                    fi = instance.m_19557_();
                    continue;
                }
                if (i != 1) continue;
                secondary = instance.m_19544_();
                si = instance.m_19557_();
            }
        }
        return KoboldPotionUtils.makePotion(stack, primary, secondary, fi, si);
    }

    public static List<MobEffectInstance> getEffects(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        ArrayList effects = Lists.newArrayList();
        if (tag != null && tag.m_128425_("KoboldPotionEffects", 9)) {
            ListTag list = tag.m_128437_("KoboldPotionEffects", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag target = list.m_128728_(i);
                MobEffectInstance instance = MobEffectInstance.m_19560_((CompoundTag)target);
                if (instance == null) continue;
                MobEffect effect = instance.m_19544_();
                int dur = instance.m_19557_();
                if (effect.m_8093_()) {
                    effects.add(new MobEffectInstance(effect, 1, 0, false, false));
                    continue;
                }
                effects.add(new MobEffectInstance(effect, dur, 0));
            }
        }
        return effects;
    }

    public static List<MobEffect> getSpecial() {
        ArrayList effects = Lists.newArrayList();
        effects.add(MobEffects.f_19606_);
        effects.add(MobEffects.f_19600_);
        effects.add(MobEffects.f_19598_);
        effects.add(MobEffects.f_19621_);
        return effects;
    }

    public static List<MobEffect> getCommon() {
        ArrayList effects = Lists.newArrayList();
        effects.add(MobEffects.f_19607_);
        effects.add(MobEffects.f_19608_);
        effects.add(MobEffects.f_19596_);
        effects.add(MobEffects.f_19611_);
        effects.add(MobEffects.f_19609_);
        effects.add(MobEffects.f_19591_);
        effects.add(MobEffects.f_19603_);
        return effects;
    }

    public static int getColor(ItemStack stack) {
        return KoboldPotionUtils.getEffects(stack).isEmpty() ? 0xF800F8 : KoboldPotionUtils.getColor(KoboldPotionUtils.getEffects(stack));
    }

    public static int getColor(List<MobEffectInstance> list) {
        int i = 3694022;
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (MobEffectInstance instance : list) {
            if (!instance.m_19544_().m_8093_() && instance.m_19557_() < 1200) continue;
            int k = instance.m_19544_().m_19484_();
            int l = instance.m_19564_() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }
}

