/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.util;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.orderedchaos.projectvibrantjourneys.core.ProjectVibrantJourneys;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class TreeFeatureUtils {
    public static boolean isIn(Set<ChanceBiomeEntry> Set2, ResourceLocation biome) {
        for (ChanceBiomeEntry entry : Set2) {
            if (!entry.biomeName().equals(biome.toString())) continue;
            return true;
        }
        return false;
    }

    public static ChanceBiomeEntry entry(String biomeName, int chance) {
        return new ChanceBiomeEntry(biomeName, chance);
    }

    public static int getChance(String biomeName, Set<ChanceBiomeEntry> data) {
        for (ChanceBiomeEntry entry : data) {
            if (!entry.biomeName().equals(biomeName)) continue;
            return entry.chance();
        }
        return -1;
    }

    public static int getChance(Biome biome, Set<ChanceBiomeEntry> data) {
        List<Pair> biomes = data.stream().map(entry -> Pair.of((Object)((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(entry.biomeName()))), (Object)entry.chance())).toList();
        for (Pair pair : biomes) {
            if (!((Biome)pair.getFirst()).equals(biome)) continue;
            return (Integer)pair.getSecond();
        }
        return -1;
    }

    public static void serializeAndLoad(String name, String loc, Set<ChanceBiomeEntry> defaults, Set<ChanceBiomeEntry> data) {
        Path path = FMLPaths.CONFIGDIR.get().resolve("projectvibrantjourneys/" + loc + "/" + name + ".json");
        if (!path.toFile().exists()) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new GsonBuilder().setPrettyPrinting().create().toJson(defaults).getBytes(), new OpenOption[0]);
            }
            catch (Exception e) {
                ProjectVibrantJourneys.LOGGER.error(e.toString());
            }
        }
        try {
            String input = Files.readString(path);
            JsonArray array = JsonParser.parseString((String)input).getAsJsonArray();
            array.forEach(element -> {
                JsonObject object = element.getAsJsonObject();
                String biomeName = object.getAsJsonPrimitive("biomeName").getAsString();
                int chance = object.getAsJsonPrimitive("chance").getAsInt();
                data.add(new ChanceBiomeEntry(biomeName, chance));
            });
        }
        catch (Exception e) {
            ProjectVibrantJourneys.LOGGER.error(e.toString());
        }
    }

    public record ChanceBiomeEntry(String biomeName, int chance) {
        public static final Codec<ChanceBiomeEntry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("biomeName").forGetter(ChanceBiomeEntry::biomeName), (App)Codec.intRange((int)0, (int)100).fieldOf("chance").forGetter(ChanceBiomeEntry::chance)).apply((Applicative)builder, ChanceBiomeEntry::new));
    }
}

