/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.data;

import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBiomeModifiers;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJConfiguredFeatures;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPlacements;
import dev.orderedchaos.projectvibrantjourneys.data.PVJBiomeTagsProvider;
import dev.orderedchaos.projectvibrantjourneys.data.PVJBlockLootProvider;
import dev.orderedchaos.projectvibrantjourneys.data.PVJBlockTags;
import dev.orderedchaos.projectvibrantjourneys.data.PVJItemTags;
import dev.orderedchaos.projectvibrantjourneys.data.PVJRecipes;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="projectvibrantjourneys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PVJDataGenerators {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, PVJConfiguredFeatures::bootstrap).m_254916_(Registries.f_256988_, PVJPlacements::bootstrap).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, PVJBiomeModifiers::bootstrap);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        PVJBlockTags blockTags = new PVJBlockTags(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new PVJItemTags(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new PVJRecipes(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new PVJBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, BUILDER, Set.of("projectvibrantjourneys")));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(PVJBlockLootProvider::new, LootContextParamSets.f_81421_))));
    }
}

