/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.MultipleVegetationPatchConfiguration;
import dev.orderedchaos.projectvibrantjourneys.util.LevelUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;

public class MultipleWaterloggedVegetationPatchFeature
extends Feature<MultipleVegetationPatchConfiguration> {
    public MultipleWaterloggedVegetationPatchFeature(Codec<MultipleVegetationPatchConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<MultipleVegetationPatchConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        MultipleVegetationPatchConfiguration config = (MultipleVegetationPatchConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        if (random.m_188501_() > config.placementChance) {
            return false;
        }
        BlockPos blockpos = context.m_159777_();
        Predicate<BlockState> predicate = p_204782_ -> p_204782_.m_204336_(config.replaceable);
        int i = config.xzRadius.m_214085_(random) + 1;
        int j = config.xzRadius.m_214085_(random) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, config, random, blockpos, predicate, i, j);
        this.distributeVegetation(context, worldgenlevel, config, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, BlockPos pos, Predicate<BlockState> replace, int x, int z) {
        Set<BlockPos> set = this.createGround(level, config, rand, pos, replace, x, z);
        HashSet<BlockPos> set1 = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : set) {
            if (MultipleWaterloggedVegetationPatchFeature.isExposed(level, set, blockpos, blockpos$mutableblockpos)) continue;
            set1.add(blockpos);
        }
        for (BlockPos blockpos1 : set1) {
            LevelUtils.setBlock((LevelAccessor)level, blockpos1, Blocks.f_49990_.m_49966_(), 2);
        }
        return set1;
    }

    private static boolean isExposed(WorldGenLevel level, Set<BlockPos> set, BlockPos pos, BlockPos.MutableBlockPos posMutable) {
        return MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.NORTH) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.EAST) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.SOUTH) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.WEST) || MultipleWaterloggedVegetationPatchFeature.isExposedDirection(level, pos, posMutable, Direction.DOWN);
    }

    private static boolean isExposedDirection(WorldGenLevel level, BlockPos pos, BlockPos.MutableBlockPos posMutable, Direction dir) {
        posMutable.m_122159_((Vec3i)pos, dir);
        return !level.m_8055_((BlockPos)posMutable).m_60783_((BlockGetter)level, (BlockPos)posMutable, dir.m_122424_());
    }

    protected Set<BlockPos> createGround(WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, BlockPos pos, Predicate<BlockState> predicate, int x, int z) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        this.carve(set, level, config, rand, pos, predicate, x, z, true);
        this.carve(set, level, config, rand, pos.m_7495_(), predicate, x - 1, z - 1, false);
        return set;
    }

    private void carve(Set<BlockPos> set, WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, BlockPos pos, Predicate<BlockState> predicate, int x, int z, boolean surface) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = blockpos$mutableblockpos.m_122032_();
        Direction direction = config.surface.m_162107_();
        Direction direction1 = direction.m_122424_();
        for (int i = -x; i <= x; ++i) {
            boolean flag = i == -x || i == x;
            for (int j = -z; j <= z; ++j) {
                boolean flag4;
                boolean flag1 = j == -z || j == z;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.extraEdgeColumnChance == 0.0f || rand.m_188501_() > config.extraEdgeColumnChance)) continue;
                blockpos$mutableblockpos.m_122154_((Vec3i)pos, i, 0, j);
                for (int k = 0; (!surface || level.m_7433_((BlockPos)blockpos$mutableblockpos, BlockBehaviour.BlockStateBase::m_60795_)) && k < config.verticalRange; ++k) {
                    blockpos$mutableblockpos.m_122173_(direction);
                }
                for (int i1 = 0; level.m_7433_((BlockPos)blockpos$mutableblockpos, p_204784_ -> !p_204784_.m_60795_()) && i1 < config.verticalRange; ++i1) {
                    blockpos$mutableblockpos.m_122173_(direction1);
                }
                blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos$mutableblockpos, config.surface.m_162107_());
                BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos1);
                if (!blockstate.m_60783_((BlockGetter)level, (BlockPos)blockpos$mutableblockpos1, config.surface.m_162107_().m_122424_())) continue;
                int l = config.depth.m_214085_(rand) + (config.extraBottomBlockChance > 0.0f && rand.m_188501_() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos blockpos = blockpos$mutableblockpos1.m_7949_();
                boolean flag5 = this.placeGround(level, config, predicate, rand, blockpos$mutableblockpos1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
    }

    protected void distributeVegetation(FeaturePlaceContext<MultipleVegetationPatchConfiguration> context, WorldGenLevel level, MultipleVegetationPatchConfiguration config, RandomSource rand, Set<BlockPos> set, int p_160619_, int p_160620_) {
        for (BlockPos blockpos : set) {
            if (config.vegetationChance > 0.0f && rand.m_188501_() < config.vegetationChance) {
                this.placeVegetation(level, config, context.m_159775_(), rand, blockpos);
                if (rand.m_188503_(20) != 0) continue;
                for (int i = 0; i < 32; ++i) {
                    BlockPos pos = blockpos;
                    BlockState blockstate = Blocks.f_50037_.m_49966_();
                    for (int j = 0; j < i / 16; ++j) {
                        if (!level.m_8055_((pos = pos.m_7918_(rand.m_188503_(3) - 1, (rand.m_188503_(3) - 1) * rand.m_188503_(3) / 2, rand.m_188503_(3) - 1)).m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_()) || !blockstate.m_60710_((LevelReader)level, pos)) continue;
                        BlockState blockstate1 = level.m_8055_(pos);
                        if (blockstate1.m_60713_(Blocks.f_49990_) && level.m_6425_(pos).m_76186_() == 8) {
                            LevelUtils.setBlock((LevelAccessor)level, pos, blockstate, 3);
                            continue;
                        }
                        if (blockstate1.m_60713_(Blocks.f_50575_) && rand.m_188499_()) {
                            int l = Math.min((Integer)blockstate1.m_61143_((Property)GrowingPlantHeadBlock.f_53924_) + 1, 25);
                            if (level.m_8055_(pos.m_7494_()).m_60819_().m_76152_() != Fluids.f_76193_) continue;
                            LevelUtils.setBlock((LevelAccessor)level, pos, (BlockState)blockstate1.m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(l)), 3);
                            continue;
                        }
                        if (!blockstate1.m_60713_(Blocks.f_50037_) || rand.m_188503_(3) != 0 || level.m_8055_(pos.m_7494_()).m_60819_().m_76152_() != Fluids.f_76193_) continue;
                        LevelUtils.setBlock((LevelAccessor)level, pos, Blocks.f_50038_.m_49966_(), 3);
                    }
                }
                continue;
            }
            if (level.m_6425_(blockpos).m_76152_() != Fluids.f_76193_ || level.m_8055_(blockpos).m_60734_() != Blocks.f_49990_ || !(rand.m_188501_() < 0.25f)) continue;
            this.tryPlaceCoral(level, blockpos, rand);
        }
    }

    private void tryPlaceCoral(WorldGenLevel level, BlockPos pos, RandomSource rand) {
        if (level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_())) {
            Optional coral;
            if (rand.m_188499_() && (coral = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13064_).getRandomElement(rand)).isPresent()) {
                Block block = (Block)coral.get();
                LevelUtils.setBlock((LevelAccessor)level, pos, block.m_49966_(), 2);
            }
        } else {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Optional coral;
                if (!rand.m_188499_() || !level.m_8055_(pos.m_121945_(direction)).m_60838_((BlockGetter)level, pos.m_121945_(direction)) || !(coral = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13052_).getRandomElement(rand)).isPresent()) continue;
                BlockState blockstate = ((Block)coral.get()).m_49966_();
                if (blockstate.m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                    blockstate = (BlockState)blockstate.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)direction.m_122424_());
                }
                LevelUtils.setBlock((LevelAccessor)level, pos, blockstate, 2);
            }
        }
    }

    protected boolean placeVegetation(WorldGenLevel level, MultipleVegetationPatchConfiguration config, ChunkGenerator chunkGenerator, RandomSource rand, BlockPos pos) {
        boolean flag = false;
        for (Holder<PlacedFeature> feature : config.vegetationFeature) {
            if (!((PlacedFeature)feature.m_203334_()).m_226357_(level, chunkGenerator, rand, pos.m_7495_().m_121945_(config.surface.m_162107_().m_122424_()))) continue;
            BlockState blockstate = level.m_8055_(pos);
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)blockstate.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                LevelUtils.setBlock((LevelAccessor)level, pos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 2);
            }
            flag = true;
        }
        return flag;
    }

    protected boolean placeGround(WorldGenLevel level, MultipleVegetationPatchConfiguration config, Predicate<BlockState> pred, RandomSource rand, BlockPos.MutableBlockPos pos, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            BlockState blockstate1;
            BlockState blockstate = config.groundState.m_213972_(rand, (BlockPos)pos);
            if (blockstate.m_60713_((blockstate1 = level.m_8055_((BlockPos)pos)).m_60734_())) continue;
            if (!pred.test(blockstate1)) {
                return i != 0;
            }
            LevelUtils.setBlock((LevelAccessor)level, (BlockPos)pos, blockstate, 2);
            pos.m_122173_(config.surface.m_162107_());
        }
        return true;
    }
}

