/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraftforge.fart.api.Inheritance;
import net.minecraftforge.fart.api.Renamer;
import net.minecraftforge.fart.api.Transformer;
import net.minecraftforge.fart.internal.RenamerImpl;
import net.minecraftforge.srgutils.IMappingFile;

public class RenamerBuilder
implements Renamer.Builder {
    private File input;
    private File output;
    private final List<File> libraries = new ArrayList<File>();
    private final List<Transformer.Factory> transformerFactories = new ArrayList<Transformer.Factory>();
    private int threads = Runtime.getRuntime().availableProcessors();
    private Consumer<String> logger = System.out::println;
    private Consumer<String> debug = s -> {};

    @Override
    public Renamer.Builder input(File value) {
        this.input = value;
        return this;
    }

    @Override
    public Renamer.Builder output(File value) {
        this.output = value;
        return this;
    }

    @Override
    public Renamer.Builder lib(File value) {
        this.libraries.add(value);
        return this;
    }

    @Override
    public Renamer.Builder map(File value) {
        try {
            this.add(Transformer.renamerFactory(IMappingFile.load(value)));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not map file: " + value.getAbsolutePath(), e);
        }
        return this;
    }

    @Override
    public Renamer.Builder add(Transformer value) {
        this.transformerFactories.add(Transformer.Factory.always(Objects.requireNonNull(value, "value")));
        return this;
    }

    @Override
    public Renamer.Builder add(Transformer.Factory factory) {
        this.transformerFactories.add(Objects.requireNonNull(factory, "factory"));
        return this;
    }

    @Override
    public Renamer.Builder threads(int value) {
        this.threads = value;
        return this;
    }

    @Override
    public Renamer.Builder logger(Consumer<String> out) {
        this.logger = Objects.requireNonNull(out, "out");
        return this;
    }

    @Override
    public Renamer.Builder debug(Consumer<String> debug) {
        this.debug = Objects.requireNonNull(debug, "debug");
        return this;
    }

    @Override
    public Renamer build() {
        final Inheritance inh = Inheritance.create(this.logger);
        Transformer.Context ctx = new Transformer.Context(){

            @Override
            public Consumer<String> getLog() {
                return RenamerBuilder.this.logger;
            }

            @Override
            public Consumer<String> getDebug() {
                return RenamerBuilder.this.debug;
            }

            @Override
            public Inheritance getInheritance() {
                return inh;
            }
        };
        ArrayList<Transformer> transformers = new ArrayList<Transformer>(this.transformerFactories.size());
        for (Transformer.Factory factory : this.transformerFactories) {
            transformers.add(Objects.requireNonNull(factory.create(ctx), "output of " + factory));
        }
        return new RenamerImpl(this.input, this.output, this.libraries, transformers, inh, this.threads, this.logger, this.debug);
    }
}

