/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tn.naizo.remnants.entity.KunaiEntity;
import tn.naizo.remnants.entity.OssukageEntity;
import tn.naizo.remnants.entity.RatEntity;
import tn.naizo.remnants.entity.SkeletonMinionsEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RemnantBossesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"remnant_bosses");
    public static final RegistryObject<EntityType<KunaiEntity>> KUNAI = RemnantBossesModEntities.register("kunai", EntityType.Builder.m_20704_(KunaiEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(KunaiEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<OssukageEntity>> OSSUKAGE = RemnantBossesModEntities.register("ossukage", EntityType.Builder.m_20704_(OssukageEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(OssukageEntity::new).m_20699_(0.9f, 2.5f));
    public static final RegistryObject<EntityType<SkeletonMinionsEntity>> SKELETON_MINIONS = RemnantBossesModEntities.register("skeleton_minions", EntityType.Builder.m_20704_(SkeletonMinionsEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SkeletonMinionsEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<RatEntity>> RAT = RemnantBossesModEntities.register("rat", EntityType.Builder.m_20704_(RatEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RatEntity::new).m_20699_(1.0f, 1.0f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            OssukageEntity.init();
            SkeletonMinionsEntity.init();
            RatEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)OSSUKAGE.get(), OssukageEntity.createAttributes().m_22265_());
        event.put((EntityType)SKELETON_MINIONS.get(), SkeletonMinionsEntity.createAttributes().m_22265_());
        event.put((EntityType)RAT.get(), RatEntity.createAttributes().m_22265_());
    }
}

