/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.gui.screens.inventory;

import com.talhanation.smallships.SmallShipsMod;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.math.Kalkuel;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ShipContainerScreen
extends AbstractContainerScreen<ShipContainerMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("smallships", "textures/gui/ship_inventory.png");
    public static final int FONT_COLOR = 0x404040;
    private final int rowCount;
    private final int pageCount;
    private final int pageIndex;
    private final ContainerShip containerShip;
    private final int offset = 40;

    public ShipContainerScreen(ShipContainerMenu shipContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)shipContainerMenu, inventory, component);
        this.f_97727_ = 114 + ((ShipContainerMenu)this.m_6262_()).getRowCount() * 18;
        this.f_97726_ = 256;
        this.f_97731_ = this.f_97727_ - 94;
        this.containerShip = shipContainerMenu.getContainerShip();
        this.rowCount = ((ShipContainerMenu)this.m_6262_()).getRowCount();
        this.pageCount = ((ShipContainerMenu)this.m_6262_()).getPageCount();
        this.pageIndex = ((ShipContainerMenu)this.m_6262_()).getPageIndex();
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, i, j, f);
        this.m_280072_(guiGraphics, i, j);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int i, int j) {
        int k = 40 + (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(RESOURCE_LOCATION, k, l, 0, 0, this.f_97726_, this.rowCount * 18 + 17);
        guiGraphics.m_280218_(RESOURCE_LOCATION, k, l + this.rowCount * 18 + 17, 0, 126, this.f_97726_, 96);
    }

    protected void m_7856_() {
        this.f_97735_ = 40 + (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            SmallShipsMod.LOGGER.error("Minecraft client or LocalPlayer is null?! Couldn't render page buttons.");
            return;
        }
        Button backward = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"<"), button -> ((ShipContainerMenu)this.m_6262_()).m_6366_((Player)this.f_96541_.f_91074_, -1)).m_252794_(this.f_97735_ + 115, this.f_97736_ + 125).m_253046_(12, 12).m_253136_());
        backward.f_93623_ = this.pageCount > 1 && this.pageIndex + 1 > 1;
        Button forward = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)">"), button -> ((ShipContainerMenu)this.m_6262_()).m_6366_((Player)this.f_96541_.f_91074_, 1)).m_252794_(this.f_97735_ + 157, this.f_97736_ + 125).m_253046_(12, 12).m_253136_());
        forward.f_93623_ = this.pageCount > 1 && this.pageIndex + 1 < this.pageCount;
    }

    protected void m_280003_(GuiGraphics guiGraphics, int i, int j) {
        int maxSpeed;
        String unit;
        super.m_280003_(guiGraphics, i, j);
        String name = this.containerShip.m_5446_().getString();
        String smallShipTypeRaw = this.containerShip.m_6095_().m_20676_().getString();
        String smallShipType = smallShipTypeRaw.substring(0, 1).toUpperCase() + smallShipTypeRaw.substring(1);
        int currentPassengers = this.containerShip.m_20197_().size();
        int maxPassengers = this.containerShip.m_213801_();
        int maxAttachment = 0;
        int currentAttachment = 0;
        ContainerShip containerShip = this.containerShip;
        if (containerShip instanceof Cannonable) {
            Cannonable cannonable = (Cannonable)((Object)containerShip);
            maxAttachment = cannonable.getMaxCannonPerSide() * 2;
            currentAttachment = cannonable.getCannonCount();
        } else {
            containerShip = this.containerShip;
            if (containerShip instanceof Shieldable) {
                Shieldable shieldable = (Shieldable)((Object)containerShip);
                maxAttachment = shieldable.getMaxShieldsPerSide() * 2;
                currentAttachment = shieldable.getShields().size();
            }
        }
        int dmg = (int)(this.containerShip.m_38384_() * 100.0f / this.containerShip.getAttributes().maxHealth);
        int currentSpeed = switch ((Integer)SmallShipsConfig.Client.shipModSpeedUnit.get()) {
            default -> {
                unit = "km/h";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getKilometerPerHour(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getKilometerPerHour(this.containerShip.getSpeed()));
            }
            case 1 -> {
                unit = "m/s";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getMeterPerSecond(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getMeterPerSecond(this.containerShip.getSpeed()));
            }
            case 2 -> {
                unit = "knots";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getKnots(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getKnots(this.containerShip.getSpeed()));
            }
            case 3 -> {
                unit = "mph";
                maxSpeed = Mth.m_14167_((float)Kalkuel.getMilesPerHour(this.containerShip.maxSpeed));
                yield Mth.m_14167_((float)Kalkuel.getMilesPerHour(this.containerShip.getSpeed()));
            }
        };
        int leftPos = 260;
        int leftPos2 = 323;
        int topPos = 38;
        int gap = 14;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        String attachment = this.containerShip instanceof Shieldable ? "Shields:" : "Cannons:";
        guiGraphics.m_280056_(this.f_96547_, "Name:", leftPos, topPos + gap * 0, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Type:", leftPos, topPos + gap * 1, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Crew:", leftPos, topPos + gap * 2, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Speed " + unit + ":", leftPos, topPos + gap * 3, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Damage:", leftPos, topPos + gap * 4, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, attachment, leftPos, topPos + gap * 5, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, name, leftPos2, topPos + gap * 0, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, smallShipType, leftPos2, topPos + gap * 1, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, currentPassengers + "/" + maxPassengers, leftPos2, topPos + gap * 2, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, currentSpeed + "/" + maxSpeed, leftPos2, topPos + gap * 3, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, dmg + "%", leftPos2, topPos + gap * 4, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, currentAttachment + "/" + maxAttachment, leftPos2, topPos + gap * 5, 0x404040, false);
        guiGraphics.m_280168_().m_85849_();
        if (this.pageCount > 1) {
            guiGraphics.m_280056_(this.f_96547_, this.pageIndex + 1 + "/" + this.pageCount, (int)(133.0f - (float)Mth.m_14107_((double)Math.log10(this.pageCount)) * 6.0f), this.rowCount * 18 + 19, 0x404040, false);
        }
    }
}

