/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElytraMiscellaneousCustomizationRecipe
extends CustomRecipe {
    private static final Ingredient CUSTOMIZATION_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151056_, Items.f_42516_});

    public ElytraMiscellaneousCustomizationRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        CustomizableElytraItem wingItem;
        ItemStack stack;
        ItemStack customizableStack = ItemStack.f_41583_;
        ItemStack modifierStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ElytraUtils.isElytra(stack) || stack.m_41720_() instanceof CustomizableElytraItem) {
                if (!customizableStack.m_41619_()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            if (!CUSTOMIZATION_INGREDIENT.test(stack)) continue;
            if (!modifierStack.m_41619_()) {
                return false;
            }
            modifierStack = stack;
        }
        if (customizableStack.m_41619_() || modifierStack.m_41619_()) {
            return false;
        }
        stack = customizableStack.m_41720_();
        if (stack instanceof CustomizableElytraItem && ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(customizableStack, modifierStack, wingItem = (CustomizableElytraItem)stack)) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.m_41720_();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.m_41720_();
        return !ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) || !ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess access) {
        ItemStack stack;
        ItemStack customizableStack = ItemStack.f_41583_;
        ItemStack modifierStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ElytraUtils.isElytra(stack) || stack.m_41720_() instanceof CustomizableElytraItem) {
                if (!customizableStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                customizableStack = stack.m_41777_();
                continue;
            }
            if (!CUSTOMIZATION_INGREDIENT.test(stack)) continue;
            if (!modifierStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            modifierStack = stack;
        }
        if (customizableStack.m_41619_() || modifierStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack = customizableStack.m_41720_();
        if (stack instanceof CustomizableElytraItem) {
            CustomizableElytraItem wingItem = (CustomizableElytraItem)stack;
            if (ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(customizableStack, modifierStack, wingItem)) {
                return ItemStack.f_41583_;
            }
            ElytraMiscellaneousCustomizationRecipe.modifyWing(customizableStack, modifierStack, wingItem);
        } else {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
            ItemStack leftWing = customization.leftWing();
            ItemStack rightWing = customization.rightWing();
            CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.m_41720_();
            CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.m_41720_();
            if (ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(leftWing, modifierStack, leftWingItem) && ElytraMiscellaneousCustomizationRecipe.isWingAlreadyCustomized(rightWing, modifierStack, rightWingItem)) {
                return ItemStack.f_41583_;
            }
            ElytraMiscellaneousCustomizationRecipe.modifyWing(leftWing, modifierStack, (CustomizableElytraItem)leftWing.m_41720_());
            ElytraMiscellaneousCustomizationRecipe.modifyWing(rightWing, modifierStack, (CustomizableElytraItem)rightWing.m_41720_());
            customization.saveToElytra(customizableStack);
        }
        return customizableStack;
    }

    private static void modifyWing(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        if (modifier.m_150930_(Items.f_151056_)) {
            wingItem.setGlowing(wingStack, true);
        } else {
            wingItem.setCapeHidden(wingStack, true);
        }
    }

    private static boolean isWingAlreadyCustomized(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        if (modifier.m_150930_(Items.f_151056_)) {
            return wingItem.isGlowing(wingStack);
        }
        return wingItem.isCapeHidden(wingStack);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ELYTRA_MISCELLANEOUS_CUSTOMIZATION_RECIPE.get();
    }
}

