/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElytraDyeRecipe
extends CustomRecipe {
    public ElytraDyeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        ItemStack customizableStack = ItemStack.f_41583_;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ElytraUtils.isElytra(stack)) {
                if (!customizableStack.m_41619_()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            dyes.add(dyeItem);
        }
        if (customizableStack.m_41619_() || dyes.isEmpty()) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.m_41720_();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.m_41720_();
        return ElytraDyeRecipe.canWingBeCustomized(leftWing, leftWingItem) && ElytraDyeRecipe.canWingBeCustomized(rightWing, rightWingItem);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess access) {
        ItemStack customizableStack = ItemStack.f_41583_;
        ArrayList<DyeItem> dyes = new ArrayList<DyeItem>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ElytraUtils.isElytra(stack)) {
                if (!customizableStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                customizableStack = stack.m_41777_();
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dyeItem = (DyeItem)item;
            dyes.add(dyeItem);
        }
        if (customizableStack.m_41619_() || dyes.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.m_41720_();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.m_41720_();
        if (!ElytraDyeRecipe.canWingBeCustomized(leftWing, leftWingItem) || !ElytraDyeRecipe.canWingBeCustomized(rightWing, rightWingItem)) {
            return ItemStack.f_41583_;
        }
        ElytraDyeRecipe.modifyWing(leftWing, dyes);
        ElytraDyeRecipe.modifyWing(rightWing, dyes);
        customization.saveToElytra(customizableStack);
        return customizableStack;
    }

    private static void modifyWing(ItemStack wingStack, List<DyeItem> modifiers) {
        wingStack.m_41751_(DyeableLeatherItem.m_41118_((ItemStack)wingStack, modifiers).m_41783_());
    }

    private static boolean canWingBeCustomized(ItemStack wingStack, CustomizableElytraItem wingItem) {
        return wingItem.canDye(wingStack);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ELYTRA_DYE_RECIPE.get();
    }
}

