/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.platform;

import com.hidoni.customizableelytra.platform.services.IRegistryHelper;
import com.hidoni.customizableelytra.registry.RegistryEntry;
import com.hidoni.customizableelytra.registry.RegistryProvider;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistryHelper
implements IRegistryHelper {
    @Override
    public <T> RegistryProvider<T> getRegistry(ResourceKey<? extends Registry<T>> resourceKey) {
        final DeferredRegister deferredRegister = DeferredRegister.create(resourceKey, (String)"customizableelytra");
        deferredRegister.register(FMLJavaModLoadingContext.get().getModEventBus());
        return new RegistryProvider<T>(){

            @Override
            public <I extends T> RegistryEntry<I> register(ResourceLocation location, Supplier<? extends I> entrySupplier) {
                final RegistryObject registered = deferredRegister.register(location.m_135815_(), entrySupplier);
                return new RegistryEntry<I>(){

                    @Override
                    public ResourceLocation getResourceLocation() {
                        return registered.getId();
                    }

                    @Override
                    @Nullable
                    public ResourceKey<I> getResourceKey() {
                        return registered.getKey();
                    }

                    @Override
                    public Holder<I> getHolder() {
                        return (Holder)registered.getHolder().orElseThrow(() -> new RuntimeException("No holder present for " + this.getResourceLocation()));
                    }

                    @Override
                    public I get() {
                        return registered.get();
                    }
                };
            }
        };
    }
}

